package newpackage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

/**
 * Aplikacja Autokomis
 * Klasa zajmuj�ca si� po��czeniem z baz� MySQL, oraz dzia�aniami na niej
 * @author Grzegorz Robak
 */

public class MetaDatabase { 
	 private static String driver="jdbc:mysql://";
	 private static String adres="db4free.net";
	 private static String baza="autokomis";
	 private static String url;
	 private static String login="autokomis";
	 private static String pass="autokomis";
	 private static boolean con=false;
	 

	 private static Connection connection;
	 /**
	  * Wczytanie aktualnych danych na temat po��czenia z baz�.
	  * @return zwraca dane nt. bazy danych w formie tablicy obiekt�w String
	  * Poszczeg�lne String'i przechowuj�:
	  * 0 - adres
	  * 1 - nazwa bazy
	  * 2 - login
	  * 3 - haslo
	  */	 
	 public static String[] Dane(){
		 String[] tmp=new String[4];
		 tmp[0]=adres;
		 tmp[1]=baza;
		 tmp[2]=login;
		 tmp[3]=pass;
		 return tmp;
	 }
	 /**
	  * sprawdzenie po��czenie pr�bne z baz� danych
	  * @return wykonuje po��czenie z baz� w celu sprawdzenia czy jest mo�liwe
	  */
	 public static boolean test(){
		 try {
				connection = DriverManager.getConnection(url,login,pass);
				con=true;
				komis.setStatus("Połączono z bazą", false);
				return true;
			} catch (SQLException e) {komis.setStatus("Błąd połączenia", true);return false;} 
	 }
	 /**
	  * ustawia adres bazy
	  * @param adrest nowy adres bazy
	  */
	 public static void ZmienAdresBazy(String adrest){
		 adres=adrest;		 
	 }
	 /**
	  * ustawia nazw� bazy
	  * @param bazat nowa nazwa bazy
	  */
	 public static void ZmianaNazwyBazy(String bazat){
		 baza=bazat;		
	 }
	 /**
	  * Zmienia login wykorzystywany do zalogowania do bazy
	  * @param bazat nowy login
	  */
	 public static void ZmianaLogin(String bazat){
		 login=bazat;		
	 }
	 /**
	  * Zmienia haslo potrzebne do zalogowania do bazy
	  * @param bazat nowe has�o
	  */
	 public static void ZmianaPass(String bazat){
		 pass=bazat;		
	 }
	 /**
	  * przygotowuje adres url wraz z nazw� bazy potrzebnej do po��czenia
	  */
	 public static void zastosuj(){url=driver+adres+":3306/"+baza+"?useUnicode=true&characterEncoding=UTF-8";};
	 /**
	  * kontruktor klasy obs�uguj�co baz� MySQL
	  */
	 public MetaDatabase() { 
	  try {
		  url=driver+adres+":3306/"+baza+"?useUnicode=true&characterEncoding=UTF-8"; 
	   Class.forName("com.mysql.jdbc.Driver"); // zaladowanie sterownika 
	  } 
	  catch(java.lang.ClassNotFoundException e) { 
	   System.err.print("Klasa nieznaleziona: "+e.getMessage());}
	  }
	 /**
	  * Metoda wywo�uj�ca operacja na bazie MySQL maj�ca na celu dodanie nowego klienta do bazy
	  * @param imie Imi� klienta
	  * @param Nazwisko Nazwisko klienta
	  * @param telefon Telefon klienta
	  * @param adres Adres klienta
	  * @param pesel Pesel klient
	  */
	public static void DodajKlient(String imie,String Nazwisko,String telefon,String adres,String pesel)
	{
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "INSERT INTO klient (imie,nazwisko,telefon,adres,pesel) VALUES ('"+imie+"','"+Nazwisko+"','"+telefon+"','"+adres+"','"+pesel+"')";
			   stmt.execute(sql);		
			   connection.close();
			   
		}
		catch (Exception e) {
		    System.err.println("Problem: "+e.getMessage());
		   }		
	}
	/**
	 * Metoda wywo�uj�ca operacja na bazie MySQL maj�ca na celu aktualizacji danych klienta o podanym ID
	  * @param imie Imi� klienta
	  * @param Nazwisko Nazwisko klienta
	  * @param telefon Telefon klienta
	  * @param adres Adres klienta
	  * @param pesel Pesel klient
	 * @param id identyfikator zmienianego klienta
	 */
	public static void UpdateKlient(String imie,String Nazwisko,String telefon,String adres,String pesel,int id)
	{
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql =   "UPDATE `klient` SET `imie` = '"+imie+"',`nazwisko` = '"+Nazwisko+"',`telefon` = '"+telefon+"',`adres` = '"+adres+"',`pesel` = '"+pesel+"' WHERE `id`='"+id+"'";
			   stmt.execute(sql);		
			   connection.close();
			   
		}
		catch (Exception e) {
		    System.err.println("Problem: "+e.getMessage());
		   }		
	}
	/**
	 * kasacja rekordu w zale�no�ci od kontekstu
	 * @param id identyfikator kasowanego rekordu
	 * @param opcja opcja, z kt�rej tablicy nast�pi kasacja rekordu, TRUE dla klienta,FALSE dla aut 
	 */
	public static void Kasuj(int id,boolean opcja)
	{
		String fun=new String();
		if(opcja)
		fun="klient";
		else
		fun="auto";
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "DELETE FROM `"+fun+"` WHERE `id`='"+id+"'";
;
			   stmt.execute(sql);		
			   connection.close();
			   
		}
		catch (Exception e) {
		    System.err.println("Problem: "+e.getMessage());
		   }		
	}
	/**
	 * Metoda wywo�uj�ca operacja na bazie MySQL maj�ca na celu dodanie nowego auta do bazy
	 * @param owner W�a�ciciel nowego auta
	 * @param marka Marka auta
	 * @param model Model auta
	 * @param rok Rok produkcji auta
	 * @param litr Litra� silnika auta
	 * @param cena Cena sprzeda�y auta
	 * @param silnik Typ silnika auta
	 * @param abs Posiadanie ABS
	 * @param wspomaganie Posiadanie wspomagania kierownicy
	 * @param szyby Posiadanie elektrycznie sterowanych liczb
	 * @param klima Posiadanie klimatyzacji
	 */
	public static void DodajAuto(int owner,String marka,String model,int rok,int litr,int cena,String silnik,boolean abs,boolean wspomaganie,boolean szyby,boolean klima)
	{
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "INSERT INTO auto (ownerId,marka,model,rok,litr,cena,silnik,abs,wspomaganie,szyby,klima) VALUES ('"+owner+"','"+marka+"','"+model+"','"+rok+"','"+litr+"','"+cena+"','"+silnik+"','"+(abs ? 1 : 0)+"','"+(wspomaganie ? 1 : 0)+"','"+(szyby ? 1 : 0)+"','"+(klima ? 1 : 0)+"')";                               
			   stmt.execute(sql);		
			   connection.close();
			   
		}
		catch (Exception e) {
		    System.err.println("Problem: "+e.getMessage());
		   }		
	}
	/**
	 * Metoda wywo�uj�ca operacja na bazie MySQL maj�ca na celu zmiany danych auta w bazie
	 * @param owner W�a�ciciel nowego auta
	 * @param marka Marka auta
	 * @param model Model auta
	 * @param rok Rok produkcji auta
	 * @param litr Litra� silnika auta
	 * @param cena Cena sprzeda�y auta
	 * @param silnik Typ silnika auta
	 * @param abs Posiadanie ABS
	 * @param wspomaganie Posiadanie wspomagania kierownicy
	 * @param szyby Posiadanie elektrycznie sterowanych liczb
	 * @param klima Posiadanie klimatyzacji
	 */
	public static void UpdateAuto(int owner,String marka,String model,int rok,int litr,int cena,String silnik,boolean abs,boolean wspomaganie,boolean szyby,boolean klima,int id)
	{
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   //"UPDATE `klient` SET `imie` = '"+imie+"',`nazwisko` = '"+Nazwisko+"',`telefon` = '"+telefon+"',`adres` = '"+adres+"',`pesel` = '"+pesel+"' WHERE `id`='"+id+"'";
			   String sql = "UPDATE `auto` SET `ownerId` = '"+owner+"',`marka` = '"+marka+"',`model` = '"+model+"',`rok` = '"+rok+"',`litr` = '"+litr+"',`abs` = '"+(abs ? 1 : 0)+"',`wspomaganie` = '"+(wspomaganie ? 1 : 0)+"',`szyby` = '"+(szyby ? 1 : 0)+"',`klima` = '"+(klima ? 1 : 0)+"',`silnik` = '"+silnik+"',`cena` = '"+cena+"' WHERE `id`='"+id+"'";                               
			   stmt.execute(sql);		
			   connection.close();
			   
		}
		catch (Exception e) {
		    System.err.println("Problem: "+e.getMessage());
		   }		
	}
	/**
	 * 
	 * @param imie Imi� szukanego klienta
	 * @param nazwisko Nazwisko szukanego klienta
	 * @param fun Opcja wybieraj�ca szukania klienta np. powy�szych danych, bad� ca�ej tablicy
	 * @return Tablica wektor�w/rekord�w posiadaj�ca dane nt. wszystkich b�d� wybranych klient�w
	 */
	public static Vector[] Tablica(String imie,String nazwisko,boolean fun)
	{
		String search = "SELECT * FROM `klient` WHERE imie LIKE '%"+imie+"%' AND nazwisko LIKE '%"+nazwisko+"%' ORDER BY `id` ASC";
		String all = "SELECT *FROM `klient` ORDER BY `id` ASC";
		String sql;
	int i=0;
	if(con)
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   if(fun)
				   sql=all;
			   else
				   sql=search;				   
			   
			   ResultSet klienci = stmt.executeQuery(sql);	
			   /**
			    * p�tla zliczaj�ca ilo�� zwr�conych rekord�w w "klienci"
			    */
			   while(klienci.next())//sprawdzenie ile rekordow zwrocilo zapytanie
			   i++;
			   klienci.first();
			   klienci.previous();
			   Vector<Object>[] rekordy= new Vector[i];
			   i=0;
			   /**
			    * wype�nienie tablicy Vector�w vectorami kt�re przechowuj� dane nt. poszczeg�lnych rekord�w
			    */
			   while(klienci.next())
			   {
				   rekordy[i]=new Vector<Object>();
				   for(byte j=0;j<6;j++)
				   {
				   rekordy[i].add(klienci.getObject(j+1));
				   }
				   i++;
			   }
			   return rekordy;
			   
			   
			   
		}
		catch (Exception e) {
		    System.err.println("Problem w tablicy: "+e.getMessage());
		   }
		return null;
		
	
	}
	public static Vector[] nazwiska()
	{
	byte i=0;
	if(con)
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "SELECT * FROM `klient` ORDER BY `id` ASC";
			   ResultSet klienci = stmt.executeQuery(sql);
			   while(klienci.next())//sprawdzenie ile rekordow zwrocilo zapytanie
			   i++;
			   klienci.first();
			   klienci.previous();
			   Vector<Object>[] rekordy= new Vector[i];
			   i=0;
			   while(klienci.next())
			   {
				   rekordy[i]=new Vector<Object>();
				   for(byte j=0;j<3;j++)
				   {
				   rekordy[i].add(klienci.getObject(j+1));
				   }
				   i++;
			   }
			   return rekordy;
			   
			   
			   
		}
		catch (Exception e) {
		    System.err.println("Problem w nazwiska: "+e.getMessage());
		   }
		return null;
		
	
	}
	
	private static String wlasciciele(int id)
	{
	byte i=0;
	
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "SELECT *FROM `klient` WHERE id='"+id+"' ORDER BY `id` ASC";
			   ResultSet klienci = stmt.executeQuery(sql);
			   String rekord=new String();
			   while(klienci.next())
			   {
				  rekord=klienci.getObject(2).toString()+" "+klienci.getObject(3).toString();
			   }
			   return rekord;
			   
			   
			   
		}
		catch (Exception e) {
		    System.err.println("Problem w nazwiska: "+e.getMessage());
		   }
		return null;
		
	
	}
	/**
	 * @param id identyfikator wybranek klienta
	 * @return Wektor pzechowuj�cy dane pojedy�czego klienta
	 */
	public static Vector<Object> wlasciciel(int id)
	{
	byte i=0;
	
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "SELECT *FROM `klient` WHERE id='"+id+"' ORDER BY `id` ASC";
			   ResultSet klienci = stmt.executeQuery(sql);
			   Vector<Object> rekordy= new Vector<Object>();
			   while(klienci.next())
			   {
				   for(byte j=0;j<6;j++)
				   {
				   rekordy.add(klienci.getObject(j+1));
				   }
			   }
			   return rekordy;
			   
			   
			   
		}
		catch (Exception e) {
		    System.err.println("Problem w nazwiska: "+e.getMessage());
		   }
		return null;
		
	
	}
	/**
	 * Zwraca jeden rekord o podanym ID
	 * @param id identyfikator wybranego auta
	 * @return zwr�cenie pojedy�czego auta o podanym ID
	 */
	public static Vector<Object> auto(int id)
	{
	byte i=0;
	
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "SELECT *FROM `auto` WHERE id='"+id+"'";
			   ResultSet klienci = stmt.executeQuery(sql);
			   Vector<Object> rekordy= new Vector<Object>();
			   while(klienci.next())
			   {
				   for(byte j=0;j<12;j++)
				   {
				   rekordy.add(klienci.getObject(j+1));
				   }
			   }
			   return rekordy;			   
		}
		catch (Exception e) {
		    System.err.println("Problem w nazwiska: "+e.getMessage());
		   }
		return null;	
	}
	/**
	 * metoda wyciag�jaca wszystkie rekordy z tablicy w formie tablicy wektor�w
	 * @return zwraca tablice Vector�w z rekordami nt. aut
	 */
	public static Vector[] TablicaAut()
	{
	byte i=0;
	if(con)
		try {
			   // polaczenie z baza
			   connection = DriverManager.getConnection(url,login,pass); 
			   Statement stmt = connection.createStatement();
			   String sql = "SELECT *FROM `auto` ORDER BY `id` ASC";
			   ResultSet klienci = stmt.executeQuery(sql);
			   while(klienci.next())//sprawdzenie ile rekordow zwrocilo zapytanie
			   i++;
			   klienci.first();
			   klienci.previous();
			   komis.setStatus("Znaleziono "+i+" rekordy.", false);
			   Vector<Object>[] rekordy= new Vector[i];
			   i=0;
			   while(klienci.next())
			   {
				   rekordy[i]=new Vector<Object>();
				   for(byte j=0;j<12;j++)
				   {
					   if(j==1)
						   rekordy[i].add(wlasciciele(Integer.parseInt(klienci.getObject(j+1).toString())));
						   else
					   if(j>7)
						   {
						   boolean tmp;
						   String tmp1=new String();
						   tmp1=klienci.getObject(j+1).toString();
						   if(tmp1=="true")
							   tmp1="TAK";
						   else
							   tmp1="NIE";
						   rekordy[i].add(tmp1);
						   }
					   else
				   rekordy[i].add(klienci.getObject(j+1));
				   }
				   i++;
			   }
			   return rekordy;			   
		}
		catch (Exception e) {
		    System.err.println("Problem w tablicy: "+e.getMessage());
		   }
		return null;
	}
	/**
	 * przeci��ona metoda TablicaAut, kt�ra zwraca tablic� z odpowiednimi danymi
	 * @param marka dane jakiej marki ma szuka�
	 * @param model dane jaki model ma szuka�
	 * @param rok dane jaki rocznik ma by� szukany
	 * @param litr dane jaki litra�
	 * @param cena dane ceny auta
	 * @param silnik dane na temat silnik
	 * @return zwraca tablic� wektor�w wszystkich rekord�w, spe�niaj�cych okreslone wymagania
	 */
	public static Vector[] TablicaAut(String marka,String model, String rok,String litr,String cena,String silnik,String owner)
	{
		byte i=0;
		
			try {
				   // polaczenie z baza
				   connection = DriverManager.getConnection(url,login,pass); 
				   Statement stmt = connection.createStatement();
				   String sql = "SELECT * FROM `auto` WHERE marka LIKE '%"+marka+"%' AND model LIKE '%"+model+"%' AND rok LIKE '%"+rok+"%' AND litr LIKE '%"+litr+"%' AND cena LIKE '%"+cena+"%' AND silnik LIKE '%"+silnik+"%' AND ownerId LIKE '%"+owner+"%' ORDER BY `id` ASC";
				   ResultSet klienci = stmt.executeQuery(sql);
				   while(klienci.next())//sprawdzenie ile rekordow zwrocilo zapytanie
				   i++;
				   klienci.first();
				   klienci.previous();
				   komis.setStatus("Znaleziono "+i+" rekordy.", false);
				   Vector<Object>[] rekordy= new Vector[i];
				   i=0;
				   while(klienci.next())
				   {
					   rekordy[i]=new Vector<Object>();
					   for(byte j=0;j<12;j++)
					   {
						   if(j==1)
							   rekordy[i].add(wlasciciele(Integer.parseInt(klienci.getObject(j+1).toString())));
							   else
						   if(j>7)
							   {
							   boolean tmp;
							   String tmp1=new String();
							   tmp1=klienci.getObject(j+1).toString();
							   if(tmp1=="true")
								   tmp1="TAK";
							   else
								   tmp1="NIE";
							   rekordy[i].add(tmp1);
							   }
						   else
					   rekordy[i].add(klienci.getObject(j+1));
					   }
					   i++;
				   }
				   return rekordy;			   
			}
			catch (Exception e) {
			    System.err.println("Problem w tablicy: "+e.getMessage());
			   }
			return null;
		}
}

	
	  