package newpackage;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.miginfocom.swing.MigLayout;

/**
 * Aplikacja Autokomis
 * Klasa pe�ni�ca funkcj� panelu programu, daje mo�liwo�� dodawania nowych aut
 * @author Grzegorz Robak
 *
 */

public class PanelDodaj extends JPanel implements ActionListener,MouseListener {
	/**
	 * tablica JLabel i komponenty potrzebne do zrealizowania zadania
	 */
	private JLabel[] etykiety = new JLabel[11];
	private JButton dodaj;
	private JButton odswiez;
	private JTextField litr;
	private JTextField cena;
	private JTextField silnik;
	private JTextField rok;
	private JComboBox marka;
	private JComboBox owner;
	private JTextField model;
	private JCheckBox abs;
	private JCheckBox wspomaganie;
	private JCheckBox szyby;
	private JCheckBox klima;
	private Dimension preferowana=new Dimension(300,30);
	/**
	 * kostruktor, inicjalizuje wszystkie komponenty z odpowiednimi parametrami
	 */
	public PanelDodaj() {
		if(MetaDatabase.test())
		komis.setStatus("Baza ok",false);
		else
			komis.setStatus("Błąd bazy",true);
		setLayout(new MigLayout("wrap 2"));
		etykiety[2] = new JLabel("Marka");
		etykiety[3] = new JLabel("Rok");
		etykiety[4] = new JLabel("Napęd");
		etykiety[5] = new JLabel("Przebieg [km]");
		etykiety[6] = new JLabel("Model");
		etykiety[7] = new JLabel("Litraż [cm3]");
		etykiety[8] = new JLabel("Cena [PLN]");
		etykiety[9] = new JLabel("Właściciel");
		etykiety[10] = new JLabel("Silnik");
		abs = new JCheckBox("ABS");
		silnik = new JTextField();
		cena = new JTextField();
		litr = new JTextField();
		klima = new JCheckBox("Klimatyzacja");
		wspomaganie = new JCheckBox("Wspomaganie kierownicy");
		szyby = new JCheckBox("El. szyby");
		marka = new JComboBox(auta.marki);
		owner = new JComboBox();
		this.odswiezWlasnosc();
		rok = new JTextField();
		model = new JTextField();
		dodaj = new JButton("Dodaj");		
		//dodanie komponentów do Panelu
		this.add(etykiety[2]);
		this.add(marka);
		this.add(etykiety[6]);
		this.add(model);
		this.add(etykiety[3]);
		this.add(rok);
		this.add(etykiety[7]);
		this.add(litr);
		this.add(etykiety[10]);
		this.add(silnik);
		this.add(etykiety[8]);
		this.add(cena);
		this.add(etykiety[9]);
		this.add(owner);
		this.add(abs);
		this.add(wspomaganie);
		this.add(szyby);
		this.add(klima);
		owner.setActionCommand("wlasc");
		dodaj.setActionCommand("dodaj");
		dodaj.addActionListener(this);
		owner.addMouseListener(this);
		this.add(dodaj,"span 2");
		this.ustawRozmiary();
		dodaj.setPreferredSize(new Dimension(600,30));
	}
		
	/**
	 * implementacja metody z interface'u ActionListener
	 * wywo�uje metod� statyczn� klasy MetaDatabase
	 */
	public void actionPerformed(ActionEvent arg0) {
		 //wy�uskanie ID klienta do przypisania mu auta
		int tmp = Integer.parseInt(MetaDatabase.Tablica(null,null,true)[owner.getSelectedIndex()].elementAt(0).toString());		
		 //wywo�anie metody statycznej z klasy MetaDatabase
		
		
		if(komis.sprawdzCzyLiczba(cena.getText()))
			if(komis.sprawdzCzyLiczba(litr.getText(),4))
				if(komis.sprawdzCzyLiczba(rok.getText(),4)){
		MetaDatabase.DodajAuto(tmp, marka.getSelectedItem().toString(), model.getText(),Integer.parseInt(rok.getText()), Integer.parseInt(litr.getText()), Integer.parseInt(cena.getText()), silnik.getText(), abs.isSelected(), wspomaganie.isSelected(),
				szyby.isSelected(), klima.isSelected());
		komis.setStatus("Dodano auto: "+marka.getSelectedItem().toString()+" "+model.getText(),false);}
				else
					komis.setStatus("Popraw rok produkcji.",true);
				else
					komis.setStatus("Popraw litraż silnika auta.",true);
				else
					komis.setStatus("Popraw cenę auta.",true);

	
		
	}
	private void ustawRozmiary(){
		for(int i=0;i<this.getComponentCount();i++)
			this.getComponent(i).setPreferredSize(this.preferowana);
	}
	private void odswiezWlasnosc(){
		try{
			Vector<Object>[] in=MetaDatabase.nazwiska();
			this.owner.removeAllItems();
			int rekordy=in.length;
			String []tmp=new String[rekordy];
			for(int i=0;i<rekordy;i++){
			tmp[i]=in[i].get(0)+". "+in[i].get(1)+" "+in[i].get(2);
			this.owner.addItem(tmp[i]);
			}
			this.repaint();}
		catch(NullPointerException e){}
		
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseClicked(MouseEvent arg0) {
	}
	/**
	 * wywo�uje metod� od�wierzaj�c� zawarto�� komponentu "owner".
	 * przy klikni�ciu otrzymujemy najauktualniejsz� list� klient�w.
	 */
	public void mouseEntered(MouseEvent arg0) {
		odswiezWlasnosc();
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseExited(MouseEvent arg0) {
		
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mousePressed(MouseEvent arg0) {
		
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseReleased(MouseEvent arg0) {
	}

}

