package newpackage;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

import net.miginfocom.swing.MigLayout;


/**
 * Aplikacja Autokomis
 * Klasa odpowiedzialna za zawarto�� zak�adki Szukaj, oraz obs�ug� akcji w niej zachodz�cych
 * @author Grzegorz Robak
 */

public class PanelSzukaj extends JPanel implements ActionListener,MouseListener{
	
	private wynik Wynik;
	private JButton szukaj=new JButton("Szukaj");
	private JButton szukajAuto=new JButton("Szukaj");
	private JLayeredPane menuAuto;
	private JLayeredPane menuKlient;
	private JLabel[] etykiety = new JLabel[9];
	private JTextField imie=new JTextField();;
	private JTextField nazwisko=new JTextField();
	private JTextField litr=new JTextField();
	private JTextField cena=new JTextField();
	private JTextField silnik=new JTextField();
	private JTextField rok=new JTextField();
	private JComboBox marka=new JComboBox(auta.marki);
	private JComboBox owner=new JComboBox();
	private JTextField model=new JTextField();
	private JCheckBox abs= new JCheckBox("ABS");
	private JCheckBox wspomaganie=new JCheckBox("Wspomaganie");
	private JCheckBox szyby=new JCheckBox("El.szyby");
	private JCheckBox klima=new JCheckBox("Klima");
	private JScrollPane scroll;

	public PanelSzukaj()
	{
		this.setLayout(null);
		this.odswiezWlasnosc();
		this.setPreferredSize(new Dimension(230,590));
		this.setMaximumSize(new Dimension(230,590));
		this.setMinimumSize(new Dimension(230,590));
		Wynik=new wynik();

		menuKlient=new JLayeredPane();		
		menuKlient.setLayout(new MigLayout("wrap 1"));
	
		menuKlient.setBorder(BorderFactory.createBevelBorder(1));
		menuKlient.setMinimumSize(new Dimension(230,130));
		menuKlient.setMaximumSize(new Dimension(230,130));
		menuKlient.setPreferredSize(new Dimension(200,130));
		etykiety[0] = new JLabel("Szukaj klienta:");
		etykiety[0].setMinimumSize(new Dimension(230,50));
		etykiety[0].setMaximumSize(new Dimension(230,50));
		etykiety[0].setPreferredSize(new Dimension(230,50));
		imie.setMinimumSize(new Dimension(190,25));
		imie.setMaximumSize(new Dimension(190,25));
		imie.setPreferredSize(new Dimension(190,25));
		nazwisko.setMinimumSize(new Dimension(190,25));
		nazwisko.setMaximumSize(new Dimension(190,25));
		nazwisko.setPreferredSize(new Dimension(190,25));
		etykiety[0] = new JLabel("Szukaj klienta:");
		menuKlient.add(etykiety[0]);		
		menuKlient.add(new JLabel("Imię"));
		menuKlient.add(imie);
		menuKlient.add(new JLabel("Nazwisko"));
		menuKlient.add(nazwisko);
		szukaj.setPreferredSize(new Dimension(190,40));
		szukaj.setMaximumSize(new Dimension(190,40));
		menuKlient.add(szukaj);
		menuKlient.setVisible(true);
		menuAuto=new JLayeredPane();
		menuAuto.setLayout(new MigLayout("wrap 2"));
		menuAuto.setBorder(BorderFactory.createBevelBorder(1));
		menuAuto.setMinimumSize(new Dimension(230,300));
		menuAuto.setMaximumSize(new Dimension(230,300));
		menuAuto.setPreferredSize(new Dimension(230,300));
	
		etykiety[0] = new JLabel("Marka");
		etykiety[1] = new JLabel("Rok");
		etykiety[2] = new JLabel("Napęd");
		etykiety[3] = new JLabel("Przebieg");
		etykiety[4] = new JLabel("Model");
		etykiety[5] = new JLabel("Litraż");
		etykiety[6] = new JLabel("Cena");
		etykiety[7] = new JLabel("Właściciel");
		etykiety[8] = new JLabel("Silnik");
		marka.setPreferredSize(new Dimension(95,55));
		etykiety[0].setPreferredSize(new Dimension(95,65));
		model.setPreferredSize(new Dimension(95,55));
		etykiety[1].setPreferredSize(new Dimension(95,65));
		rok.setPreferredSize(new Dimension(95,55));
		etykiety[4].setPreferredSize(new Dimension(95,65));
		litr.setPreferredSize(new Dimension(95,55));
		etykiety[5].setPreferredSize(new Dimension(95,65));
		silnik.setPreferredSize(new Dimension(95,55));
		etykiety[6].setPreferredSize(new Dimension(95,65));
		cena.setPreferredSize(new Dimension(95,55));
		owner.setPreferredSize(new Dimension(110,25));
		owner.setMinimumSize(new Dimension(110,25));
		owner.setMaximumSize(new Dimension(110,25));
		etykiety[8].setPreferredSize(new Dimension(95,65));
		szukajAuto.setPreferredSize(new Dimension(190,50));
		Dimension roz=new Dimension(110,35);
		menuAuto.add(etykiety[0]);
		menuAuto.add(marka);
		menuAuto.add(etykiety[4]);
		menuAuto.add(model);
		menuAuto.add(etykiety[1]);
		menuAuto.add(rok);
		menuAuto.add(etykiety[5]);
		menuAuto.add(litr);
		menuAuto.add(etykiety[8]);
		menuAuto.add(silnik);
		menuAuto.add(etykiety[6]);
		menuAuto.add(cena);
		menuAuto.add(etykiety[7]);
		owner.addMouseListener(this);
		menuAuto.add(owner);
		
		menuAuto.add(szukajAuto,"span 2");
		ustawRozmiar(menuAuto,roz);
		ustawRozmiar(menuKlient,roz);
		szukajAuto.setPreferredSize(new Dimension(220,35));
		menuAuto.setVisible(true);
		
		szukaj.addActionListener(this);
		szukajAuto.addActionListener(this);
		szukajAuto.setActionCommand("auto");
		menuAuto.setBounds(0, 0, 220, 220);
		menuKlient.setBounds(0, 220, 220, 180);
		scroll=new JScrollPane(Wynik);
		scroll.setBounds(225, 0, 562, 530);
		scroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		scroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		
		this.add(menuKlient);
		this.add(menuAuto);
		this.add(scroll);	
	}
	private void odswiezWlasnosc(){
		try{
			Vector<Object>[] in=MetaDatabase.nazwiska();
			this.owner.removeAllItems();
			int rekordy=in.length;
			this.owner.addItem("");
			String []tmp=new String[rekordy];
			for(int i=0;i<rekordy;i++){
			tmp[i]=in[i].get(0)+" . "+in[i].get(1)+" "+in[i].get(2);
			this.owner.addItem(tmp[i]);
			}
			this.repaint();}
		catch(NullPointerException e){}
		
	}
	private void ustawRozmiar(JLayeredPane comp,Dimension roz){
		int i=comp.getComponentCount();
		for(int k=0;k<i;k++)
			comp.getComponent(k).setPreferredSize(roz);
		
	}
	public void actionPerformed(ActionEvent AE) {

		
			if(AE.getActionCommand()=="Szukaj")
				{
				Wynik.Wiersze(imie.getText(),nazwisko.getText());
				}
			if(AE.getActionCommand()=="auto")
			{
			Wynik.WierszeAut(marka.getSelectedItem().toString(), model.getText(), rok.getText(), litr.getText(), cena.getText(), silnik.getText(),(owner.getSelectedItem().toString()).split(" ")[0].substring(0));
			System.out.println((owner.getSelectedItem().toString()).split(" ")[0].substring(0));
			}
		
			
		}
	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseClicked(MouseEvent arg0) {
		
	}
	/**
	 * wywo�uje metod� od�wierzaj�c� zawarto�� komponentu "owner".
	 * przy klikni�ciu otrzymujemy najauktualniejsz� list� klient�w.
	 */
	public void mouseEntered(MouseEvent arg0) {
		odswiezWlasnosc();
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseExited(MouseEvent arg0) {
		
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mousePressed(MouseEvent arg0) {
		
	}

	/**
	 * "pusta" implemencja metody. Zb�dna do funkcjonowania aplikacji
	 */
	public void mouseReleased(MouseEvent arg0) {
	}
}

class wynik extends JPanel{
	private JTableHeader header;
	private String[] etykiety_aut={"ID","Właściciel","Marka","Model","Rok","Litr","Cena","Silnik","Abs","Wsp","El.S","Kli"};
	private String[] etykiety_klient={"Id","Imię","Nazwisko","Telefon","Adres","Pesel"};
	private DefaultTableModel model = new DefaultTableModel();
	private JTable tablica;
	public wynik() {		
		this.setLayout(new MigLayout());
		tablica = new JTable(model) {
			public boolean isCellEditable(int rowIndex, int colIndex) {
				return false; // Disallow the editing of any cell
			}
		};
		tablica.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				int row = tablica.getSelectedRow();
				try{
				int id = Integer.parseInt(tablica.getValueAt(row, 0).toString());
                                if("Imię".equals(tablica.getColumnName(1))){
				new edytor(id, true);}
                                if("Właściciel".equals(tablica.getColumnName(1))){
                                new edytor(id, false);}
				}
				catch (Exception error) {
				    System.err.println("Problem w tablicy: "+error.getMessage());
				   }
			}
		});
		
		header=tablica.getTableHeader();
		this.add(header,"dock north");
		this.add(tablica);
		
		this.repaint();
		
	}

	public void Wiersze(String imie,String nazwisko) {
		
	    //this.header = new JTableHeader(this.etykiety_aut);
		this.model.setColumnCount(0);
		for(String i:this.etykiety_klient)
		this.model.addColumn(i);
		this.model.setColumnCount(6);	
		header=tablica.getTableHeader();
		this.model.getDataVector().removeAllElements();
		Vector [] tmp=MetaDatabase.Tablica(imie,nazwisko,false);
		for (int i = 0; i < tmp.length; i++)
			this.model.addRow(tmp[i]);
		komis.setStatus("Znaleziono "+tmp.length+" rekordów.",false);
		this.repaint();	
	}
	public void WierszeAut(String marka,String model, String rok,String litr,String cena,String silnik,String owner)
	{
		this.model.setColumnCount(0);
		for(String i:this.etykiety_aut)
		this.model.addColumn(i);
		this.model.setColumnCount(12);
		header=tablica.getTableHeader();
		this.tablica.getColumnModel().getColumn(0).setPreferredWidth(20);
		this.tablica.getColumnModel().getColumn(1).setPreferredWidth(130);
		this.tablica.getColumnModel().getColumn(2).setPreferredWidth(60);
		this.tablica.getColumnModel().getColumn(3).setPreferredWidth(60);
		this.tablica.getColumnModel().getColumn(4).setPreferredWidth(40);
		this.tablica.getColumnModel().getColumn(5).setPreferredWidth(40);
		this.tablica.getColumnModel().getColumn(6).setPreferredWidth(50);
		this.tablica.getColumnModel().getColumn(7).setPreferredWidth(50);
		this.tablica.getColumnModel().getColumn(8).setPreferredWidth(25);
		this.tablica.getColumnModel().getColumn(9).setPreferredWidth(25);
		this.tablica.getColumnModel().getColumn(10).setPreferredWidth(25);
		this.tablica.getColumnModel().getColumn(11).setPreferredWidth(25);
		this.model.getDataVector().removeAllElements();
		Vector [] tmp=MetaDatabase.TablicaAut(marka,model, rok,litr,cena,silnik,owner);
		for (int i = 0; i < tmp.length; i++)
			this.model.addRow(tmp[i]);
		komis.setStatus("Znaleziono "+tmp.length+" rekordów.",false);
		this.repaint();		
	}
	

	



}
