package cliente;

import java.sql.ResultSet;
import java.util.ArrayList;

import com.mysql.jdbc.Connection;

import conexao.ConectarComBanco;

public class RepositorioClienteBDR implements IRepositorioCliente{
	

	@Override
	public void ClienteCadastrar(Cliente cliente) throws ClienteJaCadastradoException {
		
	String sql = "INSERT INTO cliente (nome, cpf, endereco, telefone, email, sexo)" + "VALUES(?,?,?,?,?,?)";
	
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, cliente.getNome());
			prstm.setString(2, cliente.getCpf());
			prstm.setString(3, cliente.getEndereco());
			prstm.setString(4, cliente.getTelefone());
			prstm.setString(5, cliente.getEmail());
			prstm.setString(6, cliente.getSexo());
			
			prstm.execute();
		
		}catch (Exception e){
			
			e.printStackTrace();
		
		
		}finally{
			
			try{
				
				if (prstm != null){
					prstm.close();
				}
				if (conn != null){
					conn.close();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			
		}
		
	}

	@Override
	public void ClienteRemover(String cpf) {
		
		String sql = "DELETE FROM cliente WHERE cpf = ?";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null; 
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.clientPrepareStatement(sql);
			prstm.setString(1, cpf);
			prstm.execute();
			
		}catch(Exception e){
			e.printStackTrace();
			
		}
		
		
		
	}
	
	@Override
	public Cliente ClienteProcurar(String cpf) {
		
		Cliente cliente = new Cliente();

			Connection conn = null;
			java.sql.PreparedStatement prstm = null;
			ResultSet resultSet = null;

			
			String sql = "SELECT * FROM cliente WHERE cpf='" + cpf + "' LIMIT 1; ";
			System.out.println("SQL: "+sql);
			try {
				conn = ConectarComBanco.ConectarComMysql();
				prstm = conn.prepareStatement(sql);
				resultSet = prstm.executeQuery();
				while (resultSet.next()) {
					
					cliente.setId(resultSet.getInt("idcliente"));
					cliente.setNome(resultSet.getString("nome"));
					cliente.setCpf(resultSet.getString("cpf"));
					cliente.setEndereco(resultSet.getString("endereco"));
					cliente.setTelefone(resultSet.getString("telefone"));
					cliente.setEmail(resultSet.getString("email"));
					cliente.setSexo(resultSet.getString("sexo"));
					
				}
			} catch (Exception e) {
				System.out.println("ERRO:"+e);

			}
			return cliente;

		}

		
	@Override
	public void ClienteAtualizar(Cliente cliente) {
		
		String sql = "UPDATE cliente SET nome = ?, cpf = ? , endereco = ?, telefone = ?, email = ?, sexo = ? " + " WHERE idcliente = ?; ";
			
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		System.out.println("socorrro: "+cliente.toString());
		
		try {

			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, cliente.getNome());
			prstm.setString(2, cliente.getCpf());
			prstm.setString(3, cliente.getEndereco());
			prstm.setString(4, cliente.getTelefone());
			prstm.setString(5, cliente.getEmail());
			prstm.setString(6, cliente.getSexo());
			
			
			prstm.setInt(7, cliente.getId());

			prstm.execute();
			
				
			

		} catch (Exception e) {
			System.out.println("ERRO: "+e);
		} 

	}
	
	public ArrayList<Cliente> ClienteListar() {
		
		String sql = "SELECT * FROM  cliente";

		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		ArrayList<Cliente> listaCliente = new ArrayList<Cliente>();

		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();

			while (resultSet.next()) {

				Cliente cliente = new Cliente(
						resultSet.getString("nome"),
						resultSet.getString("cpf"),
						resultSet.getString("endereco"),
						resultSet.getString("telefone"),
						resultSet.getString("email"),
						resultSet.getString("sexo"));

				listaCliente.add(cliente);
				System.out.println(resultSet.getString("nome") + " "
						+ resultSet.getString("cpf"));

			}

		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return listaCliente;
	}
}
