package fornecedor;

import java.sql.ResultSet;
import java.util.ArrayList;

import com.mysql.jdbc.Connection;

import conexao.ConectarComBanco;

public class RepositorioFornecedorBDR implements IRepositorioFornecedor {
	
	@Override
	public void FornecedorCadastrar(Fornecedor fornecedor) {
		
		String sql = "INSERT INTO fornecedor (nome, cnpj, endereco, cidade, cep, telefone, email)" + "VALUES(?,?,?,?,?,?,?)";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, fornecedor.getNome());
			prstm.setString(2, fornecedor.getCnpj());
			prstm.setString(3, fornecedor.getEndereco());
			prstm.setString(4, fornecedor.getCidade());
			prstm.setString(5, fornecedor.getCep());
			prstm.setString(6, fornecedor.getTelefone());
			prstm.setString(7, fornecedor.getEmail());
			
			prstm.execute();
		
		}catch (Exception e){
			
			e.printStackTrace();
		
		
		}finally{
			
			try{
				
				if (prstm != null){
					prstm.close();
				}
				if (conn != null){
					conn.close();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			
		}
		
	}

	@Override
	public void FornecedorRemover(String cnpj) {
	
		String sql = "DELETE FROM fornecedor WHERE cnpj = ?";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null; 
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.clientPrepareStatement(sql);
			prstm.setString(1, cnpj);
			prstm.execute();
			
		}catch(Exception e){
			e.printStackTrace();
			
		}
		
		
	}

	@Override
	public Fornecedor FornecedorProcurar(String cnpj) {
		
		Fornecedor fornecedor = new Fornecedor();

		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		
		String sql = "SELECT * FROM fornecedor WHERE cnpj ='" + cnpj + "' LIMIT 1; ";
		System.out.println("SQL: "+sql);
		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();
			while (resultSet.next()) {
				
				fornecedor.setId(resultSet.getInt("idfornecedor"));
				fornecedor.setNome(resultSet.getString("nome"));
				fornecedor.setCnpj(resultSet.getString("cnpj"));
				fornecedor.setEndereco(resultSet.getString("endereco"));
				fornecedor.setCidade(resultSet.getString("cidade"));
				fornecedor.setCep(resultSet.getString("cep"));
				fornecedor.setTelefone(resultSet.getString("telefone"));
				fornecedor.setEmail(resultSet.getString("email"));
				
			}
		} catch (Exception e) {
			System.out.println("ERRO:"+e);

		}
		return fornecedor;

	}

	@Override
	public void FornecedorAtualizar(Fornecedor fornecedor) {
	
		String sql = "UPDATE fornecedor SET nome = ?, cnpj = ?, endereco = ?, cidade = ?, cep = ?, telefone = ?, email = ? " + " WHERE idfornecedor = ?";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		System.out.println("socorrro: "+fornecedor.toString());
		
		try {

			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, fornecedor.getNome());
			prstm.setString(2, fornecedor.getCnpj());
			prstm.setString(3, fornecedor.getEndereco());
			prstm.setString(4, fornecedor.getCidade());
			prstm.setString(5, fornecedor.getCep());		
			prstm.setString(6, fornecedor.getTelefone());
			prstm.setString(7, fornecedor.getEmail());
			
			
			
			prstm.setInt(8, fornecedor.getId());

			prstm.execute();
			
				
			

		} catch (Exception e) {
			System.out.println("ERRO: "+e);
		} 

	}

		
	@Override
	public ArrayList<Fornecedor> FornecedorListar() {
		
		String sql = "SELECT * FROM  fornecedor";

		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		ArrayList<Fornecedor> listaFornecedor = new ArrayList<Fornecedor>();

		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();

			while (resultSet.next()) {

				Fornecedor fornecedor = new Fornecedor(
						resultSet.getString("nome"),
						resultSet.getString("cnpj"),
						resultSet.getString("endereco"),
						resultSet.getString("cep"),
						resultSet.getString("cidade"),
						resultSet.getString("telefone"),
						resultSet.getString("email"));
						

				listaFornecedor.add(fornecedor);
				System.out.println(resultSet.getString("nome") + " "
						+ resultSet.getString("cnpj"));

			}

		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return listaFornecedor;
	}

	
}