package gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

import usuario.RepositorioUsuarioBDR;
import usuario.Usuario;

public class GUICadastroUsuario extends JFrame {

	private static final long serialVersionUID = 1L;

	private Usuario usuario = null;

	private JPanel contentPane;
	private JPasswordField txtSenha;
	private TextField txtLogin;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUICadastroUsuario frame = new GUICadastroUsuario();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUICadastroUsuario() {
		setTitle("Cadastro de Usu\u00E1rio");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 461, 294);
		contentPane = new JPanel();
		contentPane.setBackground(new Color(153, 51, 153));
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		JPanel panel = new JPanel();
		panel.setForeground(new Color(169, 169, 169));
		panel.setBackground(new Color(153, 51, 153));
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, new Color(153,
				0, 204), null));
		panel.setBounds(10, 11, 402, 233);
		contentPane.add(panel);
		panel.setLayout(null);

		Label label = new Label("Login:");
		label.setForeground(new Color(220, 220, 220));
		label.setFont(new Font("Dialog", Font.PLAIN, 15));
		label.setBounds(38, 37, 53, 22);
		panel.add(label);

		Label label_1 = new Label("Senha:");
		label_1.setForeground(new Color(220, 220, 220));
		label_1.setFont(new Font("Dialog", Font.PLAIN, 15));
		label_1.setBounds(38, 78, 53, 22);
		panel.add(label_1);

		txtLogin = new TextField();
		txtLogin.setBounds(97, 32, 286, 27);
		panel.add(txtLogin);

		txtSenha = new JPasswordField();
		txtSenha.setBounds(97, 73, 286, 27);
		panel.add(txtSenha);

		JButton btnSair = new JButton("Sair");
		btnSair.setIcon(new ImageIcon(GUICadastroUsuario.class.getResource("/imagens/sair.png")));
		btnSair.setBackground(new Color(248, 248, 255));
		btnSair.setForeground(new Color(139, 0, 139));
		btnSair.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		btnSair.setBounds(280, 129, 103, 37);
		panel.add(btnSair);

		JButton btnExcluir = new JButton("Excluir");
		btnExcluir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverUsuario();

			}
		});
		btnExcluir.setBackground(new Color(248, 248, 255));
		btnExcluir.setForeground(new Color(139, 0, 139));
		btnExcluir.setBounds(158, 129, 103, 37);
		panel.add(btnExcluir);

		JButton btnEntrar = new JButton("Salvar");
		btnEntrar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {

				cadastraruser();
			}

			@SuppressWarnings("deprecation")
			private void cadastraruser() {

				Usuario usuario = new Usuario();

				usuario.setLogin(txtLogin.getText());
				usuario.setSenha(txtSenha.getText());

				try {

					// Fachada.getInstance().FuncionarioCadastrar(funcionario);
					// //
					// bronca verificar!!!!
					
					//if (usuario != null){
						
					
					RepositorioUsuarioBDR repo = new RepositorioUsuarioBDR();
					repo.UsuarioCadastrar(usuario);
					JOptionPane.showMessageDialog(null,
							"Cadastrado com sucesso!");
						
					txtLogin.setText(null);
					txtSenha.setText(null);

				}

				catch (Exception e) {
					e.printStackTrace();
				}

			}
		});
		btnEntrar.setBackground(new Color(248, 248, 255));
		btnEntrar.setForeground(new Color(139, 0, 139));
		btnEntrar.setBounds(38, 129, 103, 37);
		panel.add(btnEntrar);
	}

	void RemoverUsuario() {

		String senha;
		senha = JOptionPane
				.showInputDialog("Digite a senha do usurio para ser removido");
		
		int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
		if (result == 1){
			RemoverUsuario();
		}	
		
		
		try {
			
			
			// Fachada.getInstance().Fornecedorusuario(senha);
			RepositorioUsuarioBDR repo = new RepositorioUsuarioBDR();
			repo.UsuarioRemover(senha);
			
			JOptionPane.showMessageDialog(null, "Usuario removido do Banco de dados!");
			
			

		} catch (Exception e) {
			e.printStackTrace();

		}

	}

}