package gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import cliente.Cliente;
import cliente.RepositorioClienteBDR;

@SuppressWarnings("serial")
public class GUIcliente extends JFrame {
	
	private Cliente cliente = null;

	private JPanel contentPane;
	private JTextField textNome;
	private JTextField textCpf;
	private JTextField textEndereco;
	private JTextField textTelefone;
	private JTextField textEmail;
	private JTextField textSexo;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIcliente frame = new GUIcliente();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUIcliente() {
		setTitle("CLIENTE");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 502, 499);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JPanel panel = new JPanel();
		panel.setBounds(18, 170, 444, 177);
		panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "CADASTRAR", TitledBorder.CENTER, TitledBorder.TOP, null, new Color(0, 0, 0)));
		contentPane.add(panel);
		GridBagLayout gbl_panel = new GridBagLayout();
		gbl_panel.columnWidths = new int[]{0, 0, 0};
		gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
		gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
		gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
		panel.setLayout(gbl_panel);
		
		JLabel label = new JLabel("Nome");
		GridBagConstraints gbc_label = new GridBagConstraints();
		gbc_label.insets = new Insets(0, 0, 5, 5);
		gbc_label.gridx = 0;
		gbc_label.gridy = 0;
		panel.add(label, gbc_label);
		
		textNome = new JTextField();
		textNome.setColumns(10);
		GridBagConstraints gbc_textNome = new GridBagConstraints();
		gbc_textNome.fill = GridBagConstraints.HORIZONTAL;
		gbc_textNome.insets = new Insets(0, 0, 5, 0);
		gbc_textNome.gridx = 1;
		gbc_textNome.gridy = 0;
		panel.add(textNome, gbc_textNome);
		
		JLabel label_1 = new JLabel("CPF");
		GridBagConstraints gbc_label_1 = new GridBagConstraints();
		gbc_label_1.insets = new Insets(0, 0, 5, 5);
		gbc_label_1.gridx = 0;
		gbc_label_1.gridy = 1;
		panel.add(label_1, gbc_label_1);
		
		textCpf = new JTextField();
		textCpf.setColumns(10);
		GridBagConstraints gbc_textCpf = new GridBagConstraints();
		gbc_textCpf.fill = GridBagConstraints.HORIZONTAL;
		gbc_textCpf.insets = new Insets(0, 0, 5, 0);
		gbc_textCpf.gridx = 1;
		gbc_textCpf.gridy = 1;
		panel.add(textCpf, gbc_textCpf);
		
		JLabel label_2 = new JLabel("Endere\u00E7o");
		GridBagConstraints gbc_label_2 = new GridBagConstraints();
		gbc_label_2.insets = new Insets(0, 0, 5, 5);
		gbc_label_2.gridx = 0;
		gbc_label_2.gridy = 2;
		panel.add(label_2, gbc_label_2);
		
		textEndereco = new JTextField();
		textEndereco.setColumns(10);
		GridBagConstraints gbc_textEndereco = new GridBagConstraints();
		gbc_textEndereco.fill = GridBagConstraints.HORIZONTAL;
		gbc_textEndereco.insets = new Insets(0, 0, 5, 0);
		gbc_textEndereco.gridx = 1;
		gbc_textEndereco.gridy = 2;
		panel.add(textEndereco, gbc_textEndereco);
		
		JLabel label_3 = new JLabel("Telefone");
		GridBagConstraints gbc_label_3 = new GridBagConstraints();
		gbc_label_3.insets = new Insets(0, 0, 5, 5);
		gbc_label_3.gridx = 0;
		gbc_label_3.gridy = 3;
		panel.add(label_3, gbc_label_3);
		
		textTelefone = new JTextField();
		textTelefone.setColumns(10);
		GridBagConstraints gbc_textTelefone = new GridBagConstraints();
		gbc_textTelefone.fill = GridBagConstraints.HORIZONTAL;
		gbc_textTelefone.insets = new Insets(0, 0, 5, 0);
		gbc_textTelefone.gridx = 1;
		gbc_textTelefone.gridy = 3;
		panel.add(textTelefone, gbc_textTelefone);
		
		JLabel label_4 = new JLabel("Email");
		GridBagConstraints gbc_label_4 = new GridBagConstraints();
		gbc_label_4.insets = new Insets(0, 0, 5, 5);
		gbc_label_4.gridx = 0;
		gbc_label_4.gridy = 4;
		panel.add(label_4, gbc_label_4);
		
		textEmail = new JTextField();
		textEmail.setColumns(10);
		GridBagConstraints gbc_textEmail = new GridBagConstraints();
		gbc_textEmail.fill = GridBagConstraints.HORIZONTAL;
		gbc_textEmail.insets = new Insets(0, 0, 5, 0);
		gbc_textEmail.gridx = 1;
		gbc_textEmail.gridy = 4;
		panel.add(textEmail, gbc_textEmail);
		
		JLabel label_5 = new JLabel("Sexo");
		GridBagConstraints gbc_label_5 = new GridBagConstraints();
		gbc_label_5.insets = new Insets(0, 0, 0, 5);
		gbc_label_5.gridx = 0;
		gbc_label_5.gridy = 5;
		panel.add(label_5, gbc_label_5);
		
		textSexo = new JTextField();
		textSexo.setColumns(10);
		GridBagConstraints gbc_textSexo = new GridBagConstraints();
		gbc_textSexo.fill = GridBagConstraints.HORIZONTAL;
		gbc_textSexo.gridx = 1;
		gbc_textSexo.gridy = 5;
		panel.add(textSexo, gbc_textSexo);
		
		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setLayout(null);
		panel_1.setBounds(18, 11, 444, 78);
		contentPane.add(panel_1);
		
		JButton button = new JButton("Cadastrar");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				CadastrarCliente();
			}
		});
		button.setBounds(12, 13, 100, 48);
		panel_1.add(button);
		
		JButton button_1 = new JButton("Remover");
		button_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverCliente();
			}
		});
		button_1.setBounds(122, 13, 100, 48);
		panel_1.add(button_1);
		
		JButton button_2 = new JButton("Editar");
		button_2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				EditarCliente();
			}
		});
		button_2.setBounds(228, 13, 100, 48);
		panel_1.add(button_2);
		
		JButton btnProcurar = new JButton("Consultar");
		btnProcurar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ListarClientes();
			}
		});
		btnProcurar.setBounds(338, 13, 100, 48);
		panel_1.add(btnProcurar);
		
		JButton button_3 = new JButton("Sair");
		button_3.setBounds(196, 358, 100, 48);
		contentPane.add(button_3);
		button_3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
	}
	
	void CadastrarCliente(){
		
		Cliente cliente = new Cliente();
		
		cliente.setNome(textNome.getText());
		cliente.setCpf(textCpf.getText());
		cliente.setEndereco(textEndereco.getText());
		cliente.setTelefone(textTelefone.getText());
		cliente.setEmail(textEmail.getText());
		cliente.setSexo(textSexo.getText());
		
		
		try{
			
			/*if (this.cliente == null){
				JOptionPane.showMessageDialog(null, "Cliente no cadastrado. Favor preencher os campos corretamente!");
			}*/
			//Fachada.getInstance().ClienteCadastrar(cliente);
			// if (this.cliente != null ){
			
			RepositorioClienteBDR repo = new RepositorioClienteBDR();
			repo.ClienteCadastrar(cliente);
			JOptionPane.showMessageDialog(null, "Cliente Cadastrado com Sucesso!");
			
			
			
									
		}catch(Exception e){
			e.printStackTrace();
		}
		
		textNome.setText(null);
		textCpf.setText(null);
		textEndereco.setText(null);
		textTelefone.setText(null);
		textEmail.setText(null);
		textSexo.setText(null);	
		
	}
	
	void EditarCliente(){
		
			try {
			// Fachada.getInstance().ClienteAtualizar(cliente);
			
			this.cliente.setNome(textNome.getText());
			this.cliente.setCpf(textCpf.getText());
			this.cliente.setEndereco(textEndereco.getText());
			this.cliente.setTelefone(textTelefone.getText());
			this.cliente.setEmail(textEmail.getText());
			this.cliente.setSexo(textSexo.getText());
						
			if (this.cliente != null){
			
				RepositorioClienteBDR repo = new RepositorioClienteBDR();
				repo.ClienteAtualizar(this.cliente);
				
				JOptionPane.showMessageDialog(null,"Editado com sucesso!");
				
				
			}
			

		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	void RemoverCliente(){
		
		String cpf;
		cpf = JOptionPane.showInputDialog("Digite o CPF do Cliente para ser Removido");
		
		int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
		if (result == 1){
			RemoverCliente();
		}	
		
		try {

			// Fachada.getInstance().FuncionarioRemover(cpf);
			
			RepositorioClienteBDR repo = new RepositorioClienteBDR();
			repo.ClienteRemover(cpf);
			
				
				JOptionPane.showMessageDialog(null, "Cliente removido do Banco de dados!");
    	  		 	
    	

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	
	void ListarClientes(){
		
		String cpf = null;
		cpf = JOptionPane.showInputDialog("Digite o cpf do funcionario para editar");

		

		try {

			//Cliente cli = Fachada.getInstance().ClienteProcurar(cpf);
			RepositorioClienteBDR repo = new RepositorioClienteBDR();
			Cliente cli = repo.ClienteProcurar(cpf);
			this.cliente = cli;
			
			
			
			System.out.println("Fun: "+cli.toString());
			
			textNome.setText(cli.getNome());
			textCpf.setText(cli.getCpf());
			textEndereco.setText(cli.getEndereco());
			textTelefone.setText(cli.getTelefone());
			textEmail.setText(cli.getEmail());
			textSexo.setText(cli.getSexo());
			
		}

		catch (Exception e) {
			e.printStackTrace();
		}

	}

}

	

