package gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import fornecedor.Fornecedor;
import fornecedor.RepositorioFornecedorBDR;

public class GUIfornecedor extends JFrame {
	
private static final long serialVersionUID = 1L;


	private JPanel contentPane;
	
	private Fornecedor fornecedor = null;

	private JTextField txtNome;
	private JTextField txtCnpj;
	private JTextField txtEndereco;
	private JTextField txtCidade;
	private JTextField txtCep;
	private JTextField txtTelefone;
	private JTextField txtEmail;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIfornecedor frame = new GUIfornecedor();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUIfornecedor() {
		setTitle("FORNECEDOR");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 502, 499);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JPanel panel = new JPanel();
		panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "CADASTRAR", TitledBorder.CENTER, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panel.setBounds(20, 161, 444, 200);
		contentPane.add(panel);
		GridBagLayout gbl_panel = new GridBagLayout();
		gbl_panel.columnWidths = new int[]{0, 0, 0};
		gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
		gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
		gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
		panel.setLayout(gbl_panel);
		
		JLabel label = new JLabel("Nome");
		GridBagConstraints gbc_label = new GridBagConstraints();
		gbc_label.insets = new Insets(0, 0, 5, 5);
		gbc_label.gridx = 0;
		gbc_label.gridy = 0;
		panel.add(label, gbc_label);
		
		txtNome = new JTextField();
		txtNome.setColumns(10);
		GridBagConstraints gbc_txtNome = new GridBagConstraints();
		gbc_txtNome.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtNome.insets = new Insets(0, 0, 5, 0);
		gbc_txtNome.gridx = 1;
		gbc_txtNome.gridy = 0;
		panel.add(txtNome, gbc_txtNome);
		
		JLabel lblCnpj = new JLabel("CNPJ");
		GridBagConstraints gbc_lblCnpj = new GridBagConstraints();
		gbc_lblCnpj.insets = new Insets(0, 0, 5, 5);
		gbc_lblCnpj.gridx = 0;
		gbc_lblCnpj.gridy = 1;
		panel.add(lblCnpj, gbc_lblCnpj);
		
		txtCnpj = new JTextField();
		txtCnpj.setColumns(10);
		GridBagConstraints gbc_txtCnpj = new GridBagConstraints();
		gbc_txtCnpj.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtCnpj.insets = new Insets(0, 0, 5, 0);
		gbc_txtCnpj.gridx = 1;
		gbc_txtCnpj.gridy = 1;
		panel.add(txtCnpj, gbc_txtCnpj);
		
		JLabel label_2 = new JLabel("Endere\u00E7o");
		GridBagConstraints gbc_label_2 = new GridBagConstraints();
		gbc_label_2.insets = new Insets(0, 0, 5, 5);
		gbc_label_2.gridx = 0;
		gbc_label_2.gridy = 2;
		panel.add(label_2, gbc_label_2);
		
		txtEndereco = new JTextField();
		txtEndereco.setColumns(10);
		GridBagConstraints gbc_txtEndereco = new GridBagConstraints();
		gbc_txtEndereco.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtEndereco.insets = new Insets(0, 0, 5, 0);
		gbc_txtEndereco.gridx = 1;
		gbc_txtEndereco.gridy = 2;
		panel.add(txtEndereco, gbc_txtEndereco);
		
		JLabel lblCidade = new JLabel("Cidade");
		GridBagConstraints gbc_lblCidade = new GridBagConstraints();
		gbc_lblCidade.insets = new Insets(0, 0, 5, 5);
		gbc_lblCidade.gridx = 0;
		gbc_lblCidade.gridy = 3;
		panel.add(lblCidade, gbc_lblCidade);
		
		txtCidade = new JTextField();
		txtCidade.setColumns(10);
		GridBagConstraints gbc_txtCidade = new GridBagConstraints();
		gbc_txtCidade.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtCidade.insets = new Insets(0, 0, 5, 0);
		gbc_txtCidade.gridx = 1;
		gbc_txtCidade.gridy = 3;
		panel.add(txtCidade, gbc_txtCidade);
		
		JLabel lblCep = new JLabel("CEP");
		GridBagConstraints gbc_lblCep = new GridBagConstraints();
		gbc_lblCep.insets = new Insets(0, 0, 5, 5);
		gbc_lblCep.gridx = 0;
		gbc_lblCep.gridy = 4;
		panel.add(lblCep, gbc_lblCep);
		
		txtCep = new JTextField();
		txtCep.setColumns(10);
		GridBagConstraints gbc_txtCep = new GridBagConstraints();
		gbc_txtCep.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtCep.insets = new Insets(0, 0, 5, 0);
		gbc_txtCep.gridx = 1;
		gbc_txtCep.gridy = 4;
		panel.add(txtCep, gbc_txtCep);
		
		JLabel lblTelefone = new JLabel("Telefone");
		GridBagConstraints gbc_lblTelefone = new GridBagConstraints();
		gbc_lblTelefone.insets = new Insets(0, 0, 5, 5);
		gbc_lblTelefone.gridx = 0;
		gbc_lblTelefone.gridy = 5;
		panel.add(lblTelefone, gbc_lblTelefone);
		
		txtTelefone = new JTextField();
		txtTelefone.setColumns(10);
		GridBagConstraints gbc_txtTelefone = new GridBagConstraints();
		gbc_txtTelefone.insets = new Insets(0, 0, 5, 0);
		gbc_txtTelefone.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtTelefone.gridx = 1;
		gbc_txtTelefone.gridy = 5;
		panel.add(txtTelefone, gbc_txtTelefone);
		
		JLabel lblEmail = new JLabel("Email");
		GridBagConstraints gbc_lblEmail = new GridBagConstraints();
		gbc_lblEmail.insets = new Insets(0, 0, 0, 5);
		gbc_lblEmail.gridx = 0;
		gbc_lblEmail.gridy = 6;
		panel.add(lblEmail, gbc_lblEmail);
		
		txtEmail = new JTextField();
		GridBagConstraints gbc_txtEmail = new GridBagConstraints();
		gbc_txtEmail.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtEmail.gridx = 1;
		gbc_txtEmail.gridy = 6;
		panel.add(txtEmail, gbc_txtEmail);
		txtEmail.setColumns(10);
		
		JPanel panel_1 = new JPanel();
		panel_1.setLayout(null);
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(20, 11, 456, 78);
		contentPane.add(panel_1);
		
		JButton btnCadastrar = new JButton("Cadastrar");
		btnCadastrar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				FornecedorCadastrar();			}
		});
		btnCadastrar.setBounds(10, 11, 100, 48);
		panel_1.add(btnCadastrar);
		
		JButton btnRemover = new JButton("Remover");
		btnRemover.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverFornecedor();
			}
		});
		btnRemover.setBounds(126, 11, 100, 48);
		panel_1.add(btnRemover);
		
		JButton btnEditar = new JButton("Editar");
		btnEditar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				EditarFornecedor();
			}
		});
		btnEditar.setBounds(236, 11, 100, 48);
		panel_1.add(btnEditar);
		
		JButton btnListar = new JButton("Consultar");
		btnListar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ListarFornecedores();
			}
		});
		btnListar.setBounds(346, 11, 100, 48);
		panel_1.add(btnListar);
		
		JButton button_3 = new JButton("Sair");
		button_3.setBounds(189, 372, 100, 48);
		contentPane.add(button_3);
		button_3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
	}
	
	void FornecedorCadastrar(){
		
		Fornecedor fornecedor = new Fornecedor();
		
		fornecedor.setNome(txtNome.getText());
		fornecedor.setCnpj(txtCnpj.getText());
		fornecedor.setEndereco(txtEndereco.getText());
		fornecedor.setCidade(txtCidade.getText());
		fornecedor.setCep(txtCep.getText());
		fornecedor.setTelefone(txtTelefone.getText());
		fornecedor.setEmail(txtEmail.getText());
		
		try{
			
			//Fachada.getInstance().FornecedorCadastrar(fornecedor);
			
			//if (this.fornecedor != null ){
			
			RepositorioFornecedorBDR repo = new RepositorioFornecedorBDR();
			repo.FornecedorCadastrar(fornecedor);
			JOptionPane.showMessageDialog(null, "cadastrado com sucesso!");
			
			 
			txtNome.setText(null);
			txtCnpj.setText(null);
			txtEndereco.setText(null);
			txtCidade.setText(null);
			txtCep.setText(null);
			txtTelefone.setText(null);
			txtEmail.setText(null);
		}
		
		catch(Exception e){
			e.printStackTrace();
		}
		
	}
		void EditarFornecedor(){
			
						
		try{
			//Fachada.getInstance().FornecedorAtualizar(fornecedor);
			
			this.fornecedor.setNome(txtNome.getText());
			this.fornecedor.setCnpj(txtCnpj.getText());
			this.fornecedor.setEndereco(txtEndereco.getText());
			this.fornecedor.setCidade(txtCidade.getText());
			this.fornecedor.setCep(txtCep.getText());
			this.fornecedor.setTelefone(txtTelefone.getText());
			this.fornecedor.setEmail(txtEmail.getText());
			
			if (this.fornecedor != null){
				
				RepositorioFornecedorBDR repo = new RepositorioFornecedorBDR();
				repo.FornecedorAtualizar(this.fornecedor);
				
				JOptionPane.showMessageDialog(null,"Editado com sucesso!");
				
			}
			

		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
		void RemoverFornecedor(){
			
			String cnpj;
			cnpj = JOptionPane.showInputDialog("Digite o cnpj do fornecedor para ser removido");
			
			int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
			if (result == 1){
				RemoverFornecedor();
			}	
			
			try {

				// Fachada.getInstance().FornecedorRemover(cnpj);
				RepositorioFornecedorBDR repo = new RepositorioFornecedorBDR();
				repo.FornecedorRemover(cnpj);
				
				JOptionPane.showMessageDialog(null, "Fornecedor removido do banco de dados!");

			} catch (Exception e) {
				e.printStackTrace();
			}

		}
	
		void ListarFornecedores(){
		
			String cnpj = null;
			cnpj = JOptionPane
					.showInputDialog("Digite o cnpj do fornecedor para editar");

			

			try {

				//Fornecedor forn = Fachada.getInstance().FornecedorProcurar(cnpj);
				RepositorioFornecedorBDR repo = new RepositorioFornecedorBDR();
				Fornecedor forn = repo.FornecedorProcurar(cnpj);
				this.fornecedor = forn;
				
				System.out.println("Forn: "+forn.toString());
				
				txtNome.setText(forn.getNome());
				txtCnpj.setText(forn.getCnpj());
				txtEndereco.setText(forn.getEndereco());
				txtCidade.setText(forn.getCidade());
				txtCep.setText(forn.getCep());
				txtTelefone.setText(forn.getTelefone());
				txtEmail.setText(forn.getEmail());
				
				
			}

			catch (Exception e) {
				e.printStackTrace();
			}

		}

	}