package gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import funcionario.Funcionario;
import funcionario.RepositorioFuncionarioBDR;

public class GUIfuncionario extends JFrame {

	private static final long serialVersionUID = 1L;

	
	private Funcionario funcionario = null;
	
	private JPanel contentPane;
	private JTextField textNome;
	private JTextField textCpf;
	private JTextField textCargo;
	private JTextField textSalario;
	private JTextField textEndereco;
	private JTextField textTelefone;
	private JTextField textEmail;
	private JTextField textSexo;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIfuncionario frame = new GUIfuncionario();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	public GUIfuncionario() {
		setTitle("FUNCIONARIO");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 502, 499);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		JPanel panel = new JPanel();
		panel.setBorder(new TitledBorder(UIManager
				.getBorder("TitledBorder.border"), "CADASTRAR",
				TitledBorder.CENTER, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panel.setBounds(20, 146, 444, 215);
		contentPane.add(panel);
		GridBagLayout gbl_panel = new GridBagLayout();
		gbl_panel.columnWidths = new int[] { 0, 0, 0 };
		gbl_panel.rowHeights = new int[] { 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		gbl_panel.columnWeights = new double[] { 0.0, 1.0, Double.MIN_VALUE };
		gbl_panel.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
				0.0, 0.0, Double.MIN_VALUE };
		panel.setLayout(gbl_panel);

		JLabel label = new JLabel("Nome");
		GridBagConstraints gbc_label = new GridBagConstraints();
		gbc_label.insets = new Insets(0, 0, 5, 5);
		gbc_label.gridx = 0;
		gbc_label.gridy = 0;
		panel.add(label, gbc_label);

		textNome = new JTextField();
		textNome.setColumns(10);
		GridBagConstraints gbc_textNome = new GridBagConstraints();
		gbc_textNome.fill = GridBagConstraints.HORIZONTAL;
		gbc_textNome.insets = new Insets(0, 0, 5, 0);
		gbc_textNome.gridx = 1;
		gbc_textNome.gridy = 0;
		panel.add(textNome, gbc_textNome);

		JLabel lblCnpj = new JLabel("CPF");
		GridBagConstraints gbc_lblCnpj = new GridBagConstraints();
		gbc_lblCnpj.insets = new Insets(0, 0, 5, 5);
		gbc_lblCnpj.gridx = 0;
		gbc_lblCnpj.gridy = 1;
		panel.add(lblCnpj, gbc_lblCnpj);

		textCpf = new JTextField();
		textCpf.setColumns(10);
		GridBagConstraints gbc_textCpf = new GridBagConstraints();
		gbc_textCpf.fill = GridBagConstraints.HORIZONTAL;
		gbc_textCpf.insets = new Insets(0, 0, 5, 0);
		gbc_textCpf.gridx = 1;
		gbc_textCpf.gridy = 1;
		panel.add(textCpf, gbc_textCpf);

		JLabel lblCargo = new JLabel("Cargo");
		GridBagConstraints gbc_lblCargo = new GridBagConstraints();
		gbc_lblCargo.insets = new Insets(0, 0, 5, 5);
		gbc_lblCargo.gridx = 0;
		gbc_lblCargo.gridy = 2;
		panel.add(lblCargo, gbc_lblCargo);

		textCargo = new JTextField();
		textCargo.setColumns(10);
		GridBagConstraints gbc_textCargo = new GridBagConstraints();
		gbc_textCargo.fill = GridBagConstraints.HORIZONTAL;
		gbc_textCargo.insets = new Insets(0, 0, 5, 0);
		gbc_textCargo.gridx = 1;
		gbc_textCargo.gridy = 2;
		panel.add(textCargo, gbc_textCargo);

		JLabel lblCidade = new JLabel("Salario");
		GridBagConstraints gbc_lblCidade = new GridBagConstraints();
		gbc_lblCidade.insets = new Insets(0, 0, 5, 5);
		gbc_lblCidade.gridx = 0;
		gbc_lblCidade.gridy = 3;
		panel.add(lblCidade, gbc_lblCidade);

		textSalario = new JTextField();
		textSalario.setColumns(10);
		GridBagConstraints gbc_textSalario = new GridBagConstraints();
		gbc_textSalario.fill = GridBagConstraints.HORIZONTAL;
		gbc_textSalario.insets = new Insets(0, 0, 5, 0);
		gbc_textSalario.gridx = 1;
		gbc_textSalario.gridy = 3;
		panel.add(textSalario, gbc_textSalario);

		JLabel lblCep = new JLabel("Endere\u00E7o");
		GridBagConstraints gbc_lblCep = new GridBagConstraints();
		gbc_lblCep.insets = new Insets(0, 0, 5, 5);
		gbc_lblCep.gridx = 0;
		gbc_lblCep.gridy = 4;
		panel.add(lblCep, gbc_lblCep);

		textEndereco = new JTextField();
		textEndereco.setColumns(10);
		GridBagConstraints gbc_textEndereco = new GridBagConstraints();
		gbc_textEndereco.fill = GridBagConstraints.HORIZONTAL;
		gbc_textEndereco.insets = new Insets(0, 0, 5, 0);
		gbc_textEndereco.gridx = 1;
		gbc_textEndereco.gridy = 4;
		panel.add(textEndereco, gbc_textEndereco);

		JLabel lblTelefone = new JLabel("Telefone");
		GridBagConstraints gbc_lblTelefone = new GridBagConstraints();
		gbc_lblTelefone.insets = new Insets(0, 0, 5, 5);
		gbc_lblTelefone.gridx = 0;
		gbc_lblTelefone.gridy = 5;
		panel.add(lblTelefone, gbc_lblTelefone);

		textTelefone = new JTextField();
		textTelefone.setColumns(10);
		GridBagConstraints gbc_textTelefone = new GridBagConstraints();
		gbc_textTelefone.insets = new Insets(0, 0, 5, 0);
		gbc_textTelefone.fill = GridBagConstraints.HORIZONTAL;
		gbc_textTelefone.gridx = 1;
		gbc_textTelefone.gridy = 5;
		panel.add(textTelefone, gbc_textTelefone);

		JLabel lblEmail = new JLabel("Email");
		GridBagConstraints gbc_lblEmail = new GridBagConstraints();
		gbc_lblEmail.insets = new Insets(0, 0, 5, 5);
		gbc_lblEmail.gridx = 0;
		gbc_lblEmail.gridy = 6;
		panel.add(lblEmail, gbc_lblEmail);

		textEmail = new JTextField();
		GridBagConstraints gbc_textEmail = new GridBagConstraints();
		gbc_textEmail.insets = new Insets(0, 0, 5, 0);
		gbc_textEmail.fill = GridBagConstraints.HORIZONTAL;
		gbc_textEmail.gridx = 1;
		gbc_textEmail.gridy = 6;
		panel.add(textEmail, gbc_textEmail);
		textEmail.setColumns(10);

		JLabel lblSexo = new JLabel("Sexo");
		GridBagConstraints gbc_lblSexo = new GridBagConstraints();
		gbc_lblSexo.fill = GridBagConstraints.VERTICAL;
		gbc_lblSexo.insets = new Insets(0, 0, 0, 5);
		gbc_lblSexo.gridx = 0;
		gbc_lblSexo.gridy = 7;
		panel.add(lblSexo, gbc_lblSexo);

		textSexo = new JTextField();
		GridBagConstraints gbc_textSexo = new GridBagConstraints();
		gbc_textSexo.fill = GridBagConstraints.HORIZONTAL;
		gbc_textSexo.gridx = 1;
		gbc_textSexo.gridy = 7;
		panel.add(textSexo, gbc_textSexo);
		textSexo.setColumns(10);

		JPanel panel_1 = new JPanel();
		panel_1.setLayout(null);
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(20, 11, 456, 78);
		contentPane.add(panel_1);

		JButton button = new JButton("Cadastrar");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				CadastrarFuncionario();
			}
		});
		button.setBounds(10, 11, 100, 48);
		panel_1.add(button);

		JButton button_1 = new JButton("Remover");
		button_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverFuncionario();
			}
		});
		button_1.setBounds(126, 11, 100, 48);
		panel_1.add(button_1);

		JButton button_2 = new JButton("Editar");
		button_2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				EditarFuncionario();
			}
		});
		button_2.setBounds(236, 11, 100, 48);
		panel_1.add(button_2);

		JButton btnNewButton = new JButton("Consultar");
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ListarFuncionarios();
				
			}
		});
		btnNewButton.setBounds(346, 11, 100, 48);
		panel_1.add(btnNewButton);

		JButton button_3 = new JButton("Sair");
		button_3.setBounds(189, 372, 100, 48);
		contentPane.add(button_3);
		button_3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
	}

	void CadastrarFuncionario() {

		Funcionario funcionario = new Funcionario();

		funcionario.setNome(textNome.getText());
		funcionario.setCpf(textCpf.getText());
		funcionario.setCargo(textCargo.getText());
		funcionario.setSalario(textSalario.getText());
		funcionario.setEndereco(textEndereco.getText());
		funcionario.setTelefone(textTelefone.getText());
		funcionario.setEmail(textEmail.getText());
		funcionario.setSexo(textSexo.getText());

		try {

			// Fachada.getInstance().FuncionarioCadastrar(funcionario); //
			// bronca verificar!!!!
			
			// if (this.funcionario != null ){
			
			RepositorioFuncionarioBDR repo = new RepositorioFuncionarioBDR();
			repo.FuncionarioCadastrar(funcionario);
			JOptionPane.showMessageDialog(null, "cadastrado com sucesso!");
			 
			 
			textNome.setText(null);
			textCpf.setText(null);
			textCargo.setText(null);
			textSalario.setText(null);
			textEndereco.setText(null);
			textTelefone.setText(null);
			textEmail.setText(null);
			textSexo.setText(null);
		}

		catch (Exception e) {
			e.printStackTrace();
		}

	}

	void EditarFuncionario() {

		try {
			// Fachada.getInstance().FuncionarioAtualizar(funcionario);
			
			this.funcionario.setNome(textNome.getText());
			this.funcionario.setCpf(textCpf.getText());
			this.funcionario.setCargo(textCargo.getText());
			this.funcionario.setSalario(textSalario.getText());
			this.funcionario.setEndereco(textEndereco.getText());
			this.funcionario.setTelefone(textTelefone.getText());
			this.funcionario.setEmail(textEmail.getText());
			this.funcionario.setSexo(textSexo.getText());
			
					
			
			if (this.funcionario != null){
			
				RepositorioFuncionarioBDR repo = new RepositorioFuncionarioBDR();
				repo.FuncionarioAtualizar(this.funcionario);
				
				JOptionPane.showMessageDialog(null, "Editado com Sucesso!");
				
				
			}
			

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	void RemoverFuncionario() {
		String cpf;
		cpf = JOptionPane
				.showInputDialog("Digite o cpf do funcionrio para ser removido");
		
		int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
		if (result == 1){
			RemoverFuncionario();
		}	
		
		try {

			// Fachada.getInstance().FuncionarioRemover(cpf);
			RepositorioFuncionarioBDR repo = new RepositorioFuncionarioBDR();
			repo.FuncionarioRemover(cpf);
			
			JOptionPane.showMessageDialog(null, "Funcionario removido do Banco de dados!");

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	void ListarFuncionarios() {

		String cpf = null;
		cpf = JOptionPane
				.showInputDialog("Digite o cpf do funcionario para editar");

		

		try {

			//Funcionario fun = Fachada.getInstance().FuncionarioProcurar(cpf);
			RepositorioFuncionarioBDR repo = new RepositorioFuncionarioBDR();
			Funcionario fun = repo.FuncionarioProcurar(cpf);
			this.funcionario = fun;
			
			System.out.println("Fun: "+fun.toString());
			
			textNome.setText(fun.getNome());
			textCpf.setText(fun.getCpf());
			textCargo.setText(fun.getCargo());
			textSalario.setText(fun.getSalario());
			textEndereco.setText(fun.getEndereco());
			textTelefone.setText(fun.getTelefone());
			textEmail.setText(fun.getEmail());
			textSexo.setText(fun.getSexo());
			
		}

		catch (Exception e) {
			e.printStackTrace();
		}

	}

}
