package gui;

import java.awt.Button;
import java.awt.EventQueue;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import usuario.ControladorUsuario;
import usuario.Usuario;
import java.awt.Color;
import java.awt.Font;

@SuppressWarnings("serial")
public class GUIusuario extends JFrame {

	private TextField txtLogin;
	private JPanel contentPane;
	private JPasswordField txtSenha;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIusuario frame = new GUIusuario();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUIusuario() {
		setTitle("Efetuar Login no Sistema");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 329, 202);
		contentPane = new JPanel();
		contentPane.setBackground(new Color(153, 51, 153));
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		Label label = new Label("Login:");
		label.setFont(new Font("Dialog", Font.PLAIN, 15));
		label.setForeground(new Color(248, 248, 255));
		label.setBounds(10, 34, 46, 22);
		contentPane.add(label);
		
		Label label_1 = new Label("Senha:");
		label_1.setFont(new Font("Dialog", Font.PLAIN, 15));
		label_1.setForeground(new Color(248, 248, 255));
		label_1.setBounds(10, 62, 46, 22);
		contentPane.add(label_1);
		
		Button button = new Button("Entrar");
		button.setFont(new Font("DialogInput", Font.PLAIN, 14));
		button.setForeground(new Color(153, 51, 153));
		button.setBackground(new Color(245, 245, 220));
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				String login = txtLogin.getText();
				String senha = txtSenha.getText();
				
				
				Usuario usuario = new Usuario();
				usuario.setLogin(login);
				usuario.setSenha(senha);
				
				ControladorUsuario controle = new ControladorUsuario();
				
				
				if (controle.fazLogin(usuario)){
					
					new GUIprincipal().setVisible(true);
					System.out.println("Login Efetuado com Sucesso!");
					
				} else {
					JOptionPane.showMessageDialog(null, "Usurio e senha incorreto!");
				}
				
				
				
				
				
			}
		});
		button.setBounds(62, 105, 80, 27);
		contentPane.add(button);
		
		Button button_1 = new Button("Cancelar");
		button_1.setFont(new Font("DialogInput", Font.PLAIN, 14));
		button_1.setForeground(new Color(153, 51, 153));
		button_1.setBackground(new Color(245, 245, 220));
		button_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
				
			}
		});
		button_1.setBounds(157, 105, 80, 27);
		contentPane.add(button_1);
		
		txtLogin = new TextField();
		txtLogin.setBounds(62, 34, 235, 22);
		contentPane.add(txtLogin);
		
		txtSenha = new JPasswordField();
		txtSenha.setBounds(62, 64, 235, 22);
		contentPane.add(txtSenha);
		
	}
	
	
}
