package produto;

import java.sql.ResultSet;
import java.util.ArrayList;

import com.mysql.jdbc.Connection;

import conexao.ConectarComBanco;

public class RepositorioProdutoBDR implements IRepositorioProduto{

	@Override
	public void ProdutoCadastrar(Produto produto) {

		String sql = "INSERT INTO produto (nome, preco, codigo, quantidade, descricao)" + " VALUES (?,?,?,?,?) " ;
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, produto.getNome());
			prstm.setString(2, produto.getPreco());
			prstm.setString(3, produto.getCodigo());
			prstm.setString(4, produto.getQuantidade());
			prstm.setString(5, produto.getDescricao());
			
			prstm.execute();
			
			System.out.println("Tudo ok!");
		
		}catch (Exception e){
			
			e.printStackTrace();
		
		
		}finally{
			
			try{
				
				if (prstm != null){
					prstm.close();
				}
				if (conn != null){
					conn.close();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			
		}
		
	}

	@Override
	public void ProdutoRemover(String codigo) {

		String sql = " DELETE FROM produto WHERE codigo = ?; ";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null; 
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.clientPrepareStatement(sql);
			prstm.setString(1, codigo);
			prstm.execute();
			
		}catch(Exception e){
			e.printStackTrace();
			
		}
		
		
	}

	@Override
	public Produto ProdutoProcurar (String codigo){
		
		
		Produto produto = new Produto();
		
		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		
		String sql = "SELECT * FROM produto WHERE codigo='" + codigo + "' LIMIT 1; ";
		System.out.println("SQL: "+sql);
		
		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();
			while (resultSet.next()) {
				
				produto.setId(resultSet.getInt("idproduto"));
				produto.setNome(resultSet.getString("nome"));
				produto.setPreco(resultSet.getString("preco"));
				produto.setCodigo(resultSet.getString("codigo"));
				produto.setDescricao(resultSet.getString("descricao"));
				produto.setQuantidade(resultSet.getString("quantidade"));
				
				
			}
		} catch (Exception e) {
			System.out.println("ERRO:"+e);

		}
		return produto;

	}
		
	  
	@Override
	public void ProdutoAtualizar(Produto produto) {
		
		String sql = "UPDATE produto SET nome = ?, preco = ?, descricao = ?, codigo = ?, quantidade = ? " + " WHERE idproduto = ?";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		System.out.println("socorrro: "+produto.toString());
		
		try{
					
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, produto.getNome());
			prstm.setString(2, produto.getPreco());
			prstm.setString(3, produto.getDescricao());
			prstm.setString(4, produto.getCodigo());
			prstm.setString(5, produto.getQuantidade());
			
			
			prstm.setInt(6, produto.getId());
			
	
			prstm.execute();
			
		}catch(Exception e){
			System.out.println("ERRO: "+e);
		}
		
	}

	@Override
	public ArrayList<Produto> ProdutoListar() {
		// TODO Auto-generated method stub
		return null;
	}

		
		
		
	/*@Override
		public ArrayList<Produto> ProdutoListar() {
		

			String sql = "SELECT * FROM produto";

			Connection conn = null;
			java.sql.PreparedStatement prstm = null;
			ResultSet resultSet = null;

			ArrayList<Produto> listaProduto = new ArrayList<Produto>();

			try {
				conn = ConectarComBanco.ConectarComMysql();
				prstm = conn.prepareStatement(sql);
				resultSet = prstm.executeQuery();

				while (resultSet.next()) {

					Produto produto = new Produto(
							resultSet.getString("nome"),
							resultSet.getString("preco"),
							resultSet.getString("codigo"),
							resultSet.getString("descricao")
							resultSet.getString("quantidade"));
							

					listaProduto.add(produto);
					System.out.println(resultSet.getString("nome") + " "
							+ resultSet.getString("codigo"));

				}

			}

			catch (Exception e) {
				e.printStackTrace();
			}

			return listaProduto;
		}
	*/	
}

