/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "bibliografia")
@NamedQueries({
    @NamedQuery(name = "Bibliografia.findAll", query = "SELECT b FROM Bibliografia b"),
    @NamedQuery(name = "Bibliografia.findByIdbibliografia", query = "SELECT b FROM Bibliografia b WHERE b.idbibliografia = :idbibliografia"),
    @NamedQuery(name = "Bibliografia.findByDescricao", query = "SELECT b FROM Bibliografia b WHERE b.descricao = :descricao"),
    @NamedQuery(name = "Bibliografia.findByTipo", query = "SELECT b FROM Bibliografia b WHERE b.tipo = :tipo")})
public class Bibliografia implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "idbibliografia")
    private Integer idbibliografia;
    @Basic(optional = false)
    @Column(name = "descricao")
    private String descricao;
    @Basic(optional = false)
    @Column(name = "tipo")
    private String tipo;
    @ManyToMany(mappedBy = "bibliografiaCollection")
    private Collection<PlanoEnsino> planoEnsinoCollection;

    public Bibliografia() {
    }

    public Bibliografia(Integer idbibliografia) {
        this.idbibliografia = idbibliografia;
    }

    public Bibliografia(Integer idbibliografia, String descricao, String tipo) {
        this.idbibliografia = idbibliografia;
        this.descricao = descricao;
        this.tipo = tipo;
    }

    public Integer getIdbibliografia() {
        return idbibliografia;
    }

    public void setIdbibliografia(Integer idbibliografia) {
        this.idbibliografia = idbibliografia;
    }

    public String getDescricao() {
        return descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public Collection<PlanoEnsino> getPlanoEnsinoCollection() {
        return planoEnsinoCollection;
    }

    public void setPlanoEnsinoCollection(Collection<PlanoEnsino> planoEnsinoCollection) {
        this.planoEnsinoCollection = planoEnsinoCollection;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (idbibliografia != null ? idbibliografia.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Bibliografia)) {
            return false;
        }
        Bibliografia other = (Bibliografia) object;
        if ((this.idbibliografia == null && other.idbibliografia != null) || (this.idbibliografia != null && !this.idbibliografia.equals(other.idbibliografia))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.Bibliografia[idbibliografia=" + idbibliografia + "]";
    }

}
