/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "escola")
@NamedQueries({
    @NamedQuery(name = "Escola.findAll", query = "SELECT e FROM Escola e"),
    @NamedQuery(name = "Escola.findByIdescola", query = "SELECT e FROM Escola e WHERE e.idescola = :idescola"),
    @NamedQuery(name = "Escola.findByDescricao", query = "SELECT e FROM Escola e WHERE e.descricao = :descricao")})
public class Escola implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "idescola")
    private Integer idescola;
    @Basic(optional = false)
    @Column(name = "descricao")
    private int descricao;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "idescola")
    private Collection<Curso> cursoCollection;

    public Escola() {
    }

    public Escola(Integer idescola) {
        this.idescola = idescola;
    }

    public Escola(Integer idescola, int descricao) {
        this.idescola = idescola;
        this.descricao = descricao;
    }

    public Integer getIdescola() {
        return idescola;
    }

    public void setIdescola(Integer idescola) {
        this.idescola = idescola;
    }

    public int getDescricao() {
        return descricao;
    }

    public void setDescricao(int descricao) {
        this.descricao = descricao;
    }

    public Collection<Curso> getCursoCollection() {
        return cursoCollection;
    }

    public void setCursoCollection(Collection<Curso> cursoCollection) {
        this.cursoCollection = cursoCollection;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (idescola != null ? idescola.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Escola)) {
            return false;
        }
        Escola other = (Escola) object;
        if ((this.idescola == null && other.idescola != null) || (this.idescola != null && !this.idescola.equals(other.idescola))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.Escola[idescola=" + idescola + "]";
    }

}
