/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "plano_ensino")
@NamedQueries({
    @NamedQuery(name = "PlanoEnsino.findAll", query = "SELECT p FROM PlanoEnsino p"),
    @NamedQuery(name = "PlanoEnsino.findByIdplanoEnsino", query = "SELECT p FROM PlanoEnsino p WHERE p.idplanoEnsino = :idplanoEnsino"),
    @NamedQuery(name = "PlanoEnsino.findByEmenta", query = "SELECT p FROM PlanoEnsino p WHERE p.ementa = :ementa"),
    @NamedQuery(name = "PlanoEnsino.findByContribuicao", query = "SELECT p FROM PlanoEnsino p WHERE p.contribuicao = :contribuicao"),
    @NamedQuery(name = "PlanoEnsino.findByObjetivoGeral", query = "SELECT p FROM PlanoEnsino p WHERE p.objetivoGeral = :objetivoGeral"),
    @NamedQuery(name = "PlanoEnsino.findByArticulacao", query = "SELECT p FROM PlanoEnsino p WHERE p.articulacao = :articulacao"),
    @NamedQuery(name = "PlanoEnsino.findByEnade", query = "SELECT p FROM PlanoEnsino p WHERE p.enade = :enade"),
    @NamedQuery(name = "PlanoEnsino.findByConteudo", query = "SELECT p FROM PlanoEnsino p WHERE p.conteudo = :conteudo"),
    @NamedQuery(name = "PlanoEnsino.findByAvaliacao", query = "SELECT p FROM PlanoEnsino p WHERE p.avaliacao = :avaliacao"),
    @NamedQuery(name = "PlanoEnsino.findByObjetivosEspecificos", query = "SELECT p FROM PlanoEnsino p WHERE p.objetivosEspecificos = :objetivosEspecificos")})
public class PlanoEnsino implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "idplano_ensino")
    private Integer idplanoEnsino;
    @Basic(optional = false)
    @Column(name = "ementa")
    private String ementa;
    @Basic(optional = false)
    @Column(name = "contribuicao")
    private String contribuicao;
    @Basic(optional = false)
    @Column(name = "objetivo_geral")
    private String objetivoGeral;
    @Basic(optional = false)
    @Column(name = "articulacao")
    private String articulacao;
    @Basic(optional = false)
    @Column(name = "enade")
    private String enade;
    @Basic(optional = false)
    @Column(name = "conteudo")
    private String conteudo;
    @Basic(optional = false)
    @Column(name = "avaliacao")
    private String avaliacao;
    @Basic(optional = false)
    @Column(name = "objetivos_especificos")
    private String objetivosEspecificos;
    @JoinTable(name = "plano_ensino_has_bibliografia", joinColumns = {
        @JoinColumn(name = "idplano_ensino", referencedColumnName = "idplano_ensino")}, inverseJoinColumns = {
        @JoinColumn(name = "idbibliografia", referencedColumnName = "idbibliografia")})
    @ManyToMany
    private Collection<Bibliografia> bibliografiaCollection;
    @JoinColumn(name = "iddisciplina", referencedColumnName = "iddisciplina")
    @ManyToOne(optional = false)
    private Disciplina iddisciplina;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "planoEnsino")
    private PlanoProfessor planoProfessor;

    public PlanoEnsino() {
    }

    public PlanoEnsino(Integer idplanoEnsino) {
        this.idplanoEnsino = idplanoEnsino;
    }

    public PlanoEnsino(Integer idplanoEnsino, String ementa, String contribuicao, String objetivoGeral, String articulacao, String enade, String conteudo, String avaliacao, String objetivosEspecificos) {
        this.idplanoEnsino = idplanoEnsino;
        this.ementa = ementa;
        this.contribuicao = contribuicao;
        this.objetivoGeral = objetivoGeral;
        this.articulacao = articulacao;
        this.enade = enade;
        this.conteudo = conteudo;
        this.avaliacao = avaliacao;
        this.objetivosEspecificos = objetivosEspecificos;
    }

    public Integer getIdplanoEnsino() {
        return idplanoEnsino;
    }

    public void setIdplanoEnsino(Integer idplanoEnsino) {
        this.idplanoEnsino = idplanoEnsino;
    }

    public String getEmenta() {
        return ementa;
    }

    public void setEmenta(String ementa) {
        this.ementa = ementa;
    }

    public String getContribuicao() {
        return contribuicao;
    }

    public void setContribuicao(String contribuicao) {
        this.contribuicao = contribuicao;
    }

    public String getObjetivoGeral() {
        return objetivoGeral;
    }

    public void setObjetivoGeral(String objetivoGeral) {
        this.objetivoGeral = objetivoGeral;
    }

    public String getArticulacao() {
        return articulacao;
    }

    public void setArticulacao(String articulacao) {
        this.articulacao = articulacao;
    }

    public String getEnade() {
        return enade;
    }

    public void setEnade(String enade) {
        this.enade = enade;
    }

    public String getConteudo() {
        return conteudo;
    }

    public void setConteudo(String conteudo) {
        this.conteudo = conteudo;
    }

    public String getAvaliacao() {
        return avaliacao;
    }

    public void setAvaliacao(String avaliacao) {
        this.avaliacao = avaliacao;
    }

    public String getObjetivosEspecificos() {
        return objetivosEspecificos;
    }

    public void setObjetivosEspecificos(String objetivosEspecificos) {
        this.objetivosEspecificos = objetivosEspecificos;
    }

    public Collection<Bibliografia> getBibliografiaCollection() {
        return bibliografiaCollection;
    }

    public void setBibliografiaCollection(Collection<Bibliografia> bibliografiaCollection) {
        this.bibliografiaCollection = bibliografiaCollection;
    }

    public Disciplina getIddisciplina() {
        return iddisciplina;
    }

    public void setIddisciplina(Disciplina iddisciplina) {
        this.iddisciplina = iddisciplina;
    }

    public PlanoProfessor getPlanoProfessor() {
        return planoProfessor;
    }

    public void setPlanoProfessor(PlanoProfessor planoProfessor) {
        this.planoProfessor = planoProfessor;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (idplanoEnsino != null ? idplanoEnsino.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof PlanoEnsino)) {
            return false;
        }
        PlanoEnsino other = (PlanoEnsino) object;
        if ((this.idplanoEnsino == null && other.idplanoEnsino != null) || (this.idplanoEnsino != null && !this.idplanoEnsino.equals(other.idplanoEnsino))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.PlanoEnsino[idplanoEnsino=" + idplanoEnsino + "]";
    }

}
