package com.example.pruebassicloud;

import org.andengine.engine.camera.Camera;

import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.text.AutoWrap;
import org.andengine.entity.text.Text;
import org.andengine.entity.text.TextOptions;
import org.andengine.entity.util.FPSLogger;
import org.andengine.opengl.font.Font;
import org.andengine.opengl.font.FontFactory;
import org.andengine.opengl.texture.TextureOptions;
//import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
//import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
//import org.andengine.opengl.texture.atlas.bitmap.BuildableBitmapTextureAtlas;
import org.andengine.opengl.texture.region.ITextureRegion;
//import org.andengine.opengl.texture.region.TextureRegionFactory;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.ui.activity.SimpleLayoutGameActivity;
import org.andengine.util.HorizontalAlign;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class Formulario extends SimpleLayoutGameActivity{
	// ===========================================================
	// CONSTANTES
	// ===========================================================

	private static final int CAMERA_WIDTH = 800;
	private static final int CAMERA_HEIGHT = 480;

	private static final float AUTOWRAP_WIDTH = 720 - 50 - 50;

	// ===========================================================
	// VARIABLES
	// ===========================================================

	private EditText mEditTextNombre;
	private EditText mEditTextDescripcion;
	private Button btnGuardarArchivos;
	private BitmapTextureAtlas mBitmapTextureAtlas;
	private ITextureRegion mBotonTextureRegion;
	private AlertDialog.Builder builder;
	
	private Font mFont;
	private Text mText;
	

	
	// ===========================================================
	// METODOS NECESARIOS
	// ===========================================================
	
	@Override
	protected int getLayoutID() {
		return R.layout.activity_formulario;
	}

	@Override
	protected int getRenderSurfaceViewID() {
		return R.id.formulario_renderSurfaceView;
	}

	@Override
	protected void onSetContentView() {
		super.onSetContentView();

		this.mEditTextNombre = (EditText)this.findViewById(R.id.etx_Nombre);
		this.mEditTextDescripcion = (EditText)this.findViewById(R.id.etx_Descripcion);
		
		
		this.btnGuardarArchivos = (Button)this.findViewById(R.id.btn_GuardarRegistros);
		builder = new AlertDialog.Builder(this);
		
		
		


		btnGuardarArchivos.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				if(mEditTextNombre.getText().toString().equals("")||mEditTextDescripcion.getText().toString().equals(""))
				{
					builder.setMessage("Debes completar ambos campos para poder insertar un registro satisfactoriamente")
					       .setCancelable(false)
					       .setPositiveButton("Entendido", new DialogInterface.OnClickListener() {
					           public void onClick(DialogInterface dialog, int id) {
					                //do things
					           }
					       });
					AlertDialog alert = builder.create();
					alert.show();
				}
				else
				{
				guardarRegistros();
				}
			}
		});
	}

	@Override
	public EngineOptions onCreateEngineOptions() {
		final Camera camera = new Camera(0, 0, Formulario.CAMERA_WIDTH, Formulario.CAMERA_HEIGHT);

		return new EngineOptions(true, ScreenOrientation.LANDSCAPE_FIXED, new RatioResolutionPolicy(Formulario.CAMERA_WIDTH, Formulario.CAMERA_HEIGHT), camera);
	}

	@Override
	public void onCreateResources() {
		
		BitmapTextureAtlasTextureRegionFactory.setAssetBasePath("gfx/");
		
		this.mFont = FontFactory.create(this.getFontManager(), this.getTextureManager(), 256, 256, TextureOptions.BILINEAR, Typeface.create(Typeface.DEFAULT, Typeface.BOLD), 24);
		this.mFont.load();
		
		this.mBitmapTextureAtlas = new BitmapTextureAtlas(this.getTextureManager(),1024, 1024);
		  mBotonTextureRegion = BitmapTextureAtlasTextureRegionFactory.createFromAsset(this.mBitmapTextureAtlas, this,
		      "cuadrodetexto.png", 0, 0);
		  this.mBitmapTextureAtlas.load();
		
		
	}

	@Override
	public Scene onCreateScene() {
		this.mEngine.registerUpdateHandler(new FPSLogger());

		final Scene scene = new Scene();
		scene.setBackground(new Background(0, 0,250980392, 1));

		final VertexBufferObjectManager vertexBufferObjectManager = this.getVertexBufferObjectManager();
		this.mText = new Text(50, 40, this.mFont, "", 1000, new TextOptions(AutoWrap.LETTERS, AUTOWRAP_WIDTH, HorizontalAlign.CENTER, Text.LEADING_DEFAULT), vertexBufferObjectManager);
		scene.attachChild(this.mText);
		
		return scene;
	}
	@Override
    public void onBackPressed()
    {
		volverInicio();	
    }
	


	// ===========================================================
	// METODOS
	// ===========================================================
	private void guardarRegistros() {
		
		String sql="INSERT INTO TF_BBDD VALUES (null, '"+mEditTextNombre.getText().toString()+"','"+ mEditTextDescripcion.getText().toString() +"')";
		TF_BBDD crearBD = new TF_BBDD(this);
		SQLiteDatabase bd = crearBD.getWritableDatabase();
		bd.execSQL(sql);
		Toast.makeText(this, "Registro añadido correctamente", Toast.LENGTH_LONG).show();
		volverInicio();
	}
	private void volverInicio(){
		Intent inten = new Intent(this, Menu.class);
		startActivity(inten);
		this.finish();
	}

}

