package boccuz.rnn;

/**
 * Represents a direction.
 * 
 * @author Alex FRENE
 * @since ~30 dec. 2011
 * 
 */
public enum Direction {
	UP(0), DOWN(2), LEFT(3), RIGHT(1);

	private int spriteY;

	private Direction(int y) {
		spriteY = y;
	}

	public int getSpriteY() {
		return spriteY;
	}
	
	public static Direction get(int ordinal){
		for(Direction d : values()){
			if(d.ordinal() == ordinal){
				return d;
			}
		}
		return null;
	}
}
