package boccuz.rnn.enemy;

import java.util.ArrayList;
import java.util.List;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

import boccuz.rnn.Asset;
import boccuz.rnn.Constants;
import boccuz.rnn.Direction;
import boccuz.rnn.Entity;
import boccuz.rnn.Vector2I;
import boccuz.rnn.helper.RandomHelper;

public class EnemyFactory {
	private List<Entity> entities;

	public EnemyFactory() {
		entities = new ArrayList<Entity>();
	}

	public void createEnemy() throws SlickException {
		if (entities.size() == Constants.MAX_ENEMIES) {
			// The max number is reached, don't add anymore
			return;
		}

		// EnemyType type = RandomHelper.randomEnemyType();
		Entity enemy = null;
		EnemyType type = EnemyType.BACON;
		switch (type) {
		case BACON:
			enemy = new Entity(Asset.IMG_ANIM_LARDON, 33, 32);
			break;
		case GINGERBREAD:
			enemy = new Entity(Asset.IMG_ANIM_MACARON, 65, 64);
			break;
		case MACAROON:
			enemy = new Entity(Asset.IMG_ANIM_PAINEPICE, 65, 64);
			break;
		default:
			return;
		}

		// Get a random position on the map
		enemy.pos.x = (int) RandomHelper.random(Constants.MAP_WIDTH - 50);
		enemy.pos.y = (int) RandomHelper.random(Constants.MAP_HEIGHT - 50);

		// TODO add collision test with the player so that an enemy cannot spawn
		// onto the player

		// Get the start moving vector
		enemy.moveVector = new Vector2I(0, 0);
		enemy.moveVector.x = (RandomHelper.random(10) % 2 == 0) ? 2 : -2;
		enemy.moveVector.y = (RandomHelper.random(10) % 2 == 0) ? 2 : -2;
		
		if(enemy.moveVector.x < 0){
			enemy.setCurrentDirection(Direction.LEFT);
		}else{
			enemy.setCurrentDirection(Direction.RIGHT);
		}

		entities.add(enemy);
	}

	public List<Entity> getEnemies() {
		return entities;
	}

	public void drawEnemies(Graphics g) {
		for (Entity e : entities) {
			e.draw(e.moveVector, g);
		}
	}

	public void update() {
		for (Entity e : entities) {
			e.pos.x += e.moveVector.x;
			e.pos.y += e.moveVector.y;

			if (e.pos.x < 10) {
				e.moveVector.x *= -1;
				e.setCurrentDirection(Direction.RIGHT);
			} else if (e.pos.x > Constants.MAP_WIDTH - 10) {
				e.moveVector.x *= -1;
				e.setCurrentDirection(Direction.LEFT);
			}
			if (e.pos.y < 10) {
				e.moveVector.y *= -1;
				e.setCurrentDirection(Direction.DOWN);
			} else if (e.pos.y > Constants.MAP_HEIGHT - 10) {
				e.moveVector.y *= -1;
				e.setCurrentDirection(Direction.RIGHT);
			}
		}
	}
}
