package boccuz.rnn.state;

import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

import boccuz.rnn.Asset;
import boccuz.rnn.Constants;
import boccuz.rnn.Menu;
import boccuz.rnn.State;
import boccuz.rnn.helper.FontHelper;

/**
 * Game menu state
 * 
 * @author Alex
 * 
 */
public class MenuState extends BasicGameState {
	private static final String[] MENU_ITEMS = { "Jouer", "Highscore", "DLC" };

	private Menu menu;
	private UnicodeFont fontSelected;
	private UnicodeFont fontDefault;

	@Override
	public void init(GameContainer gc, StateBasedGame sbg)
			throws SlickException {
		menu = new Menu(MENU_ITEMS);

		fontSelected = FontHelper.get(Asset.FNT_GOCHI_HAND, 45, false, false,
				Constants.COLOR_1);
		fontDefault = FontHelper.get(Asset.FNT_GOCHI_HAND, 45, false, false,
				Constants.COLOR_2);
	}

	@Override
	public void render(GameContainer gc, StateBasedGame sbg, Graphics g)
			throws SlickException {
		// Yellow background
		Asset.getImage(Asset.IMG_HOME_BACKGROUND).draw();

		// Rotating sun
		Asset.getImage(Asset.IMG_HOME_SUN).draw(-600, -650);

		// Foreground
		Asset.getImage(Asset.IMG_HOME_FOREGROUND).draw();

		// The menu
		g.rotate(0, 0, -Constants.TEXT_ANGLE.floatValue());
		for (int i = 0, l = MENU_ITEMS.length; i < l; i++) {
			if (i == menu.getIndex()) {
				// The current item is selected
				g.setFont(fontSelected);
			} else {
				g.setFont(fontDefault);
			}
			g.drawString(menu.getItem(i), 490, 380 + i * 90);
		}

		g.rotate(0, 0, Constants.TEXT_ANGLE.floatValue());
	}

	@Override
	public void update(GameContainer gc, StateBasedGame sbg, int t)
			throws SlickException {
		// Rotate the sun
		Asset.getImage(Asset.IMG_HOME_SUN).rotate(Constants.SUN_ROTATION_SPEED);

		Input input = gc.getInput();
		if (input.isKeyPressed(Input.KEY_DOWN)
				|| input.isKeyPressed(Input.KEY_S)) {
			menu.next();
		} else if (input.isKeyPressed(Input.KEY_UP)
				|| input.isKeyPressed(Input.KEY_Z)) {
			menu.previous();
		}

		if (input.isKeyPressed(Input.KEY_SPACE)
				|| input.isKeyPressed(Input.KEY_ENTER)) {
			// Go to the selected state
			switch (menu.getIndex()) {
			case 0:
				// Play
				sbg.enterState(State.PLAY.ordinal());
				break;
			case 1:
				// Highscores
				break;
			case 2:
				// DLC (credits)
				break;
			}
		}
	}

	@Override
	public int getID() {
		return State.MENU.ordinal();
	}

}
