package rcpexplorer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "RCPExplorer";
	
	public static final String BUNDLE = "icons/bundle.gif";
	public static final String BUNDLE_OF = "icons/bundleOf.gif";

	public static final String EXTENSION_POINT = "icons/extensionpoint.gif";
	public static final String EXTENSION_POINT_IN = "icons/extensionpointIn.gif";
	public static final String EXTENSION_POINT_FOR = "icons/extensionpointFor.gif";

	public static final String EXTENSION = "icons/extension.gif";
	public static final String EXTENSION_IN = "icons/extensionIn.gif";
	public static final String EXTENSION_OF = "icons/extensionOf.gif";
	
	public static final String ELEMENT = "icons/element.gif";
	
	public static final String ATTRIBUTE = "icons/attribute.gif";

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		reg.put(BUNDLE, createImageDescriptor(BUNDLE));
		reg.put(BUNDLE_OF, createImageDescriptor(BUNDLE_OF));
		reg.put(EXTENSION_POINT, createImageDescriptor(EXTENSION_POINT));
		reg.put(EXTENSION_POINT_IN, createImageDescriptor(EXTENSION_POINT_IN));
		reg.put(EXTENSION_POINT_FOR, createImageDescriptor(EXTENSION_POINT_FOR));
		reg.put(EXTENSION, createImageDescriptor(EXTENSION));
		reg.put(EXTENSION_IN, createImageDescriptor(EXTENSION_IN));
		reg.put(EXTENSION_OF, createImageDescriptor(EXTENSION_OF));
		reg.put(ELEMENT, createImageDescriptor(ELEMENT));
		reg.put(ATTRIBUTE, createImageDescriptor(ATTRIBUTE));
	}

	private ImageDescriptor createImageDescriptor(String id) {
		return imageDescriptorFromPlugin(PLUGIN_ID, id);
	}

}
