package ihm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import upmc.li260.langage.Commande;
import upmc.li260.langage.logo.*;

public class Controller implements ActionListener{
    ProgrammeConstructor ihm ;
  
    
public Controller(ProgrammeConstructor ihm){
    this.ihm = ihm;
}    

 

private void tournerGaucheActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                              
        ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getGaucheAngle().getText()));
        try {
            CommandeAvecParametre gauche=new CommandeAvecParametre("tournerGauche",para);
            ihm.getProgramme().addCommande(gauche);
            ihm.update();
        } catch (MauvaiseCommandeException ex) {
            ex.printStackTrace();
        }
    }                                             

    private void reculerActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                        
        ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getPasReculer().getText()));
        try {
            CommandeAvecParametre reculer=new CommandeAvecParametre("Reculer",para);
            ihm.getProgramme().addCommande(reculer);
            ihm.update();
        } catch (MauvaiseCommandeException ex) {
            ex.printStackTrace();
        }
    }                                       

    private void tournerDroiteActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                              
        ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getDroiteAngle().getText()));
        try {
            CommandeAvecParametre droite=new CommandeAvecParametre("tournerDroite",para);
            ihm.getProgramme().addCommande(droite);
            ihm.update();
        } catch (MauvaiseCommandeException ex) {
            ex.printStackTrace();
        }
    }                                             

    private void avancerActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                        
        ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getPasAvancer().getText()));
        try {
            CommandeAvecParametre avance=new CommandeAvecParametre("Avancer",para);
            ihm.getProgramme().addCommande(avance);
            ihm.update();
        } catch (MauvaiseCommandeException ex) {
            ex.printStackTrace();
        }

    }
    
    private void abaisserActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                        
       
        Commande abaisser=new Commande("Abaisser");
		ihm.getProgramme().addCommande(abaisser);
		ihm.update();

    }
    
    private void leverActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                        
        
        Commande lever=new Commande("Lever");
		ihm.getProgramme().addCommande(lever);
		ihm.update();

    }
    
    private void runActionPerformed(java.awt.event.ActionEvent evt) throws MauvaiseCommandeException {                                        
        ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getPasAvancer().getText()));
            ihm.getProgramme().executable(true,ihm.getEff());
            ihm.update();
      
    }
    
    private void RetirerActionPerformed(ActionEvent arg0) {
        ihm.getProgramme().getProgramme().removeElementAt((ihm.getProgramme().getProgramme().size()-1));
        ihm.update();
    }
    
    private void ResetActionPerformed(ActionEvent arg0) {
        ihm.getProgramme().getProgramme().clear();
        ihm.update();
    }

    
    public void actionPerformed(ActionEvent arg0){
        JButton bouton=(JButton)arg0.getSource();
        if (bouton.getLabel().equals("Reculer")){
            try {
                reculerActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
}
        if (bouton.getLabel().equals("Avancer")){
            try {
                avancerActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
                    }
        if (bouton.getLabel().equals("TournerGauche")){
            try {
                tournerGaucheActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
                    }                            
        if (bouton.getLabel().equals("TournerDroite")){
            try {
                tournerDroiteActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
                           }
        if (bouton.getLabel().equals("Abaisser")){
            try {
                abaisserActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
                                        }
        if (bouton.getLabel().equals("Lever")){
            try {
                leverActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
                                            
                                             }
        if (bouton.getLabel().equals("-")){
                       RetirerActionPerformed(arg0);
        
                                    }
        if (bouton.getLabel().equals("Reset")){
                       ResetActionPerformed(arg0);
        
                                    }
        if (bouton.getLabel().equals("Run")){
            try {
                runActionPerformed(arg0);
            } catch (MauvaiseCommandeException ex) {
                Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        
        
    }

   

    
    
}
    
    
                         
      