/*
 * ImageUtil.java
 *
 * Created on 15 mai 2008, 17:09
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package upmc.li260.imageutil;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import upmc.li260.imageutil.IOUtils;
/**
 * Classe facilitant le traitement des images .
 * @author Philippe
 */
public class ImageUtil{
	
	
	/**
	 * mthode  permettant de charger une image
	 * @param chemin chemin de l'image
	 * @return Renvoie l'image associé au chemin donnée en paramètre
	 * @throws IOException
	 */
	public static Image getImage(String path) throws IOException {
		
		return javax.imageio.ImageIO.read(IOUtils.getRessourceStream(path));
		
	}
	
	/**
	 * Transforme l'image passé en paramètre en une image stockée en mémoire afin 
	 * d'effectuer sur celle-ci des opérations graphiques
	 * @param image l'image de base
	 * @return une image mise en mémoire
	 */
	public static BufferedImage toBufferedImage(Image image) {
        /** On test si l'image n'est pas déja une instance de BufferedImage */
        if( image instanceof BufferedImage )
                return( (BufferedImage)image );
        else {
                /** On s'assure que l'image est complètement chargée */
                image = new ImageIcon(image).getImage();
                
                /** On crée la nouvelle image */
                BufferedImage bufferedImage = new BufferedImage(
                                                      image.getWidth(null),
                                                      image.getHeight(null),
                                                      BufferedImage.TYPE_INT_RGB );
                Graphics g = bufferedImage.createGraphics();
                g.drawImage(image,0,0,null);
                g.dispose();
                
                return( bufferedImage );
        } 
	}
	
	
	/**
	 * Oriente une image selon un angle
	 * @param image l'image de base
	 * @param angle l'angle en degré
         * @return une image orientée selon l'angle spécifié en paramètree
	 */
	public static BufferedImage getRotatedImage(BufferedImage img,long angle) {
		
		AffineTransform at = new AffineTransform();
		at.translate(img.getWidth()/2, img.getHeight()/2);
		at.rotate(angle*Math.PI/180);
		at.translate(-img.getWidth()/2, -img.getHeight()/2);
		AffineTransformOp atOp = new AffineTransformOp(at, AffineTransformOp.TYPE_BICUBIC);
		
		int w = (int)Math.round(atOp.getBounds2D(img).getWidth());
		int h = (int)Math.round(atOp.getBounds2D(img).getHeight());
		
		BufferedImage bimgDest = new BufferedImage(w,h,BufferedImage.TYPE_INT_ARGB);
		atOp.filter(img, bimgDest);
	
		return bimgDest;
	}
	
}