/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package upmc.li260.langage;
import upmc.li260.langage.logo.*;
import upmc.li260.langage.logo.CommandeAvecParametre;

/**
 * Cette classe reprsente un dcodeur qui transforme le langage logo en langage
 * tortue
 * @author philippe
 */
public class DecodeurTortue implements IDecodeur {
    /**langage reprsente le langage  dcoder**/
    private Langage langage;
    
    /**
     * Initialise une instance du decodeur tortue avec un langage
     * @param langage
     */
    public DecodeurTortue(Langage langage){
        this.langage=langage;
    }
    
    /**
     * @override la mthode de IDecodeur
     * Cette mthode permet le dcodage d'une commande du langage en un langage
     * tortue 
     * @param c la commande
     * @return une commande comprhensible par la tortue
     * @throws upmc.li260.langage.logo.MauvaiseCommandeException
     */
    public Commande decodeCmd(Commande c) throws MauvaiseCommandeException  {
        
        if (c.getNom().equals("Avancer")) {
            CommandeAvecParametre resultat = new CommandeAvecParametre("Avancer");            
            resultat.setParametre(((CommandeAvecParametre) c).getParametreInt());
             resultat.setNom("Bouger");
            return resultat;
        }
        if (c.getNom().equals("Reculer")) {
            CommandeAvecParametre resultat = new CommandeAvecParametre("Reculer");           
            resultat.setParametre(((CommandeAvecParametre) c).getParametreInt());
            resultat.setNom("Bouger");
            return resultat;
        }
      if (c.getNom().equals("tournerGauche")) {
            CommandeAvecParametre resultat = new CommandeAvecParametre("tournerGauche");
            resultat.setParametre(((CommandeAvecParametre) c).getParametreInt());
            resultat.setNom("Tourner");
            return resultat;
        }
        if (c.getNom().equals("tournerDroite")) {
            CommandeAvecParametre resultat = new CommandeAvecParametre("tournerDroite");
            resultat.setParametre(((CommandeAvecParametre) c).getParametreInt());
            resultat.setNom("Tourner");
            return resultat;
        }
        if (c.getNom().equals("Abaisser")) {
            Commande resultat = new Commande("Abaisser");
            resultat.setNom("Abaisser");
            return resultat;
            
        }
        if (c.getNom().equals("Lever")) {
            Commande resultat = new Commande("Lever");
            resultat.setNom("Lever");
            return resultat;
        }
       
        throw new MauvaiseCommandeException("mauvaise commande") ;
   
        
        

    }
}
