package upmc.li260.mvc;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTextField;
import upmc.li260.ihm.ProgrammeConstructor;
import upmc.li260.langage.Commande;
import upmc.li260.langage.logo.*;
/**
 * Reprsente un lment du MVC, le controller
 * Fait le lien entre la vue et le model. Toutes les interactions sur le model sont
 * rprcute sur la vue.
 * @author Philippe
 */
public class Controller implements ActionListener,MouseListener{
    /**reprsente l'interface homme machine sur laquelle les actions sont ffectue **/
    ProgrammeConstructor ihm ;
  
    /**
     * Initialise une instance de controller avec une ihm
     * @param ihm
     */
     
    public Controller(ProgrammeConstructor ihm){
    this.ihm = ihm;
    
            
     
          
    }    

 
/**
 * mthode  effectuer lorsque l'on presse la touche tournerGauche est press.Faire tourner le robot  Gauche
 * Le paramtre dans case de saisie doit tre un nombre.
 * @param evt
 * @throws upmc.li260.langage.logo.MauvaiseCommandeException
 * @throws java.lang.NumberFormatException
 */
    private void tournerGaucheActionPerformed(java.awt.event.ActionEvent evt) throws NumberFormatException {                                              
    
        try {
            ParametreInt para=new ParametreInt(-Integer.parseInt(ihm.getGaucheAngle().getText()),-1);
            CommandeAvecParametre gauche=new CommandeAvecParametre("tournerGauche",para);
            ihm.getProgramme().addCommande(gauche);
            ihm.update("Tourner");
        } catch (NumberFormatException ex) {
             ihm.jOptionPane1.setEnabled(true);
             ihm.jOptionPane1.showMessageDialog(ihm.jDialog1,"Erreur : Entrez un paramtre valide pour la commande tournerGauche");
        }
    }    
    /**
     * Mthode  effectuer lorsque le bouton Reculer est press.Faire reculer le robot
     * Le paramtre dans case de saisie doit tre un nombre.
     * @param evt
     * @throws java.lang.NumberFormatException
     */
    private void reculerActionPerformed(java.awt.event.ActionEvent evt) throws NumberFormatException {                                        
        
        try {
            ParametreInt para=new ParametreInt(-Integer.parseInt(ihm.getPasReculer().getText()),-1);
            CommandeAvecParametre reculer=new CommandeAvecParametre("Reculer",para);
            ihm.getProgramme().addCommande(reculer);
            ihm.update("Bouger");
        } catch (NumberFormatException ex) {
             ihm.jOptionPane1.setEnabled(true);
            ihm.jOptionPane1.showMessageDialog(ihm.jDialog1,"Erreur : Entrez un paramtre valide pour la commande reculer");
           
        }
    }                                      
    /**
     * Mthode  effectuer lorsque le bouton tournerDroite est press.Faire tourner robot  droite.
     * Le paramtre dans case de saisie doit tre un nombre.
     * @param evt
     * @throws java.lang.NumberFormatException
     */
    private void tournerDroiteActionPerformed(java.awt.event.ActionEvent evt) throws NumberFormatException {                                              
        
        try {
            ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getDroiteAngle().getText()),1);
            CommandeAvecParametre droite=new CommandeAvecParametre("tournerDroite",para);
            ihm.getProgramme().addCommande(droite);
            ihm.update("Tourner");
        } catch (NumberFormatException ex) {
             ihm.jOptionPane1.setEnabled(true);
            ihm.jOptionPane1.showMessageDialog(ihm.jDialog1,"Erreur : Entrez un paramtre valide pour la commande tournerDroite");
        }
    }                                             
    
    /**
     * Mthode  effectuer lorsque le bouton Avancer est press.Faire avancer le robot
     * Le paramtre dans case de saisie doit tre un nombre.
     * @param evt
     * @throws java.lang.NumberFormatException
     */
    private void avancerActionPerformed(java.awt.event.ActionEvent evt) throws NumberFormatException {                                        
       
        try {
            ParametreInt para=new ParametreInt(Integer.parseInt(ihm.getPasAvancer().getText()),1);
            CommandeAvecParametre avance=new CommandeAvecParametre("Avancer",para);
            ihm.getProgramme().addCommande(avance);
            ihm.update("Bouger");
        } catch (NumberFormatException ex) {
            ihm.jOptionPane1.setEnabled(true);
            ihm.jOptionPane1.showMessageDialog(ihm.jDialog1,"Erreur : Entrez un paramtre valide pour la commande avancer");
        }

    }
    /**
     * Mthode  effectuer lorsque le bouton Baisser est press.Baisser le stylo.
     * @param evt
     */
    private void abaisserActionPerformed(java.awt.event.ActionEvent evt)  {                                        
                Commande abaisser=new Commande("Abaisser");
		ihm.getProgramme().addCommande(abaisser);
		ihm.update("Abaisser");

    }
    /**
     * Mhode  effectuer lorsque le bouton Lever est press.Lever le stylo
     * @param evt
     */
    private void leverActionPerformed(java.awt.event.ActionEvent evt)  {                                        
        
                Commande lever=new Commande("Lever");
		ihm.getProgramme().addCommande(lever);
		ihm.update("Lever");

    }
    
    /**
     * Mthode  effectuer lorsque le bouton Run est press.Execution du Programme.
     * @param arg0
     */
    private void runActionPerformed(java.awt.event.ActionEvent evt) {                                        
            ihm.jProgressBar1.setToolTipText("chargement");
           ihm.getProgramme().executable(true,ihm.getEff1());
                    ihm.update("salut");
            Thread t = new Thread() {
                  
                public void run(){
                    for(int i=0;i<=100;i++){
                    try {
                        Thread.sleep(20);
                    } catch (InterruptedException ex) {
                        Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ihm.jProgressBar1.setValue(i); 
                    
                    }
                    
            
                }
            };
            t.start();
    }
    
    /**
     * Mthode  effectuer lorsque le bouton - a t press.
     * @param arg0
     * @throws java.lang.ArrayIndexOutOfBoundsException
     */
    private void RetirerActionPerformed(ActionEvent arg0)throws ArrayIndexOutOfBoundsException {
            try{
                
                ihm.getProgramme().getProgramme().removeElementAt((ihm.getProgramme().getProgramme().size()-1));
                ihm.update("salut");
            } catch(ArrayIndexOutOfBoundsException ex){
            }    
    }
    
    /**
     * Mthode  effectuer lorsque le bouton reset a t press.Effacer la liste de commandes
     * @param arg0
     */
    private void ResetActionPerformed(ActionEvent arg0) {
        ihm.getProgramme().getProgramme().clear();
        ihm.update("salut");
    }
    /**
     * Mthode  effectuer lorsque le bouton stop a t cliqu. Arrt d'urgence.
     * @param arg0
     */
    private void stopActionPerformed(ActionEvent arg0) {
        ((Model)ihm.getEff1()).getRobot().stop();
        ihm.setVisible(false);
    }

    /**
     * Cette mthode analyse l'venement qui a t cout et indique la mthode  utiliser
     * @param arg0
     */
    public void actionPerformed(ActionEvent arg0){
                JButton bouton=(JButton)arg0.getSource();
       
        if (bouton.getLabel().equals("Reculer")){
                        reculerActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("Avancer")){
                        avancerActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("TournerGauche")){
                        tournerGaucheActionPerformed(arg0);
            }                            
        if (bouton.getLabel().equals("TournerDroite")){
                        tournerDroiteActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("Abaisser")){
                        abaisserActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("Lever")){
                        leverActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("-")){
                       RetirerActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("Reset")){
                       ResetActionPerformed(arg0);
            }
        if (bouton.getLabel().equals("stop")){
                        stopActionPerformed(arg0);
            }
                
        if (bouton.getLabel().equals("Run")){
                        runActionPerformed(arg0);
            }
    }
/**
 * Mthode dfinissant l'action  effectuer quand on clique sur le champs de saisie de texte
 * avec l'venement e
 * @param e
 */
    public void mouseClicked(MouseEvent e) {
        JTextField carreSaisie=(JTextField)e.getSource();
        carreSaisie.setText("");
    }

    // les mthodes suivantes sont justes l'implmentation de l'interface MouseListener
    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }


   

    
    
}
    
    
                         
      