/*
 * Model.java
 *
 * Created on 28 février 2008, 11:01
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package upmc.li260.mvc;

import java.util.Iterator;
import java.util.Vector;
import upmc.li260.langage.IEffecteur;
import upmc.li260.robot.Robot;

/**
 * Reprsente un type du MVC, le model.
 * @author 2500397
 */
public abstract class Model {
    /**Reprsente la liste des vues qui sont abonnes au model**/
        private Vector vues=new Vector();
    
    /**
     * Mthode qui permet d'abonner une vue au model.
     * @param vue
     */    
    public void abonner(IUpdate vue){
        vues.add(vue);
        
    }
    
    /**
     * Mthode permettant de dsabonner une vue du model
     * @param vue
     */
    public void desabonner(IUpdate vue){
        vues.remove(vue);
    }
    
    /**
     * Mthode utiliser pour l'arrt d'urgence du robot, permet de rcuprer le robot d'une vue
     * @return un robot
     */
    public Robot getRobot(){
         Iterator it=vues.iterator();
            while(it.hasNext()){
            IUpdate maVue=(IUpdate)it.next();
            if (maVue instanceof Robot){
                return (Robot)maVue;
            }
            
            
        }
        return null;
    }
    
    /**
     * Changed appelle la mthode update sur toutes les vues qui sont abonnes au model.
     * @param s
     */
    public void changed(String s){
        Iterator it=vues.iterator();
            while(it.hasNext()){
            IUpdate maVue=(IUpdate)it.next();
            
            maVue.update(s);
        }
        
        
     
    }
}
