/*
 * Robot.java
 *
 * Created on 9 avril 2008, 16:24
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package upmc.li260.robot;

import robot.basniveau.NXT.NXTCommRXTX;
import robot.basniveau.capteur.nxt.CapteurTachometreNxt;
import upmc.li260.mvc.IUpdate;
import upmc.li260.mvc.Model;
import robot.basniveau.MaterielRobotGenerique;
import robot.basniveau.NXT.EncodeurRobotNxt;

import robot.basniveau.NXT.MaterielEffecteurNxt;
import robot.commande.CommandeInexistanteException;
import robot.commande.nxt.CommandeFactoryNxtBase;
import robot.commande.nxt.CommandeNxt;
import upmc.li260.langage.Commande;
import upmc.li260.langage.IEffecteur;
import upmc.li260.tortue.Tortue;
/**
 * Classe reprsentant un robot 
 * @author philippe
 */
public class Robot implements IUpdate {
    /** Reprsente le priphrique robot auquel on se connecte**/
    private MaterielEffecteurNxt eff;
    /**Reprsente un encodeur de commande avec le robot**/
    private EncodeurRobotNxt enc;
    /**Reprsente le robot avec un port bluetooth et un encodeur caractristique**/
    protected MaterielRobotGenerique rob;
    /**Reprsente la tortue  partir de laquelle le robot effectuera les commandes**/
    protected  Tortue tortue;
    /**variable montrant si le robot est en marche ou pas**/
    protected boolean isRunning;
    /** Capteur du moteur A du robot**/
    protected CapteurTachometreNxt mot0;
    /**Capteur du moteur B du robot**/
    protected CapteurTachometreNxt mot1;
    /**Capteur du moteur C du robot**/
    protected CapteurTachometreNxt mot2;
    
   
    /**
     * Initialise une instance de robot avec en paramtre une tortue
     * @param tortue
     */
    public Robot(Tortue tortue) {
        enc=new EncodeurRobotNxt();
        eff=new MaterielEffecteurNxt("COM40");
        rob=new MaterielRobotGenerique(enc,eff);
        this.tortue=tortue;
        this.mot0=new CapteurTachometreNxt(0,eff.getComm());
        this.mot1=new CapteurTachometreNxt(1,eff.getComm());
        this.mot2=new CapteurTachometreNxt(2,eff.getComm());
        this.isRunning=true;
    }

    public Robot() {
        enc=new EncodeurRobotNxt();
        eff=new MaterielEffecteurNxt("COM40");
        rob=new MaterielRobotGenerique(enc,eff);
        
        this.mot0=new CapteurTachometreNxt(0,eff.getComm());
        this.mot1=new CapteurTachometreNxt(1,eff.getComm());
        this.mot2=new CapteurTachometreNxt(2,eff.getComm());
        this.isRunning=true;
    }
           
    /**
     * Cette mthode met a jour l'etat du robot en fonction des actions qu'execute la tortue
     * @param type
     */           
    public void update(String type)    {
                isRunning = true ;
                while(this.isRunning){
                        try {
                        Thread.sleep(1500);
                        this.verifyRunning();
                    } catch (InterruptedException ex) {
                         ex.printStackTrace();
                        }
                }    
     
                if (type.equals("Bouger")){
                     this.avance();
                }
                if(type.equals("Tourner")){
                    this.tourner(0);
                    this.tourner((tortue.getOrientation()-tortue.getAncienneOrientation()));
                }
                if(type.equals("Lever")){
                    this.lever();               
                }
                if(type.equals("Abaisser")){
                    this.baisser() ;
                }
    
    }
    /**
     * Mthode qui fait lever le stylo du robot
     * 
     */
    private void lever(){
        CommandeFactoryNxtBase cf = new CommandeFactoryNxtBase();
        try {
            CommandeNxt cmd1= (CommandeNxt) cf.construitCommande("avanceA -1 " + 0 + " 0");
            cmd1.execute(rob);
            CommandeNxt cmd= (CommandeNxt) cf.construitCommande("avanceA -1 " + 30 + " 15");
            cmd.execute(rob);
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }
        
    }
    /**
     * Mthode d'Arrt d'urgence du robot
     */
    public void stop(){
        CommandeFactoryNxtBase cf = new CommandeFactoryNxtBase();
        try {
            CommandeNxt cmd1= (CommandeNxt) cf.construitCommande("avanceC 1 " + 0 + " 0");
            CommandeNxt cmd2= (CommandeNxt) cf.construitCommande("avanceB 1 " + 0 + " 0");
            cmd1.execute(rob);
            cmd2.execute(rob);
            
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }
          Thread.currentThread().interrupt();
    }
    /**
     * Mthode de lever du stylo du robot
     */
    private void baisser(){
        CommandeFactoryNxtBase cf = new CommandeFactoryNxtBase();
        try {
            
            CommandeNxt cmd1= (CommandeNxt) cf.construitCommande("avanceA 1 " + 0 + " 0");
            cmd1.execute(rob);
            CommandeNxt cmd= (CommandeNxt) cf.construitCommande("avanceA 1 " + 50 + " 20");
            cmd.execute(rob);
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }
        
        
    }
    /**
     * Mthode qui fait avancer ou reculer le robot
     */
    private void avance() {
        double dx=tortue.getPosition().getPx()-tortue.getAnciennePosition().getPx();
        double dy=tortue.getPosition().getPy()-tortue.getAnciennePosition().getPy();
        dx=dx*dx;
        dy=dy*dy;
        double h=Math.sqrt(dx+dy);
        CommandeFactoryNxtBase cf = new CommandeFactoryNxtBase();
        CommandeNxt cmd;
        CommandeNxt cmd2;
     if (tortue.getSensAvancer()==1){
        try {
            cmd = (CommandeNxt) cf.construitCommande("avanceC 1 " + (int)h*36 + " 30");
            cmd2= (CommandeNxt) cf.construitCommande("avanceB 1 "+ (int)h*36 + " 30");
            cmd.execute(rob);
            cmd2.execute(rob);
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }  
    }
     else{
         try {
            cmd = (CommandeNxt) cf.construitCommande("avanceC -1 " + (int)h*36 + " 30");
            cmd2= (CommandeNxt) cf.construitCommande("avanceB -1 "+ (int)h*36 + " 30");
            cmd.execute(rob);
            cmd2.execute(rob);
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }    
     }
    }
    /**
     * Mthode qui fait tourner le robot d'un certain angle
     * @param angle
     */
    private void tourner(double angle){
        double d=2*angle;
        CommandeFactoryNxtBase cf = new CommandeFactoryNxtBase();
        CommandeNxt cmd;
        CommandeNxt cmd2;
      
        try {
            if(d>0){ 
                cmd = (CommandeNxt) cf.construitCommande("avanceC 1 " + (int)d + " 20");
                cmd2= (CommandeNxt) cf.construitCommande("avanceB -1 "+ (int)d + " 20");
                cmd.execute(rob);
                cmd2.execute(rob);
            }
            else {
                d=-d;
                System.out.println("d est egale a "+d);
                cmd = (CommandeNxt) cf.construitCommande("avanceC -1 " + (int)d + " 20");
                cmd2= (CommandeNxt) cf.construitCommande("avanceB 1 "+ (int)d + " 20");
                cmd.execute(rob);
            cmd2.execute(rob);
            }
               
             
        } catch (CommandeInexistanteException ex) {
            ex.printStackTrace();
        }
      
    }
    
    /**
     * Mthode qui vrifie le robot est en train d'executer une commande
     * @throws java.lang.InterruptedException
     */
    public void verifyRunning() throws InterruptedException{
        Object tA0=mot0.getValue();
        Object tB0=mot1.getValue();
        Object tC0=mot2.getValue();
        Thread.sleep(1500);
        Object tA1=mot0.getValue();
        Object tB1=mot1.getValue();
        Object tC1=mot2.getValue();
        
        if((tA0.equals(tA1))&&(tB0.equals(tB1))&&(tC0.equals(tC1))){
            this.isRunning=false;
        }
        else{
            this.isRunning=true;
        }   
    }
   /**
    * Accesseur du booleen isRunning
    * @return isRunning
    */
    public boolean getRunning(){
        return this.isRunning;
    }
    
    /**
     * Modificateur de isRunning
     * @param b
     */
    public void setRunning(boolean b){
        isRunning=b;
    }
    
}

    

