/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package upmc.li260.tortue;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.smartcardio.CommandAPDU;
import upmc.li260.mvc.Model;
import upmc.li260.langage.*;
import upmc.li260.langage.logo.CommandeAvecParametre;
import upmc.li260.langage.logo.MauvaiseCommandeException;

/**
 * Reprsente un effecteur de programme 
 * @author philippe
 */
public class Tortue extends Model implements IEffecteur {
       /** l'orientation de la tortue en degrs**/
       private int orientation ;
       /** la position de la tortue**/
       private Position position;
       /** l'etat du stylo baisser=true**/
       private boolean stylo;
       /** la position de la tortue avant que la commande en cours ne soit execut**/
       private Position anciennePosition;
       /**Orientation de la tortue avant que la commande en cours ne soit execut**/
       private int ancienneOrientation;
       /**entier pour sauvegarder le sens du parametreInt de la commande**/
       private int sensavancer;
       
       /**
        * Initialise une nouvelle instance de tortue avec une orientation et une position initiale
        * @param orientation
        * @param position
        */
       public Tortue(int orientation, Position position) {
        this.orientation = orientation;
        this.position = position;
        this.stylo=false;
       }
        /**
         * accesseur de la position de la tortue
         * @return anciennePosition
         */
        public Position getAnciennePosition() {
            return anciennePosition;
        }
    
        /**
         * accesseur de l'orientation de la tortue
         * @return orientation
         */
        public float getOrientation() {
            return orientation;
        }
        /**
         * accesseur de la position de la tortue
         * @return position
         */
        public Position getPosition() {
            return position;
        }
        /**
         * accesseur de l'etat du bras du stylo 
         * @return stylo
         */
        public boolean isStylo() {
            return stylo;
        }
        
        /**
         * mthode d'execution des commandes,donc qui fait changer de position la tortue
         * @param c une commande
         * @throws upmc.li260.langage.logo.MauvaiseCommandeException
         */
        public void execute(Commande c)throws MauvaiseCommandeException{
            this.anciennePosition=this.position.copy();
            this.ancienneOrientation=(int)this.getOrientation();
                if (c.getNom().equals("Bouger")) {
                    int pas = ((CommandeAvecParametre)c).getParametreInt().getPas();
                    this.sensavancer=((CommandeAvecParametre)c).getParametreInt().getSens();
                    this.position.setPx((int)(this.position.getPx()+pas*Math.cos(Math.toRadians(orientation))));
                    this.position.setPy((int)(this.position.getPy()+pas*Math.sin(Math.toRadians(orientation))));
                    this.sensavancer=((CommandeAvecParametre)c).getParametreInt().getSens();
                    this.changed("Bouger");
            
                }
       
                if (c.getNom().equals("Tourner")) {
                    int pas = ((CommandeAvecParametre)c).getParametreInt().getPas();
                    this.orientation=(this.orientation+pas);
                    this.changed("Tourner");
                }
       
                if (c.getNom().equals("Abaisser")&& !stylo) {
                    this.stylo=true; 
                    this.changed("Abaisser");
            
                }
                
                if (c.getNom().equals("Lever")&&stylo) {
                    this.stylo=false;
                    this.changed("Lever");
            
                }
        
        
        
   }
    
     /**
      * Mthode implment du IDecodeur qui permet de dcoder une commande du langage logo vers tortue 
      * @param c
      */
    public void executeCommande(Commande c){
        Langage l=new Langage();
        DecodeurTortue eg=new DecodeurTortue(l);
        try{
            if(c instanceof CommandeAvecParametre){
                CommandeAvecParametre res;
                res=(CommandeAvecParametre) eg.decodeCmd(c);
                this.execute(res);
            }
            else{
                Commande res;
                res=eg.decodeCmd(c);
                this.execute(res);
            }
            
            }   
        catch(MauvaiseCommandeException e){
                System.out.println("mauvaise commande");
           
            
        }    
        
    }

    
    
    public String toString(){
        return ("position:"+" "+this.getOrientation()+" "+getPosition().toString()+" "+isStylo());
    }

   /**
    * accesseur de l'ancienne orientation de la tortue
    * @return ancienneOrientation
    */
    public float getAncienneOrientation() {
        return this.ancienneOrientation;
    }

    

  /**
   * accesseur du SensAvancer 
   * @return sensavancer
   */
    public int getSensAvancer(){
        return sensavancer;
    }
}


