package org.rlcommunity.critter.Controls;

//import java.io.BufferedReader;
import java.io.BufferedWriter;
//import java.io.FileNotFoundException;
//import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.rlcommunity.critter.SimulatorMain;
import org.rlcommunity.critter.Base.Vector2D;
import org.rlcommunity.critter.WRobotModels.TwoWheeledRobotModel;

/** The default controller used by TwoWheeledRobotControllerClient from org.rlcommunity.critter.Clients.
 *  This specific controller almost implements line tracing 
 *  This is the default controller created.
 */
public class DefaultTwoWheeledController implements Controller {
	/** The robot that can be controlled` */
	public TwoWheeledRobot robot;
	
	/** Just stores a handle of the robot for later reference */
	public DefaultTwoWheeledController( TwoWheeledRobot robot ) {
		this.robot = robot;
	}
	
	/** Reimplement this method if you want a better controller.
	 *  
	 *  What you should do:
	 *  Simply read the sensor values available and compute the controls
	 *  and set them on the robot
	 */
	public void computeControl()
	{
		double diff = robot.getLightR()-robot.getLightL(); 
		// gives how much we want to turn lightR
		// turning lightR means lightL wheel should be faster than the lightR wheel
		final double gain1 = 10, gain2 = 1.0;
		double a = gain1*diff;
		final double b = 10.0; // desired angular velocity of wheels 
		// solution of
		// vL - vR = a, 1/2(vL+vR) = b:
		double vL = b+a/2.0;
		double vR = b-a/2.0;
		// these are the target velocities for the wheels
		final boolean propcontrol = false;
		double vLerr = gain2*(vL-robot.getVelL());
		double vRerr = gain2*(vR-robot.getVelR());
		double tL, tR;
		if (propcontrol)
		{
			// we implement a simple proportional control:
			tL = vLerr;
			tR = vRerr;
			final double torqueCap = 0.2;
			tL = trunc( tL, -torqueCap, torqueCap );
			tR = trunc( tR, -torqueCap, torqueCap );
			//		System.out.printf("L=%f, R=%f, diff=%f, a=%f, b=%f, vL=%f, vR=%f, vwx=%f, vwy=%f, t1=%f, t2=%f\n", 
			//				lightL,lightR,diff,a,b,vL,vR,velL,velR,t1,t2);
		}
		else
		{
			TwoWheeledRobotModel model = new TwoWheeledRobotModel();
			model.setWheelState(robot.getAngleL(), robot.getAngleR(), robot.getVelL(), robot.getVelR() );
			final double refptdisp = 10.0E-2; //3.2E-2; //20E-2;
			Vector2D currVel = model.computeRefptVel(refptdisp);
			double speed = 0.3;
			double angle = 3.0*Math.PI/2.0+1.0*Math.PI/3.0;
			Vector2D err = new Vector2D( speed*Math.cos(angle), speed*Math.sin(angle) );
			err.minusEquals(currVel);
			Vector2D control = new Vector2D(err);
			control.timesEquals(10.000);
			Vector2D currAcc = model.computeRefptAcc(refptdisp);
			currAcc.timesEquals(-0.0); // a sensible value is -1.0
			control.plusEquals(currAcc);
			//Vector2D accel = model.computeRefptAcc(refptdisp);
			Vector2D torque = model.feedbacklinControl(control, refptdisp);
			tL = torque.x; tR = torque.y;
//			final double torqueCap = 0.2;
//			tL = trunc( tL, -torqueCap, torqueCap );
//			tR = trunc( tR, -torqueCap, torqueCap );

			boolean writeFile = true;
			if (writeFile)
			{
				try {
					if (fstream==null)
					{
						fstream = new FileWriter("err.txt");
						out = new BufferedWriter(fstream);
						startTime = System.currentTimeMillis();
					}
					long time = System.currentTimeMillis();
					if (time-startTime<5000)
					{
						//double e_angle = Math.atan2(err.y, err.x); 
						out.write(time-startTime + "\t" +
								//e_angle + " " + err.length() + " " +
								err.x + "\t" + err.y + "\t" +
								//robot.getAngleL() +", " + robot.getAngleR() +", " 
								//+ robot.getVelL() +", "+ robot.getVelR() +", "
								+ tL + "\t" + tR + "\n" );
					}
					else  
					{
						if (out!=null)
						{
							System.out.println("DONE!");
							out.close();
							out = null;
						}
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			boolean readFile = false;
			if (readFile)
			{
				double sin;
				try {
//					if (freader==null){
//						freader=new FileReader("sin.txt");
//						in = new BufferedReader(freader);
//					}
//					sin=Double.parseDouble(in.readLine());
					if (counter<100){
						sin=readings[counter];
						robot.setTorques(sin, sin);
						//robot.setTorques(tL, tR);
					}else{ 
						robot.setTorques(tL, tR);
					}
					counter++;
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}				
			}		
		}
		if (SimulatorMain.runSensorCalibrationExperiment)
			tL = tR = 0;
		robot.setTorques(tL, tR);
	}
	long	   startTime;
	FileWriter fstream;
	BufferedWriter out;
	private final double[] readings={0.0, 0.8414709848078965, 0.9092974268256817, 0.1411200080598672, -0.7568024953079282, -0.9589242746631385, -0.27941549819892586, 0.6569865987187891, 0.9893582466233818, 0.4121184852417566, -0.5440211108893698, -0.9999902065507035, -0.5365729180004349, 0.4201670368266409, 0.9906073556948704, 0.6502878401571168, -0.2879033166650653, -0.9613974918795568, -0.7509872467716762, 0.14987720966295234, 0.9129452507276277, 0.8366556385360561, -0.008851309290403876, -0.8462204041751706, -0.9055783620066238, -0.13235175009777303, 0.7625584504796028, 0.956375928404503, 0.27090578830786904, -0.6636338842129675, -0.9880316240928618, -0.404037645323065, 0.5514266812416906, 0.9999118601072672, 0.5290826861200238, -0.428182669496151, -0.9917788534431158, -0.6435381333569995, 0.2963685787093853, 0.9637953862840878, 0.7451131604793488, -0.158622668804709, -0.9165215479156338, -0.8317747426285983, 0.017701925105413577, 0.8509035245341184, 0.9017883476488092, 0.123573122745224, -0.7682546613236668, -0.9537526527594719, -0.26237485370392877, 0.6702291758433747, 0.9866275920404853, 0.39592515018183416, -0.5587890488516163, -0.9997551733586199, -0.5215510020869119, 0.43616475524782494, 0.9928726480845371, 0.6367380071391379, -0.3048106211022167, -0.9661177700083929, -0.7391806966492229, 0.16735570030280691, 0.9200260381967906, 0.8268286794901034, -0.026551154023966794, -0.8555199789753223, -0.8979276806892913, -0.11478481378318722, 0.7738906815578891, 0.9510546532543747, 0.25382336276203626, -0.6767719568873076, -0.9851462604682474, -0.38778163540943045, 0.5661076368981803, 0.9995201585807313, 0.5139784559875352, -0.4441126687075084, -0.9938886539233752, -0.6298879942744539, 0.31322878243308516, 0.9683644611001854, 0.7331903200732922, -0.1760756199485871, -0.9234584470040598, -0.8218178366308225, 0.03539830273366068, 0.8600694058124532, 0.8939966636005579, 0.10598751175115685, -0.7794660696158047, -0.9482821412699473, -0.24525198546765434, 0.683261714736121, 0.9835877454343449, 0.3796077390275217, -0.5733818719904229, -0.9992068341863537, -0.5063656411097588, 0.45202578717835057, 0.9948267913584063, 0.6229886314423488, -0.32162240316253093, -0.9705352835374847, -0.7271425000808526, 0.18478174456066745, 0.926818505417785, 0.8167426066363169, -0.044242678085070965, -0.8645514486106083, -0.8899956043668333, -0.09718190589320902, 0.7849803886813105, 0.9454353340247703, 0.23666139336428604, -0.689697940935389, -0.9819521690440836, -0.3714041014380902, 0.5806111842123143, 0.9988152247235795, 0.4987131538963941, -0.45990349068959124, -0.9956869868891794, -0.6160404591886565, 0.329990825673782, 0.972630067242408, 0.7210377105017316, -0.19347339203846847, -0.9301059501867618, -0.8116033871367005, 0.05308358714605824, 0.8689657562142357, 0.8859248164599484, 0.08836868610400143, -0.7904332067228887, -0.9425144545582509, -0.2280522595008612, 0.6960801312247415, 0.9802396594403116, 0.363171365373259, -0.5877950071674065, -0.9983453608739179, -0.49102159389846933, 0.4677451620451334, 0.9964691731217737, 0.6090440218832924, -0.3383333943242765, -0.9746486480944947, -0.7148764296291646, 0.20214988141565363, 0.933320523748862, 0.8064005807754863, -0.06192033725605731, -0.8733119827746476, -0.8817846188147811, -0.0795485428747221, 0.7958240965274552, 0.9395197317131483, 0.21942525837900473, -0.702407785577371, -0.9784503507933796, -0.35491017584493534, 0.5949327780232085, 0.9977972794498907, 0.48329156372825655, -0.47555018687189876, -0.9971732887740798, -0.6019998676776046, 0.3466494554970303, 0.9765908679435658, 0.7086591401823227, -0.2108105329134813, -0.9364619742512132, -0.8011345951780408, 0.07075223608034517, 0.8775897877771157, 0.8775753358042688, 0.07072216723899125, -0.8011526357338304, -0.936451400117644, -0.21078106590019152, 0.7086804082392084, 0.9765843832906294, 0.346621180094276, -0.6020239375552833, -0.997171023392149, -0.47552366901205834, 0.48331795366796265, 0.9977992786806003, 0.594908548461427, -0.3549383576518463, -0.9784565746221131, -0.7023863292684921, 0.21945466799406363, 0.9395300555699313, 0.7958058429196471, -0.07957859166428352, -0.8817988360675502, -0.8732972972139946, -0.06189025071872073, 0.8064184068658304, 0.9333097001669604, 0.2021203593127912, -0.7148975077677643, -0.97464190312541, -0.3383050275409778, 0.6090679301910603, 0.9964666417661079, 0.46771851834275896, -0.491047853850463, -0.9983470937967718, -0.5877706198198406, 0.36319945137636067, 0.9802456219572225, 0.6960584883449115, -0.22808160941352784, -0.9425245273294025, -0.7904147414931815, 0.08839871248753149, 0.8859387978787574, 0.8689508382163493, 0.05305348526993529, -0.8116209973649744, -0.9300948780045254, -0.19344381715900788, 0.7210585970706318, 0.9726230624856244, 0.3299623697323973, -0.6160642040533645, -0.9956841897581032, -0.4598767232321427, 0.4987392818032813, 0.9988166912028082, 0.5805866409896447, -0.37143208943692263, -0.9819578697820255, -0.6896761131802671, 0.2366906812750767, 0.9454451549211168, 0.7849617132764033, -0.09721190751822432, -0.8900093488562771, -0.8645362993442719, -0.04421256322855966, 0.8167599996228085, 0.9268071855026884, 0.184752119221718, -0.727163193443649, -0.9705280195418053, -0.3215938602925038, 0.623012211003653, 0.9948237286710673, 0.45199889806298343, -0.5063916349244909, -0.9992080341070627, -0.5733571748155426, 0.37963562682930313, 0.9835931839466808, 0.6832397038158508, -0.24528120908194284, -0.9482917095220488, -0.7794471854988634, 0.10601748626711377, 0.8940101700837942, 0.8600540264645697, 0.035368177256176046, -0.8218350110128397, -0.9234468802429867, -0.1760459464712114, 0.7332108186087174, 0.9683569384347241, 0.3132001548706699, -0.6299114066849614, -0.9938853259197261, -0.4440856600409099, 0.5140043136735694, 0.99952109184891, 0.5660827877060441, -0.3878094208292295, -0.9851514363288851, -0.6767497645263835, 0.253852519790234, 0.9510639681125854, 0.7738715902084317, -0.11481475884166603, -0.8979409481081247, -0.8555043707508208, -0.026521020285755953, 0.8268456339220814, 0.9200142254959646, 0.16732598101183924, -0.739200998751274, -0.9661099892625297, -0.30478191109030295, 0.6367612505645516, 0.992869055025318, 0.43613762914604876, -0.5215767216183704, -0.9997558399011495, -0.5587640495890891, 0.39595283104274065, 0.9866325048439105, 0.6702068037805061, -0.2624039418616639, -0.9537617134939987, -0.7682353642374471, 0.12360303600011291, 0.9018013749637745, 0.8508876886558596, 0.01767178546737087, -0.8317914757822045, -0.9165094902005468, -0.15859290602857282, 0.7451332645574127, 0.9637873480674221, 0.2963397884973224, -0.6435612059762619, -0.9917749956098326, -0.42815542808445156, 0.5291082654818533, 0.9999122598719259, 0.551401533867395, -0.4040652194563607, -0.9880362734541701, -0.6636113342009432, 0.2709348053161655, 0.9563847343054627, 0.7625389491684939, -0.13238162920545193, -0.9055911481970673, -0.8462043418838515, -0.008821166113885877, 0.8366721491002946, 0.9129329489429682, 0.14984740573347818, -0.7510071512506543, -0.9613891968218607, -0.2878744485084861, 0.6503107401625525, 0.9906032333897737, 0.42013968223930687, -0.5365983551885637, -0.9999903395061709, -0.5439958173735323, 0.412145950487085, 0.9893626321783087, 0.6569638725243396, -0.27944444178438205, -0.9589328250406132, -0.7567827912998033, 0.14114985067939137, 0.9093099708898409, 0.8414546973619527, -3.014435335948845E-5, -0.8414872714892108, -0.9092848819352602, -0.14109016531210986, 0.7568221986283603, 0.9589157234143065, 0.2793865543595699, -0.6570093243162466, -0.9893538601694428, -0.41209101962194344, 0.5440464039108651, 0.9999900726865629, 0.5365474803247321, -0.42019439103217676, -0.9906114770998198, -0.6502649395607762, 0.28793218456003195, 0.9614057860636483, 0.7509673416102893, -0.14990701345623575, -0.9129575516827102, -0.8366391272115635, 0.00888145245887885, 0.8462364656975445, 0.9055655749932976, 0.13232187086982847, -0.7625779510977885, -0.9563671216345017, -0.27087677105340535, 0.6636564336219596, 0.9880269738337468, 0.4040100708226276, -0.5514518281149147, -0.9999114594340064, -0.5290571062774264, 0.42820991051876856, 0.9917827103751873, 0.6435150601529656, -0.2963973686521434, -0.9638034236249698, -0.745093055724214, 0.15865243143670757, 0.916533604797894, 0.8317580087191733, -0.017732064727370864, -0.8509193596391765, -0.9017753195144049, -0.12354320937804643, 0.7682739577117872, 0.953743591158287, 0.26234576530777837, -0.6702515472972181, -0.9866226783405293, -0.39589746896115763, 0.5588140476063818, 0.9997545059076306, 0.5215252820815293, -0.43619188095326605, -0.9928762402415507, -0.6367147631351318, 0.30483933083715453, 0.9661255498763623, 0.7391603938754915, -0.1673854194417015, -0.9200378500616057, -0.8268117243068012, 0.02658128773805108, 0.8555355864224281, 0.8979144124545271, 0.1147548686204055, -0.773909772204126, -0.9510453375319575, -0.2537942055031938, 0.6767941486332613, 0.9851410837124249, 0.38775384963726117, -0.5661324855759046, -0.9995192244043064, -0.5139525978344581, 0.4441396769705497, 0.9938919810238954, 0.6298645812915785, -0.31325740971087507, -0.9683719828857112, -0.73316982087163, 0.176105293265966, 0.9234700129260028, 0.8218006615020342, -0.035428428178979524, -0.860084784378807, -0.8939831563049628, -0.10595753713889097, 0.7794849530244592, 0.9482725721561587, 0.2452227616305097, -0.6832837250355236, -0.9835823060282404, -0.3795798508807975, 0.5734065686442813, 0.9992056333576834, 0.5063396468349013, -0.45205267588297, -0.9948298531417643, -0.6229650513149461, 0.32165094574030556, 0.970542546651256, 0.7271218060573148, -0.18481136973170906, -0.9268298244906983, -0.816725212907666, 0.04427279290137974, 0.8645665970913422, 0.8899818590686664, 0.09715190417988626, -0.7849990633729202, -0.9454255122693237, -0.2366321052384454, 0.689719768063795, 0.9819464674138593, 0.3713761131017696, -0.580635726907393, -0.9988137573367454, -0.4986870255363352, 0.45993025772913376, 0.9956897831154927, 0.6160167137641636, -0.33001928131531005, -0.9726370711153801, -0.7210168232776373, 0.19350296674212325, 0.9301170215238276, 0.8115857761709371, -0.053113688973945104, -0.8689806734225085, -0.8859108342361154, -0.08833865964017233, 0.7904516712343437, 0.9425043809306535, 0.22802290938096753, -0.6961017734720562, -0.9802336960326743, -0.36314327904015004, 0.5878193939808536, 0.9983436270438855, 0.4909953335002932, -0.46777180532247614, -0.9964717035719659, -0.6090201130220971, 0.33836176080013775, 0.9746553921779337, 0.7148553508409695, -0.20217940333482604, -0.9333313464826719, -0.8063827539523805, 0.061950423737127995, 0.8733266675417377, 0.8817704007607503, 0.07951849401287635, -0.7958423494121123, -0.9395094070026404, -0.21939584856455807, 0.7024292412479847, 0.9784441260755459, 0.35488199371552387, -0.5949570070443855, -0.9977952793125009, -0.483265173349392, 0.4755767042996153, 0.9971755532498972, 0.6019757972528995, -0.34667773058479046, -0.9765973517090915, -0.708637871481491, 0.21083999973521134, 0.9364725475338364, 0.8011165538942744, -0.07078230485740782, -0.8776042389525125, -0.8775608830339849, -0.07069209833337335, 0.8011706755616272, 0.9364408251331382, 0.21075159869536877, -0.708701675652129, -0.9765778977502884, -0.34659290437655327, 0.6020480068859135, 0.9971687571041068, 0.47549715072011806, -0.48334434316848646, -0.9978012770046274, -0.5948843183590627, 0.35496653913623116, 0.9784627975617406, 0.7023648723213674, -0.219484077409708, -0.9395403785729803, -0.7957875885887045, 0.07960864038153331, 0.8818130525190443, 0.873282610859792, 0.061860164125145584, -0.8064362322233966, -0.9332988757369771, -0.20209083702626568, 0.7149185852567496, 0.9746351572706857, 0.33827666045026744, -0.6090918379453792, -0.9964641095049708, -0.46769187421537717, 0.4910741133562503, 0.9983488258124457, 0.587746231938178, -0.36322753704942956, -0.9802515835834019, -0.6960368448325855, 0.22811095911894086, 0.9425345992440989, 0.7903962755452384, -0.08842873879073523, -0.8859527784925297, -0.8689359194288628, -0.053023383345603574, 0.811638606855743, 0.9300838049771285, 0.19341424210376837, -0.7210794829843191, -0.9726160568450356, -0.32993391349118173, 0.616087948358266, 0.9956813917222668, 0.4598499553568124, -0.49876540925697305, -0.9988181567744302, -0.5805620972394064, 0.37146007709824136, 0.9819635696276799, 0.6896542847984487, -0.23671996897079078, -0.9454549749583542, -0.7849430371582153, 0.09724190905490493, 0.8900230925369855, 0.864521149292347, 0.044182448331873195, -0.816777391867125, -0.9267958647454188, -0.18472249371488758, 0.7271838861456853, 0.9705207546642247, 0.3215653171302501, -0.6230357899988372, -0.9948206650797496, -0.451972008536893, 0.506417628279074, 0.9992092331198094, 0.5733324771196631, -0.37966351428611655, -0.9835986215652434, -0.683217692274733, 0.24531043247334874, 0.9483012769124547, 0.7794283006736524, -0.10604746068673451, -0.8940236757546596, -0.8600386463351707, -0.03533805174655298, 0.8218521846480703, 0.923435312642794, 0.17601627283386595, -0.7332313164778873, -0.9683494148893343, -0.31317152702365525, 0.6299348185230796, 0.9938819970129513, 0.4440586509707787, -0.514030170892537, -0.9995220242088421, -0.5660579379995188, 0.38783720589663306, 0.9851566112943334, 0.6767275715505089, -0.2538816765877605, -0.9510732821065815, -0.773852498155771, 0.11484470379581474, 0.8979542147110153, 0.8554887617489377, 0.026490886523445938, -0.8268625876027196, -0.9200024119591381, -0.1672962615688254, 0.7392213001816265, 0.9661022076387795, 0.3047532008014393, -0.6367844934113518, -0.9928654610638965, -0.4361105026479622, 0.5216024406758817, 0.999756505535219, 0.5587390498188232, -0.3959805115438519, -0.9866374167508005, -0.6701844311086327, 0.2624330297809573, 0.9537707733618594, 0.7682160664531459, -0.12363294914268595, -0.9018144014592891, -0.8508718520044144, -0.01764164581327013, 0.8318082081799767, 0.9164974316526442, 0.15856314310832614, -0.7451533679583873, -0.9637793089749802, -0.2963109980159809, 0.6435842780107317, 0.9917711368753414, 0.428128186283695, -0.5291338443628917, -0.9999126587279824, -0.5513763859920506, 0.40409279322248953, 0.9880409219176677, 0.6635887835859072, -0.27096382207826836, -0.9563935393373727, -0.7625194471644794, 0.13241150819283803, 0.9056039335646163, 0.8461882788236016, 0.008791022929352243, -0.8366886589042641, -0.912920646328743, -0.1498176016678404, 0.7510270550472058, 0.9613809008905675, 0.2878455800903205, -0.6503336395770626, -0.9905991101845337, -0.42011232727019937, 0.5366237918890951, 0.999990471552965, 0.5439705233633756, -0.4121734153579038, -0.9893670168342196, -0.6569411457329191, 0.279473385115912, 0.9589413745467228, 0.7567630866040035, -0.1411796931706552, -0.9093225141277265, -0.8414384091513941, 6.0288706691585265E-5, 0.8415035574058807, 0.909272336218588, 0.14106032243614638, -0.7568419012610816, -0.9589071712941251, -0.2793576102663403, 0.6570320493166915, 0.9893494728164958, 0.41206355362767066, -0.5440716964379951, -0.9999899379137492, -0.536522042161478, 0.42022174485588953, 0.9906155976046185, 0.6502420383735517, -0.28796105219335977, -0.9614140793741277, -0.750947435766512, 0.14993681711330134, 0.9129698518082046, 0.8366226151268321, -0.008911595619283405, -0.8462525264509585, -0.9055527871571002, -0.1322919915216454, 0.7625974510230334, 0.9563583139954668, 0.2708477535528008, -0.663678982427899, -0.9880223226768295, -0.40398249595507346, 0.5514769744870444, 0.9999110578521441, 0.5290315259540843, -0.42823715115227945, -0.9917865664060436, -0.643491986364181, 0.29642615832557057, 0.963811460090061, 0.7450729502920265, -0.15868219392454155, -0.9165456608473167, -0.8317412740539448, 0.01776220433321534, 0.8509351939710194, 0.9017622905605737, 0.12351329589860735, -0.7682932534017909, -0.9537345286904526, -0.26231667667323905, 0.670273918142016, 0.986617763744047, 0.39586978738073614, -0.5588390458533631, -0.9997538375481824, -0.521499561602246, 0.43621900626234744, 0.9928798314963556, 0.6366915185525545, -0.30486804029509035, -0.9661333288664309, -0.7391400904300984, 0.16741513842849595, 0.9200496610903988, 0.8267947683721899, -0.026611421427981424, -0.8555511930921242, -0.8979011434038442, -0.11472492335334811, 0.773928862147125, 0.9510360209453427, 0.2537650480137331, -0.6768163397642243, -0.9851359060614224, -0.38772606351274697, 0.5661573337391944, 0.9995182893196364, 0.5139267392143615, -0.4441666848300092, -0.9938953072212839, -0.6298411677363565, 0.3132860367040136, 0.9683795037912949, 0.7331493210037495, -0.1761349664233212, -0.9234815780088051, -0.8217834856264904, 0.03545855359210518, 0.8601001621636173, 0.8939696481970214, 0.1059275624303434, -0.7795038357248096, -0.9482630021806919, -0.2451935375705356, 0.6833057347140384, 0.9835768657283723, 0.3795519623891559, -0.5734312647770955, -0.9992044316210529, -0.5063136520999421, 0.4520795641768173, 0.9948329140211382, 0.6229414706214662, -0.32167948802580176, -0.9705498088831128, -0.7271011113730546, 0.1848409947348159, 0.926841142721418, 0.8167078184368716, -0.044302907677458626, -0.86458174478646, -0.889968112961789, -0.09712190237828329, 0.7850177373512154, 0.945415689654786, 0.23660281689758147, -0.6897415945654649, -0.981940764891358, -0.3713481244279862, 0.5806602690748583, 0.998812289042307, 0.49866089672312836, -0.459957024350746, -0.9956925784370406, -0.6159929677799073, 0.3300477366569554, 0.9726440741045344, 0.7209959353983679, -0.19353254126994537, -0.9301280920157128, -0.8115681644677003, 0.0531437907535685, 0.8689955898411542, 0.8858968512072711, 0.08830863309607147, -0.7904701350275293, -0.9424943064466191, -0.22799355905387356, 0.6961234150868356, 0.9802277317343164, 0.36311519237705925, -0.5878437802601598, -0.9983418923066761, -0.49096907265595835, 0.46779844817476307, 0.9964742331166823, 0.6089962036074962, -0.33839012696853565, -0.9746621353757209, -0.7148342714031982, 0.20220892507028168, 0.9333421683683805, 0.8063649263965291, -0.06198051016190544, -0.8733413515152515, -0.8817561819054704, -0.07948844507877358, 0.7958606015736018, 0.9394990814384173, 0.21936643855075033, -0.7024506962803133, -0.9784379004686174, -0.35485381126363746, 0.5949812355249355, 0.9977932782684322, 0.48323878253139313, -0.47560322129518384, -0.997177816819599, -0.6019517262811898, 0.3467060053575308, 0.9766038345872008, 0.7086166021367329, -0.21086946636535486, -0.9364831199655037, -0.8010985118825478, 0.07081237357015184, 0.8776186893304462, 0.8775464294662774, 0.07066202936351883, -0.8011887146614145, -0.9364302492977055, -0.21072213129903983, 0.7087229424210653, 0.9765714113225485, 0.3465646283438878, -0.6020720756694737, -0.9971664899099553, -0.47547063199610207, 0.4833707322298039, 0.9978032744219705, 0.5948600877161377, -0.35499472029806434, -0.9784690196122566, -0.7023434147360162, 0.2195134866259111, 0.9395507007222859, 0.795769333534644, -0.07963868902644415, -0.8818272681692509, -0.8732679237120532, -0.06183007747535922, 0.8064540568481685, 0.9332880504589218, 0.20206131455610385, -0.714939662096101, -0.9746284105303279, -0.33824829305217113, 0.6091157451462272, 0.9964615763383645, 0.46766522966301216, -0.4911003724158074, -0.9983505569209379, -0.5877218435224411, 0.3632556223924401, 0.9802575443188444, 0.6960152006877834, -0.22814030861707352, -0.9425446703023311, -0.7903778088790765, 0.08845876501358538, 0.8859667583012527, 0.8689209998517899, 0.05299328137309047, -0.81165621560899, -0.9300727311045811, -0.1933846668727768, 0.7211003682427745, 0.9726090503206481, 0.3299054569501611, -0.6161116921033395, -0.9956785927816724, -0.4598231870636247, 0.49879153625744566, 0.998819621438444, 0.5805375529616218, -0.371488064422021, -0.9819692685810417, -0.6896324557899539, 0.23674925645140169, 0.9454647941364738, 0.7849243603267638, -0.09727191050322355, -0.8900368354089458, -0.8645059984548472, -0.044152333395038934, 0.8167947833692505, 0.9267845431459862, 0.18469286804020318, -0.7272045781869426, -0.9705134889047492, -0.3215367736757958, 0.6230593684278799, 0.9948176005844565, 0.4519451186001038, -0.5064436211734845, -0.9992104312245924, -0.5733077789028065, 0.3796914013979365, 0.9836040582900275, 0.6831956801127874, -0.24533965564184546, -0.9483108434411563, -0.7794094151401889, 0.10607743500999182, 0.8940371806131415, 0.86002326542427, 0.03530792620481886, -0.8218693575364985, -0.9234237442034923, -0.17598659903657765, 0.733251813680783, 0.9683418904640229, 0.31314289889206726, -0.6299582297887875, -0.9938786672030538, -0.4440316414971394, 0.5140560276444147, 0.9995229556605263, 0.5660330877786267, -0.38786499061161595, -0.9851617853645876, -0.6767053779597042, 0.2539108331545893, 0.9510825952363544, 0.7738334053999244, -0.11487464864560613, -0.8979674804979512, -0.8554731519696874, -0.026460752737064126};
	int counter;
	
	final double trunc( double v, double low, double high )
	{
		return (v<low ? low: (v>high ? high : v));
	}
	

}
