package br.com.saab.financeiro.controller;

import br.com.saab.financeiro.model.Banco;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.SystemException;

/**
 * Controlador para a tela de Bancos.
 * 
 * @author Felipe
 * @since 18/12/2011
 */
@Named // Anotação para o CDI
@SessionScoped // Escopo da classe, neste caso é por sessão
//@Stateful // Define que este bean é um EJB. Precisa ser para o contaier JEE controlar as transações sozinho
@PersistenceContext(name = "persistence/LogicalName", unitName = "bd_financeiro")
@TransactionManagement(TransactionManagementType.CONTAINER)
public class BancoController implements Serializable {

    @Resource
    private javax.transaction.UserTransaction utx;
    
    private Banco banco;

    public BancoController() {
        banco = new Banco();
    }

    /**
     * Persiste o banco.
     * 
     * @return visão.
     */
    public String salvar() {

        try {
            utx.begin();
            persist(banco);
            //teste();
            utx.commit();
        } catch (Exception e) {
            banco = new Banco();
            
            try {
                utx.rollback();
            } catch (Exception e2) {
                Logger.getLogger(getClass().getName()).log(Level.SEVERE, "exception caught", e);
                throw new RuntimeException(e);
            }
        }

        return "/index.xhtml";
    }

    private void teste() {
        throw new RuntimeException("tem que dar rollback na transação pq eh transacional");
    }

    public Banco getBanco() {
        return banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }
    
    protected void persist(Object object) {
        try {
            Context ctx = (Context) new InitialContext().lookup("java:comp/env");
            EntityManager em = (EntityManager) ctx.lookup("persistence/LogicalName");
            em.persist(object);
        } catch (Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE, "exception caught", e);
            throw new RuntimeException(e);
        }
    }
}
