/*******************************************************************************
 * Portions created by Sebastian Thomschke are copyright (c) 2005-2010 Sebastian
 * Thomschke.
 * 
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sebastian Thomschke - initial implementation.
 *******************************************************************************/
package wrm.saferJava.oval.constraint.exclusion;

import wrm.saferJava.oval.Check;
import wrm.saferJava.oval.Validator;
import wrm.saferJava.oval.configuration.annotation.AbstractAnnotationCheckExclusion;
import wrm.saferJava.oval.constraint.NotNullCheck;
import wrm.saferJava.oval.context.OValContext;
import wrm.saferJava.oval.exception.OValException;

/**
 * @author Sebastian Thomschke
 */
public class NullableExclusion extends AbstractAnnotationCheckExclusion<Nullable>
{
	private static final long serialVersionUID = 1L;

	/**
	 * {@inheritDoc}
	 */
	public boolean isCheckExcluded(final Check check, final Object validatedObject, final Object valueToValidate,
			final OValContext context, final Validator validator) throws OValException
	{
		return check instanceof NotNullCheck;
	}
}
