/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import method.DateCompute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.util.regex.*;

/**
 *
 * @author Administrator
 */
class AddWordDialog extends JDialog implements ActionListener, ItemListener {

    AutoTipComboBox spelling;
    JTextArea meaning;
    JButton ok, cancel;
    String currentLevel;
    String currentDate = DateCompute.getCurrentDate();
    String bookid = null;
    JTable table;
    MyTableModel tableModel;
    String levelInner[] = {"简单", "中等", "高级"};
    JComboBox inner = new JComboBox(levelInner);
    String levelOptionInParent;
    AddWordDialog addDlg = this;
    WindowMoveThread moveThread;
    boolean live = true;

    AddWordDialog(MainFrame owner, JTable table, MyTableModel tableModel, String bookid, String levelOptionInParent) {
        setTitle("添加单词");
        this.table = table;
        this.tableModel = tableModel;
        this.bookid = bookid;
        this.levelOptionInParent = levelOptionInParent;

        moveThread = new WindowMoveThread();
        moveThread.start();

        meaning = new JTextArea(8, 6);
        meaning.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        spelling = new AutoTipComboBox(meaning);
        spelling.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        spelling.addItemListener(this);

        JScrollPane scrollpane = new JScrollPane(meaning);
        JLabel l1 = new JLabel("单词：");
        JLabel l2 = new JLabel("解释：");
        JLabel l3 = new JLabel("难度：");
        ok = new JButton("确认");
        ok.setMnemonic('a');
        cancel = new JButton("取消");
        ok.addActionListener(this);
        cancel.addActionListener(this);

        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(10));
        box.add(l1);
        box.add(Box.createVerticalStrut(10));
        box.add(spelling);
        box.add(Box.createVerticalStrut(10));
        box.add(l3);
        box.add(Box.createVerticalStrut(10));
        box.add(inner);
        box.add(l2);
        box.add(Box.createVerticalStrut(10));
        box.add(scrollpane);
        box.add(Box.createVerticalStrut(10));
        Box boxx = Box.createHorizontalBox();
        boxx.add(ok);
        boxx.add(Box.createHorizontalStrut(30));
        boxx.add(cancel);
        box.add(boxx);
        box.add(Box.createVerticalStrut(10));

        Box boxOut = Box.createHorizontalBox();
        boxOut.add(Box.createHorizontalStrut(15));
        boxOut.add(box);
        boxOut.add(Box.createHorizontalStrut(15));

        add(boxOut);

        this.setModal(true);
        this.setSize(300, 300);
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        spelling.getCorner(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.setVisible(true);
    }

    private void addWord() {
        currentLevel = (String) inner.getSelectedItem();
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "insert into word values('" + spelling.getText() + "','" + meaning.getText() + "','" + currentLevel + "','" + currentDate + "','" + bookid + "')";
        boolean success = db.DbSqlUpdate(sql);
        if (success) {
            if (this.levelOptionInParent.equals("全部难度") || this.levelOptionInParent.equals(this.currentLevel)) {
                Vector record = new Vector();
                record.add(spelling.getText());
                record.add(meaning.getText());
                record.add(currentLevel);
                record.add(this.currentDate);
                tableModel.addRow(record);
                table.setRowSelectionInterval(tableModel.getRowCount() - 1, tableModel.getRowCount() - 1);//定位焦点到最后一行（也就是新添加的那一行）
                table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
            }
            try {
                if (newHint(spelling.getText())) {//如果是新单词 那么就加入到vocabulary表中
                    sql = "select count(*) from vocabulary";
                    ResultSet rs = db.DBSqlQuery(sql);
                    int end = 0;
                    try {
                        if (rs.next()) {
                            end = rs.getInt(1) + 1;
                        }
                    } catch (SQLException ex) {
                        Logger.getLogger(AddWordDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    sql = "insert into vocabulary values('" + spelling.getText() + "','" + meaning.getText() + "','" + end + "')";
                    db.DbSqlUpdate(sql);
                }
            } catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            setFocusOnTable(spelling.getText());
            JOptionPane.showConfirmDialog(this, "该单词已经存在!", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
        }
        db.DbClose();
    }

    void setFocusOnTable(String str) {
        for (int i = 0; i < tableModel.getRowCount(); i++) {
            if (str.equals(tableModel.getValueAt(i, 0))) {
                table.setRowSelectionInterval(i, i);
                table.scrollRectToVisible(table.getCellRect(i, 0, true));
                break;
            }
        }
    }

    boolean newHint(String spelling) throws SQLException {
        boolean isNew;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from vocabulary where spelling='" + spelling + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        if (rs.next()) {
            isNew = false;
        } else {
            isNew = true;
        }
        db.DbClose();
        return isNew;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            if (spellingInputJudgement(spelling.getText()) == false) {
                JOptionPane.showConfirmDialog(this, "请在单词区域输入英文单词或词组!", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                spelling.inputField.setText(null);
                spelling.requestFocus();
            } else if (meaningInputJudgement(meaning.getText())) {
                JOptionPane.showConfirmDialog(this, "请在解释区域输入内容!", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                meaning.setText(null);
                meaning.requestFocus();
            } else {
                addWord();
                live = false;
                dispose();
            }
        } else if (e.getSource() == cancel) {
            dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {//给AutoTipComboBox添加此消息是为了通过鼠标在下来列表中选择时 解释文本能同步变化
        String word = (String) spelling.getSelectedItem();
        String translation = getMeaning(word);
        meaning.setText(translation);

    }

    String getMeaning(String spelling) {//该函数与AutoTipComboBox中的一样 所以说要封装下数据库操作
        String translation = "";
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select meaning from vocabulary where spelling='" + spelling + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                translation += rs.getString(1);
                translation += " ";
            }
        } catch (SQLException ex) {
            Logger.getLogger(AddWordDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        if (translation.equals("")) {
            return null;//如果没有查到任何一条记录 那么就应清空meaning的JTextField 因此这里返回null
        } else {
            return translation;
        }
    }

    boolean spellingInputJudgement(String spelling) {
        /*  Pattern p = Pattern.compile("[a-z[A-Z]]++");//由英文字母组成 或者[a-zA-Z]++        
        Matcher m = p.matcher(spelling);
        boolean b = m.matches();
        return b;*/
        //应该由英文字母和空格组成 因为应该可以输入短语
        Pattern pp = Pattern.compile("[a-zA-Z\\s]++");//由英文字母和空格组成
        Matcher mm = pp.matcher(spelling);
        boolean bb = mm.matches();
        Pattern p = Pattern.compile("\\s*+");//空白符出现一次或多次
        Matcher m = p.matcher(spelling);
        boolean b = m.matches();
        if (bb && !b) {
            return true;
        } else {
            return false;
        }
    }

    boolean meaningInputJudgement(String meaning) {
        Pattern p = Pattern.compile("\\s*+");//空白符出现一次或多次
        Matcher m = p.matcher(meaning);
        boolean b = m.matches();
        return b;
    }

    private class WindowMoveThread extends Thread {

        int x = addDlg.getX();
        int y = addDlg.getY();

        @Override
        public void run() {
            while (live = true) {
                try {
                    Thread.sleep(500);
                } catch (InterruptedException ex) {
                    Logger.getLogger(AddWordDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (x != addDlg.getX() || y != addDlg.getY()) {
                    spelling.getCorner(addDlg.getX(), addDlg.getY(), addDlg.getWidth(), addDlg.getHeight());
                    x = addDlg.getX();
                    y = addDlg.getY();
                }
            }
        }
    }
}
