/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.plaf.basic.BasicComboPopup;

/**
 *
 * @author Administrator
 */
public class AutoTipComboBox extends JComboBox {

    JTextField inputField;
    private ArrayList<String> items = new ArrayList<String>();
    JTextArea meaning;
    int xPos = 0;
    int yPos = 0;
    int width = 0;
    int height = 0;

    public AutoTipComboBox(JTextArea meaning) {//传入此参数的目的是在键盘事件中修改解释文本       
        this.meaning = meaning;
        initItem();//将所有单词记录到item中  每次打开add窗口都会创建AutoTipComboBox的对象 都会执行initItem() 因此记录的结果始终是最新的
        setSelectedIndex(-1);
        setEditable(true);
        inputField = (JTextField) getEditor().getEditorComponent();//给这个JComboBox配上JTextField
        inputField.addKeyListener(new java.awt.event.KeyAdapter() {

            @Override
            public void keyReleased(java.awt.event.KeyEvent e) {
                processEvent(e);
            }
        });
        /**监听文本域的内容变化 如下方法
         * 使用键盘事件
         * TextField用TextListener
         * JTextField用DocumentListener  inputField.getDocument().addDocumentListener(this);
         *
         * 这里选择使用监听键盘事件 有个问题：从下拉列表中选择一项后 文本域发生变化 但是由于没有按键盘 因此meaning的JTextArea里并不显示
         * 单词的解释 需要触发键盘事件才可以 也就是说 用键盘的上下键从列表中选择 解释文本就会同步变化 如果用鼠标选择就不会同步变化
         * 通过在AddWordDialog中给AutoTipComboBox添加消息解决了这一问题
         */
    }

    public void processEvent(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ENTER) {
            hidePopup();
        } else if (e.getKeyCode() != KeyEvent.VK_DOWN && e.getKeyCode() != KeyEvent.VK_UP && e.getKeyCode() != KeyEvent.VK_RIGHT && e.getKeyCode() != KeyEvent.VK_LEFT && e.getKeyCode() != KeyEvent.VK_ESCAPE) {
            // 输入应不为空
            if (!inputField.getText().equals("")) {
                String inputText = inputField.getText();
                List<String> list = new ArrayList<String>();
                // 从客户端已有的数据中查找以当前输入的字符串为前缀的作为备选项
                for (int i = 0; i < items.size(); i++) {
                    if (items.get(i).startsWith(inputText)) {//从第一个字符开始匹配字符串 如果想更高效 可改为KMP
                        list.add(items.get(i));
                    }
                }
                removeAllItems();           // 去掉下拉框中已经存在的项
                // 显示/隐藏下拉框提示
                if (list.size() != 0) {
                    for (int i = 0; i < list.size(); i++) {
                        addItem(list.get(i));       // 加入匹配项
                    }
                    hidePopup();
                    showPopup();
                } else {
                    hidePopup();
                }
                inputField.setText(inputText);//如果不加这句 敲入一个字符后会根据列表中选出的值在其后自动填充字符
                String translation = getMeaning(inputField.getText());
                meaning.setText(translation);
            } else {
                hidePopup();
                meaning.setText("");//如果什么都没有输入 那就不用查询了
            }
        }
    }

    void initItem() {
        //SQL语句中有distinct 则应该用connection.createStatement()
        DbOperation db = new DbOperation();
        db.DbConnect();
        db.setStmt();//更改DbConnect()中对stmt的设置
        String sql = "select distinct spelling from vocabulary";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                items.add(rs.getString(1));
            }
        } catch (SQLException ex) {
            Logger.getLogger(AutoTipComboBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    public String getText() {//用于add窗口中spelling.getText()
        return inputField.getText();
    }

    String getMeaning(String spelling) {
        String translation = "";
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select meaning from vocabulary where spelling='" + spelling + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                //可能同一个单词在不同的生词本中出现 这里要把它在各个生词本中的解释都显示出来
                translation += rs.getString(1);
                translation += " ";
            }
        } catch (SQLException ex) {
            Logger.getLogger(AutoTipComboBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        if (translation.equals("")) {
            return null;//如果没有查到任何一条记录 那么就应清空meaning的JTextField 因此这里返回null
        } else {
            return translation;
        }
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        // Pop *UP*
        BasicComboPopup popup = (BasicComboPopup) getUI().getAccessibleChild(this, 0);
        /* int h = popup.getHeight();
        if (h == 0) {
        h = popup.getPreferredSize().height;
        }*/
        if (xPos + yPos + width + height != 0) {//如果所在窗口已经将自己的位置信息告诉给本控件
            popup.setLocation(xPos, yPos + height);//将下拉列表接在窗口的底部
            super.firePopupMenuWillBecomeVisible();
        }
    }

    void getCorner(int x, int y, int w, int h) {//获得所在窗口的左上角坐标和窗口大小
        this.xPos = x;
        this.yPos = y;
        this.width = w;
        this.height = h;
    }
}
