/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import java.awt.Font;
import java.awt.RenderingHints;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.Rotation;

/**
 *
 * @author Administrator
 */
public class LevelChart {

    public static void createPieChart(double easy, double medium, double hard) {
        //通过工程创建3D饼图
        JFreeChart pieChart = ChartFactory.createPieChart3D("level chart",
                createDataset(easy, medium, hard), true, true, false);
        pieChart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING,
                RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        //得到3D饼图的plot对象
        PiePlot3D piePlot = (PiePlot3D) pieChart.getPlot();
        //设置旋转角度
        piePlot.setStartAngle(290);
        //设置旋转方向
        piePlot.setDirection(Rotation.CLOCKWISE);
        //设置透明度
        piePlot.setForegroundAlpha(0.5f);
        piePlot.setLabelFont((new Font("宋体", Font.PLAIN, 12)));

        ChartFrame frame = new ChartFrame("单词难度分布", pieChart);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);

    }

    public static DefaultPieDataset createDataset(double easy, double medium, double hard) {
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        pieDataset.setValue("easy", easy);
        pieDataset.setValue("medium", medium);
        pieDataset.setValue("hard", hard);
        return pieDataset;
    }

    public static void main(String[] args) {
        createPieChart(7, 8, 9);
    }
}

