/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import javax.swing.border.*;
import java.io.*;
import java.util.regex.*;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 *
 * @author Administrator
 */
class ManageDialog extends JDialog implements ActionListener {

    JList bookList;
    DefaultListModel listmode = new DefaultListModel();
    String bookName[];
    JButton open, create, delete, moveIn, moveOut, close;   
    JLabel label;    
    MainFrame dup;

    ManageDialog(MainFrame owner) {
        setTitle("生词本管理");       
        this.dup = owner;//这里用到了父窗口
        //不同于edit add 这里的对父窗口的修改时大范围的修改 因为修改的是浏览中center部分的整个table区域 而且要调用父窗口中已有的方法
        ArrayList<String> array = new ArrayList<String>();
        getBookList(array);
        bookName = new String[array.size()];
        for (int i = 0; i < array.size(); i++) {
            bookName[i] = array.get(i);
            listmode.addElement(bookName[i]);
        }
        bookList = new JList(listmode);
        bookList.setSelectedValue(dup.currentBookId, true);
        bookList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);//设置成单行选择模式 简化了delete过程
        bookList.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
        updateListModel();

        label = new JLabel("您当前拥有" + Integer.toString(listmode.getSize()) + "个生词本");
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new BorderLayout());
        pCenter.add(label, BorderLayout.NORTH);
        pCenter.add(new JScrollPane(bookList), BorderLayout.CENTER);

        this.setLayout(new BorderLayout());
        this.add(pCenter, BorderLayout.CENTER);
        JPanel pEast = new JPanel();
        open = new JButton("打开");
        open.addActionListener(this);
        create = new JButton("新建");
        create.addActionListener(this);
        delete = new JButton("删除");
        delete.addActionListener(this);
        moveIn = new JButton("导入...");
        moveIn.addActionListener(this);
        moveOut = new JButton("导出...");
        moveOut.addActionListener(this);
        close = new JButton("关闭");
        close.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(open);
        box.add(Box.createVerticalStrut(10));
        box.add(create);
        box.add(Box.createVerticalStrut(10));
        box.add(delete);
        box.add(Box.createVerticalStrut(30));
        box.add(moveIn);
        box.add(Box.createVerticalStrut(10));
        box.add(moveOut);
        box.add(Box.createVerticalStrut(30));
        box.add(close);
        pEast.add(box);

        this.add(pEast, BorderLayout.EAST);

        this.setModal(true);
        this.setSize(300, 300);
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);

    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == close) {
            this.dispose(); //this.setVisible(false);
        } else if (e.getSource() == open) {
            String bookid = null;
            bookid = (String) bookList.getSelectedValue();
            if (bookid != null) {
                //System.out.println(bookid);
                if (bookid.contains("(当前生词本)")) {
                    /**如果bookid为null 也就是说没有选中任何一项却单击了打开按钮
                     * (这种情况发生在：删除了某个生词本导致JList失去焦点 其实判断selectIndex是否为-1也可达到相应效果)
                     * 那么bookid.contains()就会发生异常
                     * 所以该句应该放在判断是否为空之后
                     */
                    int end = bookid.indexOf('(');
                    bookid = bookid.substring(0, end);
                }
                updateListModel();
                updateBookDb(bookid);
                dup.currentBookId = bookid;
                int temp[] = {0};
                dup.justSelected = temp;//切换到新的生词本 焦点设定在第一行
                //dup.updateTable((String) dup.levelSelect.getSelectedItem(), (String) dup.timeSelect.getSelectedItem());
                //dup.setBottemWordCount();
                //dup.currentBook.setText("当前是" + dup.currentBookId);
                dup.rootpane.removeAll();
                dup.panelScan();
                dup.validate();
            }
            /**
             * 修改的是浏览中center部分的整个table区域 也就是Main.java中顶部两个JComboBox的方法
             * 即先updateTable() 再setBottemWordCount()
             * 但是这里会有不同 因为这里更换了生词本 所以要再底部更新生词本名的JLabel 所以增添了最后一句
             * 注意对父窗口中currentBookId和justSelected的更新 因为这两个变量在updateTable()和setBottemWordCount()中都没有改变
             * 所以要单独写出来
             */
        } else if (e.getSource() == create) {
            String bookid = null;//初始化为null 这很重要
            bookid = JOptionPane.showInputDialog(this, "新生词本的名字是：", "添加新生词本", JOptionPane.QUESTION_MESSAGE);
            //如果单击取消 则bookid为null 于是不会有任何提示
            //如果单击确定却没有任何输入 则bookid为"" 也就是空串 它的长度为0 因此会执行else分支输出"名字为空,添加失败"
            //如果单击确定且有输入 则会执行if分支 如果因为名字重复而添加失败 会在addNewBook()中给出相关信息
            if (bookid != null && bookid.length() > 0 && bookid.length() <= 10 && bookidInputJudgement(bookid) == false) {
                boolean ok = addNewBook(bookid, "0");
                if (ok) {//添加成功 说明名字没有重复 则更新JList 如果失败 则相关提示信息已在addNewBook()中给出
                    listmode.addElement(bookid);
                    label.setText("您当前拥有" + Integer.toString(listmode.getSize()) + "个生词本");
                }
            } else if (bookid != null && (bookid.length() == 0 || bookidInputJudgement(bookid))) {
                JOptionPane.showConfirmDialog(this, "名字不能为空", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            } else if (bookid != null && bookid.length() > 10) {
                JOptionPane.showConfirmDialog(this, "名字的长度不能超过10个字符", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
            }
        } else if (e.getSource() == delete) {
            int selectIndex = bookList.getSelectedIndex();
            if (selectIndex != -1) {//如果选择了某一项而且该项不是当前生词本才进行删除操作
                String bookid = (String) bookList.getSelectedValue();
                if (bookid.contains("(当前生词本)")) {
                    int end = bookid.indexOf('(');
                    bookid = bookid.substring(0, end);
                }
                String type = getBookType(bookid);
                if (type.equals("0")) {
                    int choice = JOptionPane.showConfirmDialog(this, "确定要删除这该生词本吗？", "注意", JOptionPane.OK_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE);
                    if (choice == JOptionPane.OK_OPTION) {
                        listmode.remove(selectIndex);
                        label.setText("您当前拥有" + Integer.toString(listmode.getSize()) + "个生词本");
                        deleteOldBook(bookid);//这里仅仅在book表中删除该生词本 word表中相应的单词由数据库自动完成删除
                    }
                } else {
                    JOptionPane.showConfirmDialog(this, "不能删除当前生词本", "删除失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                }
            }
        } else if (e.getSource() == moveOut) {
            int selectIndex = bookList.getSelectedIndex();
            if (selectIndex != -1) {
                ArrayList data = new ArrayList();
                String bookid = (String) bookList.getSelectedValue();
                if (bookid.contains("(当前生词本)")) {
                    int end = bookid.indexOf('(');
                    bookid = bookid.substring(0, end);
                }
                getCurrentBookFullInfo(data, bookid);
                writeObjectToFile(data, bookid);
                JOptionPane.showConfirmDialog(this, "导出成功", "提示", JOptionPane.CLOSED_OPTION, JOptionPane.INFORMATION_MESSAGE);
            }

        } else if (e.getSource() == moveIn) {
            String fileName = null, filePath = null;
            JFileChooser chooser = new JFileChooser();
            File dir = new File("data");
            chooser.setCurrentDirectory(dir);//设置当前目录
            chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);//只能选择文件
            chooser.setDialogType(JFileChooser.OPEN_DIALOG);//对话框模式
            chooser.setDialogTitle("请选择要导入的文件");//标题
            chooser.setMultiSelectionEnabled(false);//只能单选
            FileNameExtensionFilter filter = new FileNameExtensionFilter("生词本文件", "dat");
            chooser.setFileFilter(filter);//过滤

            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                fileName = chooser.getSelectedFile().getName();
                filePath = chooser.getSelectedFile().getAbsolutePath();
            }

            if (filePath != null && fileName != null) {
                int pos = fileName.indexOf('.');
                String bookid;
                if (pos != -1) {
                    bookid = fileName.substring(0, pos);
                } else {//导入的文件如果没有扩展名 当然肯定是非法导入文件
                    bookid = fileName;
                }
                if (isDbContain(bookid)) {
                    JOptionPane.showConfirmDialog(this, "生词本" + bookid + "已存在，请修改文件名后重新导入", "导入失败", JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE);
                } else {
                    ArrayList data = null;
                    data = readObjectFromFile(filePath);
                    if (data != null) {//如果成功获得了正确格式的文件的内容 在对数据库和界面进行修改
                        addNewBook(bookid, "0");//先修改book表 再修改word表 这两个表已经建立了关系 所以变化要一致 如果在word表中添加的记录的bookid属性值在book中找不到 则会发生错误
                        for (int i = 0; i < data.size(); i++) {
                            ArrayList<String> record = (ArrayList<String>) data.get(i);
                            insertRecordToWord(record, bookid);
                        }
                        listmode.addElement(bookid);
                        label.setText("您当前拥有" + Integer.toString(listmode.getSize()) + "个生词本");
                        JOptionPane.showConfirmDialog(this, "生词本" + bookid + "已导入", "导入成功", JOptionPane.CLOSED_OPTION, JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            }
        }
    }

    void getBookList(ArrayList<String> array) {
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from book";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                array.add(rs.getString(1));
            }
        } catch (SQLException ex) {
            Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    void updateBookDb(String bookid) {//更改book中的type字段 指定谁是当前生词本      
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from book";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                if (rs.getString(1).equals(bookid)) {
                    rs.updateString(2, "1");
                } else {
                    rs.updateString(2, "0");
                }
                rs.updateRow();
            }
        } catch (SQLException ex) {
            Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    boolean addNewBook(String name, String type) {//这个和Main.java中的一模一样 用于向表book中添加条目
        boolean ok = true;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "insert into book values('" + name + "','" + type + "')";
        ok = db.DbSqlUpdate(sql);
        if (ok == false) {
            JOptionPane.showConfirmDialog(this, "名字重复或为非法字符", "添加失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        db.DbClose();
        return ok;//发生异常返回false 正常结束返回true
    }

    void deleteOldBook(String bookid) {
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "delete * from book where name='" + bookid + "'";
        db.DbSqlUpdate(sql);
        db.DbClose();
    }

    String getBookType(String bookid) {
        String type = null;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select type from book where name='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                type = rs.getString(1);
            }
        } catch (SQLException ex) {
            Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        return type;
    }

    void updateListModel() {
        int selectIndex = bookList.getSelectedIndex();
        String name;
        for (int i = 0; i < listmode.getSize(); i++) {
            name = (String) listmode.getElementAt(i);
            if (name.contains("(当前生词本)") && i != selectIndex) {
                int deleteStart = name.indexOf('(');
                listmode.setElementAt(name.substring(0, deleteStart), i);
            } else if (name.contains("(当前生词本)") == false && i == selectIndex) {
                listmode.setElementAt(name + "(当前生词本)", i);
            }
        }
    }

    void getCurrentBookFullInfo(ArrayList data, String bookid) {//获得当前生词本的除bookid外所有信息    
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from word where bookid='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            while (rs.next()) {
                ArrayList<String> record = new ArrayList<String>();
                for (int i = 1; i <= 4; i++) {
                    record.add(rs.getString(i));
                }
                data.add(record);
            }
        } catch (SQLException ex) {
            Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    void writeObjectToFile(ArrayList data, String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream("data/" + fileName + ".dat");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(data);
            oos.close();
            fos.close();
        } catch (IOException e) {
            System.out.println("" + e);
        }
    }

    ArrayList readObjectFromFile(String fileName) {
        ArrayList data = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                data = (ArrayList) ois.readObject();
                ois.close();
                fis.close();

            } catch (ClassNotFoundException ex) {
                Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        } catch (IOException e) {
            JOptionPane.showConfirmDialog(this, "导入的文件类型非法", "导入失败", JOptionPane.CLOSED_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        return data;
    }

    boolean isDbContain(String bookid) {
        boolean isDbContain = false;
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from book where name='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                isDbContain = true;
            }
        } catch (SQLException ex) {
            Logger.getLogger(ManageDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
        return isDbContain;
    }

    void insertRecordToWord(ArrayList<String> record, String bookid) {
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "insert into word values('" + record.get(0) + "','" + record.get(1) + "','" + record.get(2) + "','" + record.get(3) + "','" + bookid + "')";
        db.DbSqlUpdate(sql);
        db.DbClose();
    }

    boolean bookidInputJudgement(String bookid) {
        Pattern p = Pattern.compile("\\s*+");//空白符出现一次或多次
        Matcher m = p.matcher(bookid);
        boolean b = m.matches();
        return b;
    }
}
