
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package vocabulary;

import method.DbOperation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;

/**
 *
 * @author Administrator
 */
class ReportDialog extends JDialog implements ActionListener {

    JButton submit = new JButton("交卷查看");
    JButton back = new JButton("继续答题");
    TestData testdata;
    ProgressBarThread progressBar;
    ModifyThread modiThread;
    WaitDialog dlg;
    int countInrun = 0;
    int total;
    ModifyLevel mfy;

    ReportDialog(TestData testdata, int rightNum, int wrongNum, int skipNum, int type) {
        setTitle("报告");
        this.testdata = testdata;
        setLayout(new BorderLayout());
        Box boxup = Box.createHorizontalBox();
        boxup.add(Box.createHorizontalStrut(65));
        boxup.add(new JLabel("本次测试共" + Integer.toString(rightNum + wrongNum + skipNum) + "道试题"));
        add(boxup, BorderLayout.NORTH);

        Box boxmid = Box.createHorizontalBox();
        boxmid.add(Box.createHorizontalStrut(85));

        Box box = Box.createVerticalBox();
        box.add(new JLabel(rightNum + "道题正确"));
        box.add(Box.createVerticalStrut(15));
        box.add(new JLabel(wrongNum + "道题错误"));
        box.add(Box.createVerticalStrut(15));
        box.add(new JLabel(skipNum + "道题未答"));
        box.add(Box.createVerticalStrut(15));

        boxmid.add(box);
        add(boxmid, BorderLayout.CENTER);

        Box boxbottom = Box.createHorizontalBox();
        if (type == 0) {
            boxbottom.add(Box.createHorizontalStrut(25));
            boxbottom.add(submit);
            boxbottom.add(Box.createHorizontalStrut(20));
            boxbottom.add(back);
        } else {
            submit.setText("确定");
            boxbottom.add(submit);
        }
        Box boxunder = Box.createVerticalBox();
        boxunder.add(boxbottom);
        boxunder.add(Box.createVerticalStrut(15));
        add(boxunder, BorderLayout.SOUTH);
        submit.requestFocus();
        submit.addActionListener(this);
        back.addActionListener(this);


        setModal(true);
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        setSize(240, 200);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);//使关闭按钮失效
        setVisible(true);

    }

    /**
     *
     * ArrayList<StriAng> dataHead = new ArrayList<String>();//记录问题
     * ArrayList<String[]> dataBody = new ArrayList<String[]>();//记录答案
     * ArrayList<Integer> rightPos = new ArrayList<Integer>();//记录正确答案的位置
     * ArrayList<Integer> selectPos = new ArrayList<Integer>();//记录所选答案的位置 英译汉和汉译英
     * ArrayList<String> spellingAnswers = new ArrayList<String>();//记录拼写题所填的答案
     * ArrayList<String> result = new ArrayList<String>();//记录该题是否做对
     *
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == submit) {
            testdata.tfr.dispose();//关掉TestFrame          
            dispose();//关掉自己(ReportDialog)
            progressBar = new ProgressBarThread();
            progressBar.start();//开启进度条的线程          
        } else if (e.getSource() == back) {
            dispose();
        }
    }

    private class ProgressBarThread extends Thread {

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable() {

                public void run() {
                    mfy = MofifyFactory.CreateLevelModifyTool(testdata.mfr.bg_type.getSelection().getActionCommand());
                    mfy.setTestData(testdata);
                    dlg = new WaitDialog();
                    dlg.setLocationRelativeTo(null);
                    total = testdata.dataHead.size();
                    dlg.adoptDeterminate(total);
                    modiThread = new ModifyThread();
                    modiThread.start();
                }
            });

            return;
        }
    }

    private class ModifyThread extends Thread {

        @Override
        public void run() {
            for (int i = 0; i < total; i++) {
                String spelling = mfy.getSpelling(i);//只有这个方法不同子类是不同的
                String bookid = mfy.getBookid();
                String level = mfy.getLevel(spelling, bookid);
                mfy.modify(spelling, bookid, level, i);
                countInrun = i;
                SwingUtilities.invokeLater(new Runnable() {//将对象排到事件派发线程的队列中 只有从事件派发线程才能更新组件

                    public void run() {//实例化更新组件的线程
                        dlg.setValue(countInrun);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable() {

                public void run() {
                    dlg.finishDeterminate();
                    ShowResultDialog resultdlg = new ShowResultDialog(testdata);//显示ShowResultDialog
                }
            });
            return;
        }
    }
}

class MofifyFactory {

    public static ModifyLevel CreateLevelModifyTool(String type) {
        if (type.equals("c2e")) {
            return new ModifyCtoE();
        } else if (type.equals("e2c")) {
            return new ModifyEtoC();
        } else {
            return new ModifySpelling();
        }

    }
}

abstract class ModifyLevel {

    TestData testdata;

    ModifyLevel() {
    }

    abstract String getSpelling(int i);

    void setTestData(TestData testdata) {
        this.testdata = testdata;
    }

    void setLevel(String spelling, String bookid, String level) {//采用跟新记录集的方法
        DbOperation db = new DbOperation();
        db.DbConnect();
        String sql = "select * from word where spelling='" + spelling + "' and bookid='" + bookid + "'";
        ResultSet rs = db.DBSqlQuery(sql);
        try {
            if (rs.next()) {
                rs.updateString(3, level);
                rs.updateRow();
            }
        } catch (SQLException ex) {
            Logger.getLogger(TestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        db.DbClose();
    }

    String getLevel(String spelling, String bookid) {
        String level = null;
        DbOperation db = new DbOperation();
        db.DbConnect();
        db.setPreStme("select * from word where spelling=? and bookid=?");
        try {
            db.prestmt.setString(1, spelling);
            db.prestmt.setString(2, bookid);
            ResultSet rs = db.prestmt.executeQuery();
            if (rs.next()) {
                level = rs.getString(3);
            }
        } catch (SQLException ex) {
            Logger.getLogger(ReportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }

        db.DbClose();
        return level;
    }

    String getBookid() {
        return testdata.mfr.currentBookId;
    }

    void modify(String spelling, String bookid, String level, int i) {
        if (testdata.result.get(i).equals("r")) {//如果做对
            if (level != null) {
                if (level.equals("中等")) {
                    level = "简单";
                    setLevel(spelling, bookid, level);
                } else if (level.equals("高级")) {
                    level = "中等";
                    setLevel(spelling, bookid, level);
                }
            }
        } else {//如果做错或者跳过
            if (level != null) {
                if (level.equals("中等")) {
                    level = "高级";
                    setLevel(spelling, bookid, level);
                } else if (level.equals("简单")) {
                    level = "中等";
                    setLevel(spelling, bookid, level);
                }
            }
        }
    }
}

class ModifyEtoC extends ModifyLevel {

    ModifyEtoC() {
    }

    String getSpelling(int i) {
        return testdata.dataHead.get(i);
    }
}

class ModifyCtoE extends ModifyLevel {

    ModifyCtoE() {
    }

    String getSpelling(int i) {
        return testdata.dataBody.get(i)[testdata.rightPos.get(i)];
    }
}

class ModifySpelling extends ModifyLevel {

    ModifySpelling() {
    }

    String getSpelling(int i) {
        return testdata.dataBody.get(i)[0];
    }
}

