/*
 * Teste bem simples, que mostra a criação de um Peer JXTA, envolvendo a criação
 * de objetos NetworkManager e NetworkConfigurator.
 * Obs: O diretório cache padrão é ".jxta"
 */
package testes;

import java.io.File;
import java.io.IOException;
import javax.security.cert.CertificateException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.platform.NetworkManager;

public class Test01_HelloStartStop {

    public static final String Name = "Test01";
    public static final PeerID PID = IDFactory.newPeerID(
            PeerGroupID.worldPeerGroupID,
            Name.getBytes());
    public static final File CacheDir = new File(".jxta");

    public static void main(String[] args) throws IOException, PeerGroupException, CertificateException {
        NetworkManager.RecursiveDelete(new File(".jxta"));

        NetworkManager MyNetworkManager = new NetworkManager(NetworkManager.ConfigMode.EDGE, Name);
        NetworkConfigurator MyNetworkConfigurator = MyNetworkManager.getConfigurator();
        
        MyNetworkConfigurator.setPeerID(PID);
        PeerGroup MyPeerGroup = MyNetworkManager.startNetwork();
        Tools.PopInformationMessage(Name, "Peer Name: " + MyNetworkConfigurator.getName());
        Tools.PopInformationMessage(Name, "Peer Name: " + MyPeerGroup.getPeerName());

        Tools.PopInformationMessage(Name, "Peer ID: " + MyNetworkConfigurator.getPeerID());
        Tools.PopInformationMessage(Name, "Peer ID: " + MyPeerGroup.getPeerID());
        MyNetworkManager.stopNetwork();
        NetworkManager.RecursiveDelete(new File(".jxta"));

        System.exit(0);
    }
}
