/*
 * Classe do PEER EDGE 
 */
package trabalho3sd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.platform.NetworkManager;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocket;
import net.jxta.util.JxtaBiDiPipe;

/*
 * @author Gustavo Luvizotto Cesar - 6783544 - gustavoluvizotto@gmail.com
 * @author Leonardo Lourenço Crespilho - 5124310 - lcrespilho@gmail.com
 * @author Murilo Alencar Alves Júnior - muriloaajruspec@gmail.com
 */
public class Edge implements PipeMsgListener, DiscoveryListener {

    private static String Name;
    private static PeerID localPeerID;
    private static String SeedRDV;
    private static File ConfigurationFile;
    private static JxtaBiDiPipe MyBiDiPipeWithRDV;
    private static PeerGroup NetPeerGroup;
    private String msgFileName;

    public Edge(String FileName) {
        this.msgFileName = FileName;
    }

    public Edge() {
    }

    /* Criando um Socket (Pipe) advertisement para identificar o arquivo que será transferido pela rede
     */
    public PipeAdvertisement getSocketAdvertisement() {
        PipeAdvertisement MyPipeAdvertisement = (PipeAdvertisement) AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        PipeID MyPipeID = IDFactory.newPipeID(PeerGroupID.defaultNetPeerGroupID, Name.getBytes());
        MyPipeAdvertisement.setPipeID(MyPipeID);
        MyPipeAdvertisement.setType(PipeService.UnicastType);
        MyPipeAdvertisement.setName("Advertisement do Socket");
        MyPipeAdvertisement.setDescription(msgFileName);
        return MyPipeAdvertisement;
    }

    /*
     * Nesse discoveryEvent, capturo os advertisements publicados e verifico se possuem o nome "Advertisement do Socket" e a descrição com nome do arquivo que desejo. 
     * Assim, pegamos os Advivertisements provindos da publicação da criação do socket.
     * Esse evento é usado para a TAG "DOWNLOAD". (recebimento de arquivos).
     */
    @Override
    public void discoveryEvent(DiscoveryEvent ev) {
        try {
            DiscoveryResponseMsg res = ev.getResponse();
            Advertisement adv;
            Enumeration<Advertisement> en = res.getAdvertisements();
            if (en != null) {
                while (en.hasMoreElements()) {
                    adv = en.nextElement();
                    System.out.flush();
                    if (adv.getAdvType().equals("jxta:PipeAdvertisement")) {

                        PipeAdvertisement SocketADV = (PipeAdvertisement) adv;

                        if (SocketADV.getName().toString().equals("Advertisement do Socket") && SocketADV.getDescription().toString().equals(msgFileName)) {

                            JxtaSocket MySocket = new JxtaSocket(NetPeerGroup, SocketADV, 2000); //conectou no socket
                            MySocket.setSoTimeout(0);
                            MySocket.setTcpNoDelay(true);

                            // recebendo o arquivo
                            InputStream is = MySocket.getInputStream();
                            int filesize = 102400000; //100MB de tamanho máximo para o arquivo recebido
                            int bytesRead;
                            int current;
                            byte[] mybytearray = new byte[filesize];
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream("/tmp/JXTA/" + msgFileName));
                            bytesRead = is.read(mybytearray, 0, MySocket.getReceiveBufferSize());
                            current = bytesRead;
                            do {
                                bytesRead = is.read(mybytearray, current, MySocket.getReceiveBufferSize());
                                if (bytesRead >= 0) {
                                    current += bytesRead;
                                }
                            } while (bytesRead > -1);
                            bos.write(mybytearray, 0, current);
                            bos.flush();
                            bos.close();    // transferência do arquivo completa
                            System.out.println("Transferência completada. Já pode ler/alterar o arquivo " + msgFileName + ".");
                            System.out.println("Após sua utilização, não esqueça de escolher a opção [4]-Termina Acesso de um arquivo.");
                            System.out.flush();
                            MySocket.close();
                            break;          //sai do while(), pois já achou o Advertisement procurado
                        }
                    }
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Chegou uma mensagem. Devemos então que filtrar o tipo da mensagem e tratar
     * caso-a-caso. Esquema de protocolo de mensagens.
     */
    @Override
    public void pipeMsgEvent(PipeMsgEvent PME) {
        Message ReceivedMessage = PME.getMessage();
        String msgType = ReceivedMessage.getMessageElement("TYPE").toString();  //pode ser publicar ou acessar
        msgFileName = ReceivedMessage.getMessageElement("FILENAME").toString(); //nome do arquivo a ser publicado ou acessado/baixado
        String msgPeerID = ReceivedMessage.getMessageElement("PEERID").toString();
        try {
            switch (msgType) {
                // peer apenas deleta de seu repositório.
                case "DELETAR": {
                    File[] files = new File("/tmp/JXTA").listFiles();
                    for (File file : files) {
                        if (file.getName().equals(msgFileName)) {
                            file.delete();
                            break;
                        }
                    }
                    break;
                }

                case "ACESSOERRO": {    // erro ao acessar o arquivo. Arquivo não existe
                    System.out.println("Erro na operação de ACESSAR. Arquivo não existe ou não está disponível para download.");
                    break;
                }

                // TAG de concessão do pedido para acessar um arquivo em outro peer, ou seja, existe o arquivo requisitado em algum peer. Como o arquivo existe e o socket já está aberto, então inicia-se o download do mesmo    
                case "DOWNLOAD": {
                    if (msgPeerID.equals(localPeerID.toString())) {     // verifico se o arquivo é meu
                        System.out.println("Arquivo disponível localmente");
                        System.out.println("Após sua utilização, não esqueça de escolher a opção [4]-Termina Acesso de um arquivo.");
                    } else {                    // arquivo localizado em outro peer. Criar conexão por socket com o outro peer e enviar o pedido de arquivo.
                        Thread.sleep(3000);     //espera alguns segundos antes de dar o getRemoteAdvertisements(), pra dar tempo do peerB publicar seu advertisement.
                        NetPeerGroup.getDiscoveryService().getRemoteAdvertisements(null, DiscoveryService.ADV, null, null, 200, new Edge(msgFileName));
                    }
                    break;
                }

                case "ABRESOCKET": {
                    JxtaServerSocket MyJXTAServerSocket = new JxtaServerSocket(NetPeerGroup, getSocketAdvertisement(), 20, 5000);
                    NetPeerGroup.getDiscoveryService().publish(getSocketAdvertisement(), 5000, 5000);      // duraçao da publicação desse advertisemente de 5s (suficiente para criar o socket).
                    NetPeerGroup.getDiscoveryService().remotePublish(getSocketAdvertisement(), 5000);      // duraçao da publicação desse advertisemente de 5s (suficiente para criar o socket).

                    Socket MySocket = MyJXTAServerSocket.accept();   // timeout = 5s, previamente definido em new JxtaServerSocket()

                    if (MySocket != null) {     // envia o arquivo
                        MySocket.setSoTimeout(0);
                        MySocket.setTcpNoDelay(true);
                        File file = new File("/tmp/JXTA/" + msgFileName);
                        OutputStream os = MySocket.getOutputStream();
                        byte[] mybytearray = new byte[(int) file.length() + 1];
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        bis.read(mybytearray, 0, mybytearray.length);
                        os.write(mybytearray, 0, mybytearray.length);
                        os.flush();
                        MySocket.close();
                        file.delete();   //após a transferência do arquivo, deleta-o.
                    }
                }
            }
        } catch (InterruptedException | IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            Logger.getLogger("net.jxta").setLevel(Level.SEVERE);
            inicializaAtributos();                              // seta os atributos da classe
            NetworkManager.RecursiveDelete(ConfigurationFile);
            NetworkManager MyNetworkManager = new NetworkManager(NetworkManager.ConfigMode.EDGE, Name, ConfigurationFile.toURI());
            NetworkConfigurator MyNetworkConfigurator = MyNetworkManager.getConfigurator();
            MyNetworkConfigurator.clearRendezvousSeeds();
            MyNetworkConfigurator.addSeedRendezvous(URI.create(SeedRDV));
            MyNetworkConfigurator.setTcpEnabled(true);
            MyNetworkConfigurator.setTcpIncoming(true);
            MyNetworkConfigurator.setTcpOutgoing(true);
            MyNetworkConfigurator.setUseMulticast(false);
            MyNetworkConfigurator.setPeerID(localPeerID);
            NetPeerGroup = MyNetworkManager.startNetwork();
            NetPeerGroup.getRendezVousService().setAutoStart(false);

            MyNetworkManager.waitForRendezvousConnection(5000);  //tenta conectar no RDV por 5s

            /* Criando o BiDiPipe e setando o Listener como o método pipeMsgevent() de um novo objecto dessa classe. */
            MyBiDiPipeWithRDV = new JxtaBiDiPipe(NetPeerGroup, Rendezvous.getPipeAdvertisement(), 5000, new Edge());
            if (MyBiDiPipeWithRDV.isBound()) {

                // interface com o usuario (util para sincronizar os codigos/peers)
                int op;
                String fileName;
                do {
                    System.out.println("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
                    System.out.println("Escolha a opção desejada");
                    System.out.println("[1] Publica todos arquivos locais");
                    System.out.println("[2] Publica um arquivo em específico");
                    System.out.println("[3] Acessa/Baixa um arquivo");
                    System.out.println("[4] Termina Acesso de um arquivo");
                    System.out.println("[5] Deleta um arquivo");
                    System.out.println("[6] Listar metadados");
                    System.out.println("[7] Sair");
                    System.out.println("Opção: ");
                    Scanner read = new Scanner(System.in);
                    op = read.nextInt();
                    read.nextLine();
                    switch (op) {
                        case 1: {
                            publicaArquivosLocais();
                            break;
                        }
                        case 2: {
                            System.out.println("Digite o nome do arquivo: ");
                            fileName = read.nextLine();
                            publicaArquivo(fileName);
                            break;
                        }
                        case 3: {
                            System.out.println("Digite o nome do arquivo: ");
                            fileName = read.nextLine();
                            acessaArquivo(fileName);
                            break;
                        }
                        case 4: {
                            System.out.println("Digite o nome do arquivo: ");
                            fileName = read.nextLine();
                            terminoAcesso(fileName);
                            break;
                        }
                        case 5: {
                            System.out.println("Digite o nome do arquivo: ");
                            fileName = read.nextLine();
                            deletaArquivo(fileName);
                            break;
                        }
                        case 6: {
                            listarMetadados();
                            break;
                        }
                    }
                } while (op != 7);
            }

            // Para deletar os metadados desse Peer após um exit com sucesso. Não trata o caso do processo ter recebido um kill, nem morte súbita.
            File[] FileList = new File("/tmp/JXTA").listFiles();
            for (File file : FileList) {
                deletaMetadado(file);
            }

            Thread.sleep(3000); // necessário pra dar tempo das mensagens serem entregues para o Rendezvous

            MyBiDiPipeWithRDV.close();
            MyNetworkManager.stopNetwork();
        } catch (PeerGroupException | IOException | InterruptedException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.exit(0);
    }

    /*
     * Método que inicializa os atributos dessa classe.
     */
    static void inicializaAtributos() {
        try {
            Name = InetAddress.getLocalHost().getHostName();
            localPeerID = IDFactory.newPeerID(PeerGroupID.defaultNetPeerGroupID, Name.getBytes());
            SeedRDV = "tcp://x-men:" + 9722;
            ConfigurationFile = new File("." + System.getProperty("file.separator") + Name);   // arquivos de configuração da rede   
        } catch (UnknownHostException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Método usado para publicar todos os arquivos locais.
     */
    static void publicaArquivosLocais() {
        File[] FileList = new File("/tmp/JXTA").listFiles();
        for (File file : FileList) {
            publicaArquivo(file);
        }
    }

    /*
     * Método utilizado para publicar um arquivo específico (file)
     */
    static void publicaArquivo(File file) {
        try {
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "PUBLICAR", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", file.getName(), null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", String.valueOf(file.lastModified()), null));
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Método utilizado para publicar um arquivo específico a partir de seu nome.
     */
    static void publicaArquivo(String fileName) {
        try {
            File file = new File("/tmp/JXTA/" + fileName);
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "PUBLICAR", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", file.getName(), null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", String.valueOf(file.lastModified()), null));
            if (file.lastModified() != 0) {
                MyBiDiPipeWithRDV.sendMessage(MyMessage);
            }
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /* Deleta o arquivo. manda uma mensagem para o RDV para que isso seja feito. 
     * Se for local, o RDV vai devolver uma msg, 
     * se não ele envia a msg para o peer correspondente que precisa deletar o arquivo
     */
    static void deletaArquivo(String fileName) {
        try {
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "DELETAR", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", fileName, null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", "123", null)); //lixo
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /* Deleta o arquivo. Manda uma mensagem para o RDV para que isso seja feito. 
     * Se for local, o RDV vai devolver uma msg, 
     * se não ele envia a msg para o peer correspondente que precisa deletar o arquivo.
     */
    static void deletaMetadado(File file) {
        try {
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "DELETAMETADADO", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", file.getName(), null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", "123", null)); //lixo
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Método utilizado para fazer um acesso em um arquivo (baixar o arquivo para fazer eventuais modificações).
     */
    static void acessaArquivo(String fileName) {
        try {
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "ACESSAR", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", fileName, null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", "123", null)); //lixo
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Método utilizado para listar os metadados contidos na lista de metadados que o RDV possui.
     */
    static void listarMetadados() {
        try {
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "LISTARMETADADOS", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", "lixo", null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", "123", null)); //lixo
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Método utilizado para identificar que um peer terminou de fazer um acesso a um arquivo. 
     * Ou seja, passou de EXECUTANDO para DISPONIVEL o estado do arquivo
     */
    static void terminoAcesso(String fileName) {
        try {
            File file = new File("/tmp/JXTA/" + fileName);
            long lastModified = file.lastModified();
            Message MyMessage = new Message();
            MyMessage.addMessageElement(new StringMessageElement("TYPE", "TERMINOACESSO", null));
            MyMessage.addMessageElement(new StringMessageElement("FILENAME", fileName, null));
            MyMessage.addMessageElement(new StringMessageElement("LASTMODIFIED", String.valueOf(lastModified), null));
            MyBiDiPipeWithRDV.sendMessage(MyMessage);
        } catch (IOException ex) {
            Logger.getLogger(Edge.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
