/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.seclust;

import java.util.ArrayList;
import java.util.Map;
import javax.faces.context.FacesContext;

/**
 *
 * @author baga
 */
public class ClusterSystem {

    private String query;
    private LabelClass[] labelClass;
    private ArrayList resultList;
    private String indexVal;
    private int index = 0;
    private String[] contents;
    private String[] urls;
    private ArrayList stopWords;
    private boolean isPrepocessing = true;
    private boolean isFullDoc = false;
    private boolean isSnippet = true;
    private String tableName = "t_clust";

    public void setPrepocessing(boolean value) {
        isPrepocessing = value;
    }

    public boolean getPrepocessing() {
        return isPrepocessing;
    }

    public void setSnippet(boolean value) {
        isSnippet = value;
    }

    public boolean getSnippet() {
        return isSnippet;
    }

    public void setFullDoc(boolean value) {
        isFullDoc = value;
    }

    public boolean getFullDoc() {
        return isFullDoc;
    }

    public void setClusterQuery(String clusterQuery) {
        query = clusterQuery;
    }

    public String getClusterQuery() {
        return query;
    }

    public void setIndexVal(String indexVal) {
        this.indexVal = indexVal;
    }

    public String getIndexVal() {
        return indexVal;
    }

    public String clusterQuality() {
        if (!query.isEmpty()) {
            if (isFullDoc) {
                tableName = "t_clust_full";
            } else {
                tableName = "t_clust";
            }
            ClusteringQuality cq = new ClusteringQuality(query, tableName, isPrepocessing);
            labelClass = cq.getQuality();
            resultList = cq.getResultAl();
            urls = cq.getUrls();
            contents = cq.getContents();
            stopWords = cq.getStopWords();
        }
        return "showresult";
    }

    public String clusterLink() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String) requestMap.get("indexVal");
        index = Integer.parseInt(value);
        return "clusterlink";
    }

    public LinkClass[] getResultLinks() {
        ArrayList al = (ArrayList) resultList.get(index);
        ArrayList<LinkClass> newList = new ArrayList<LinkClass>();
        for (int i = 0; i < al.size(); i++) {
            Integer val = (Integer) al.get(i);
            val -= 1;
            newList.add(new LinkClass(contents[val], urls[val]));
        }

        return (LinkClass[]) newList.toArray(new LinkClass[newList.size()]);
    }

    public LabelClass[] getLabels() {
        for (LabelClass ls : labelClass) {
//            System.out.println(ls.getLabel());
        }
        return labelClass;
    }
}
