/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.seclust;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/**
 *
 * @author Ninoy Harun
 */
public class CosSim {

    private File inpFile;
    private boolean exist;
    private Double[][] matrixResult;

    public CosSim(int k) {
        inpFile = new File("VDS"+ k +".txt");
        exist = inpFile.exists();
        matrixResult = builtMatrix(inpFile);
    }

    public CosSim(int k, String query) {
        inpFile = new File("VDS_" + query +  "_" + k + ".txt");
        exist = inpFile.exists();
        matrixResult = builtMatrix(inpFile);
    }

    public CosSim(int k, String query, String table) {
        inpFile = new File("VDS_" + query + "_" +  table + "_" + k + ".txt");
        exist = inpFile.exists();
        matrixResult = builtMatrix(inpFile);
    }

    private Double[][] builtMatrix(File matlabResultFile) {
        Double[][] tempMatrix = null;
        String s = null;
        String[] tempArr;
        int temp, len, colLen = 0, rowLen = 0, countCol, countRow;
        ArrayList arL = new ArrayList();
        String val1, val2;
        try {
            BufferedReader in = new BufferedReader(new FileReader(inpFile));
            while ((s = in.readLine()) != null) {
                colLen = 0;
                tempArr = s.trim().split(" ");
                len = tempArr.length;
                for (int i = 0; i < len; i++) {
                    if (!tempArr[i].equals("")) {
                        arL.add(Double.parseDouble(tempArr[i]));
                        colLen++;
                    }
                }
                rowLen++;
            }

//            System.out.println("row len " + rowLen + " column len " + colLen);

            tempMatrix = new Double[rowLen][colLen];
            Iterator iterArL = arL.iterator();
            countCol = 0;
            countRow = 0;
            while (iterArL.hasNext()) {
                if (countCol >= colLen) {
                    countRow++;
                    countCol = 0;
                } else {
                    tempMatrix[countRow][countCol] = (Double) iterArL.next();
                    countCol++;
                }
            }
        } catch (IOException ie) {
            ie.printStackTrace();
        }
        return tempMatrix;
    }

    public Double[][] getMatrixResult() {
        
        return matrixResult;
    }

    public double[] allDistance() {
        int matLen = matrixResult.length;
        int distance = (matLen * (matLen - 1)) / 2;
        int count = 0;
        double[] matDistance = new double[distance];
        for (int i = 0; i < matLen; i++) {
            for (int j = i + 1; j < matLen; j++) {
                matDistance[count] = getCosim(matrixResult[i], matrixResult[j]);
                count++;
            }
            
        }
        return matDistance;
    }

    private double getCosim(Double[] matA, Double[] matB) {
        double pembA, pembB, terbilang, pembC, pembD, pembE;
        pembC = pembD = 0.0;
        pembA = pembB = 0.0;
        terbilang = 1.0;
        for (int i = 0; i < matA.length; i++) {

//            if(matA[i] < 0) {
//                matA[i] *= -1;
//            }
//
//            if(matB[i] < 0) {
//                matB[i] *= -1;
//            }
            pembA += matA[i] * matB[i];
            pembC += Math.pow(matA[i], 2);
            pembD += Math.pow(matB[i], 2);
        }
        pembE = pembC * pembD;
        terbilang = Math.sqrt(pembC * pembD);
        return (pembA / terbilang);
    }
    
    public static void main(String[] args) {
        CosSim cosSim = new CosSim(4, "life", "t_clust");
        Double[][] matrix = cosSim.getMatrixResult();
        double[] matDistance = null;
        for(int i=0; i<matrix.length; i++) {
            for(int j=0; j<matrix[i].length; j++) {
                System.out.print(matrix[i][j] + " ");
            }
            System.out.println();
        }

        System.out.println("\n---------------------------------------------------\n");
        matDistance = cosSim.allDistance();
        for(int i=0; i<matDistance.length; i++) {
            System.out.println(matDistance[i] + " ");
        }
    }
}
