/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.seclust;

import Annas.Graph.Arc;
import Annas.Graph.Drawing.DrawableGraph;
import Annas.Graph.Graph;
import Annas.Graph.Node;
import Annas.Graph.Util.Prim;
import java.io.*;
import java.util.ArrayList;
import javax.swing.JFrame;

/**
 *
 * @author baga
 */
public class TestShow {

    private void getDirList(File pathName) {
        File[] dir = pathName.listFiles();

        for (int i = 0; i < dir.length; i++) {
            if (dir[i].isDirectory()) {
                System.out.println(dir[i].getAbsolutePath());
                getDirList(dir[i]);
            } else {
                System.out.println(getFile(dir[i]));
            }
        }
    }

    private String getFile(File path) {
        return path.getAbsolutePath();
    }

    public static void main(String[] argv) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {

            public void run() {

                Node node1 = new Node("node1");
                Node node2 = new Node("node2");
                Node node3 = new Node("node3");
                Node node4 = new Node("node4");

                Graph theGraph = new Graph();
                theGraph.addNode(node1);
                theGraph.addNode(node2);
                theGraph.addNode(node3);
                theGraph.addNode(node4);

                theGraph.addArc(node1, node2, 3);
                theGraph.addArc(node1, node3, 5);
                theGraph.addArc(node1, node4, 7);
                theGraph.addArc(node2, node3, 6);
                theGraph.addArc(node2, node4, 9);
                theGraph.addArc(node3, node4, 10);


                Prim pr = new Prim(theGraph);
                Graph res = pr.run();

                ArrayList<Node> arNode = res.getNodeMap();
                ArrayList<Arc> arArc = null;
                Arc maxArc = null;
                double maxWeight = 0.0;

                for (int i = 0; i < arNode.size(); i++) {
                    System.out.println(arNode.get(i).getName());
                    arArc = arNode.get(i).getAdjacent();
                    for (int j = 0; j < arArc.size(); j++) {
                        System.out.println("\t" + arArc.get(j).toString());
                    }
                }

                for (int i = 0; i < arNode.size(); i++) {
                    arArc = arNode.get(i).getAdjacent();
                    for (int j = 0; j < arArc.size(); j++) {
                        if (arArc.get(j).getWeight() > maxWeight) {
                            System.out.println("Arc max " + arArc.get(j).toString());
                            maxWeight = arArc.get(j).getWeight();
                            maxArc = arArc.get(j);
                        }
                    }
                }

                for (int i = 0; i < arNode.size(); i++) {
                    arArc = arNode.get(i).getAdjacent();
                    for (int j = 0; j < arArc.size(); j++) {
                        if (arArc.get(j).equals(maxArc)) {
                            System.out.println("remove arc " + arArc.get(j).toString());
                            arNode.get(i).removeArc(maxArc);
                        }
                    }
                }

                for (int i = 0; i < arNode.size(); i++) {
                    System.out.println(arNode.get(i).getName());
                    arArc = arNode.get(i).getAdjacent();
                    for (int j = 0; j < arArc.size(); j++) {
                        System.out.println("\t" + arArc.get(j).toString());
                    }
                }

                DrawableGraph dg = new DrawableGraph(res);

                dg.doDraw();

                JFrame.setDefaultLookAndFeelDecorated(true);

                //Create and set up the window.
                JFrame frame = new JFrame("HelloWorldSwing");
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

                //Add the ubiquitous "Hello World" label.
//                JLabel label = new JLabel("Hello World");
                frame.getContentPane().add(dg.getImgPanel());

                //Display the window.
                frame.pack();
                frame.setVisible(true);

            }
        });


//       ArrayList alNodeMap = theGraph.getNodeMap();
//       Iterator iterNodeMap = alNodeMap.iterator();
//       while(iterNodeMap.hasNext()) {
//           Node theNode = (Node) iterNodeMap.next();
//           System.out.println(theNode);
//           ArrayList alArc = theGraph.getArcs(theNode);
//           Iterator iterArc = alArc.iterator();
//           while(iterArc.hasNext()) {
//               Arc theArc = (Arc) iterArc.next();
//               System.out.println("\t" + theArc);
//           }
//       }
//
//       Node erNode = theGraph.getNode(node1.getName());
//       erNode.removeArc(node2.getName());
//       System.out.println("-------------------------------------------------");
//       ArrayList alNewNodeMap = theGraph.getNodeMap();
//       Iterator iterNewNodeMap = alNewNodeMap.iterator();
//       while(iterNewNodeMap.hasNext()) {
//           Node theNewNode = (Node) iterNewNodeMap.next();
//           System.out.println(theNewNode);
//           ArrayList alNewArc = theGraph.getArcs(theNewNode);
//           Iterator iterNewArc = alNewArc.iterator();
//           while(iterNewArc.hasNext()) {
//               Arc theArc = (Arc) iterNewArc.next();
//               System.out.println("\t" + theArc);
//           }
//       }
    }
}
