/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons;

import java.util.Set;

import jens.bothur.occt.domainobjects.GroupOfRateableObjects;

/**
 * Dieses Interface beschreibt einen Datensammler (Data Miner) welcher aus dem
 * gesamten System Gruppen von bewertebaren Objekten zusammen sucht. Diese
 * Gruppen knnten zum Beispiel im Fall des OCCT sich wiederholende Termine
 * sein.
 * 
 * @author Jens Bothur
 */
public interface IGroupOfRateableObjectsDataMiner {

	/**
	 * Gibt eine Menge von allen Gruppen von bewertbaren Objekten ber das
	 * gesamte System wieder. Diese sollten mglichst adhoc berechnet werden.
	 * 
	 * @return Ein {@link Set} mit allen {@link GroupOfRateableObjects} des
	 *         gesamten Systems.
	 */
	public Set<GroupOfRateableObjects> getAllGroupsOfRateableObjects();

}
