/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.ReviewerGroup;

/**
 * Diese Klasse reprsentiert den Berechner fr den SpamScore bezglich der
 * Gruppengre. Die grten Bewerter-Gruppen erhalten den hchsten Wert und so
 * weiter.
 * 
 * @author Jens Bothur
 */
public class GroupSizeSpamScoreCalculator implements IGroupSpamScoreCalculator {

	/**
	 * Berechnet den SpamScore bezglich der Gruppengre fr eine Menge von
	 * Bewerter-Gruppen. Diese Menge sollten alle Gruppen des Systems sein.
	 * 
	 * @param reviewerGroups
	 *            Ein {@link Set} von {@link ReviewerGroup}. Dies sollten alle
	 *            Bewerter-Gruppen des Systems sein.
	 * @return Eine {@link Map} welche den reviewerGroups ihren jeweiligen
	 *         berechneten SpamScore zuordnet.
	 */
	public static Map<ReviewerGroup, Double> calculateGroupSizeSpamScore(
			Set<ReviewerGroup> reviewerGroups) {
		Map<ReviewerGroup, Double> result = new LinkedHashMap<ReviewerGroup, Double>();

		double largestGroupSize = 0;
		for (ReviewerGroup reviewerGroup : reviewerGroups) {
			int groupSize = reviewerGroup.getMembers().size();
			if (groupSize > largestGroupSize) {
				largestGroupSize = groupSize;
			}
		}
		for (ReviewerGroup reviewerGroup : reviewerGroups) {
			double score = ((double) reviewerGroup.getMembers().size())
					/ largestGroupSize;
			result.put(reviewerGroup, score);
		}

		return result;
	}

}
