/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainobjects;

import jens.bothur.occt.domainvalues.ConfidenceLevel;

/**
 * Diese Klasse reprsentiert einen Benutzer des OCCT. Sie beeinhaltet eine
 * eindeutige ID, welche ein long ist, ein {@link ConfidenceLevel} und der
 * Vollstndigkeit halber einen Namen.
 * 
 * @author Jens Bothur
 */
public class User {

	/**
	 * Die nchste noch nicht benutze Id.
	 */
	private static long _currentId = 0;

	/**
	 * Gibt die nchste noch nicht benutze Id zurck und erhht den Counter.
	 * 
	 * @return die nchste noch nicht benutzte Id als long.
	 */
	private static long nextId() {
		return _currentId++;
	}

	/**
	 * Die ID dieses Benutzers.
	 */
	private final long ID;

	/**
	 * Der Name dieses Benutzers.
	 */
	private final String NAME;

	/**
	 * Das aktuelle Vertrauenslevel dieses Benutzers.
	 */
	private ConfidenceLevel _confidenceLevel;

	/**
	 * Der Constructor um neue Benutzer zu erstellen. Ein neuer Benutzer bekommt
	 * seine Id automatisch zugewiesen und zunchst ein Vertrauenslevel von 1
	 * zugewiesen.
	 * 
	 * @param name
	 *            Der Name des Benutzers als String.
	 */
	public User(String name) {
		ID = nextId();
		NAME = name;
		_confidenceLevel = ConfidenceLevel.getConfidenceLevelByIntTimes10(10);
	}

	/**
	 * Gibt das aktuelle Vertrauenslevel dieses Benutzers zurck.
	 * 
	 * @return Das aktuelle Vertrauenslevel dieses Benutzers.
	 */
	public ConfidenceLevel getConfidenceLevel() {
		return _confidenceLevel;
	}

	/**
	 * Setzt das aktuelle Vertrauenslevel dieses Benutzers.
	 * 
	 * @param _confidenceLevel
	 *            Das neue Vertrauenslevel dieses Benutzers.
	 */
	public void setConfidenceLevel(ConfidenceLevel _confidenceLevel) {
		this._confidenceLevel = _confidenceLevel;
	}

	/**
	 * Gibt die ID dieses Benutzers zurck.
	 * 
	 * @return Die ID dieses Benutzers.
	 */
	public long getID() {
		return ID;
	}

	/**
	 * Gibt den Namen dieses Benutzers zurck.
	 * 
	 * @return Der Name dieses Benutzers.
	 */
	public String getNAME() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (ID ^ (ID >>> 32));
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		User other = (User) obj;
		if (ID != other.ID)
			return false;
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "User [ID=" + ID + ", NAME=" + NAME + "]";
	}

}
