/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainvalues;

import java.util.HashMap;
import java.util.Map;

/**
 * Diese Klasse reprsentiert eine durchschnittliche Bewertung. Eine
 * durchschnittliche Bewertung liegt im Intervall [1;5] und hat maximal eine
 * Nachkommastelle.
 * 
 * 
 * @author Jens Bothur
 */
public class AverageReview {

	/**
	 * Eine {@link Map} welche alle mglichen {@link AverageReview} hlt. Man
	 * beachte das das entsprechende {@link AverageReview} fr eine
	 * durchschnittliche Bewertung = 3,7 unter dem Key = 37 abgelegt ist.
	 */
	private static final Map<Integer, AverageReview> ALL_AVERAGE_REVIEWS;

	/**
	 * Der static-block zum befllen der #ALL_AVERAGE_REVIEWS map.
	 */
	static {
		ALL_AVERAGE_REVIEWS = new HashMap<Integer, AverageReview>();
		for (int i = 10; i <= 50; i++) {
			ALL_AVERAGE_REVIEWS.put(i, new AverageReview(i));
		}
	}

	/**
	 * Die durchschnittliche Bewertung welche dieses {@link AverageReview}
	 * darstellt * 10 als int zurck.
	 */
	private final int _averageRatingTimes10;

	/**
	 * Privater Konstruktor zur erstellung von {@link AverageReview}.
	 * 
	 * @param averageRatingTiems10
	 *            Die durchschnittliche Bewertung *10 als int.
	 */
	private AverageReview(int averageRatingTiems10) {
		_averageRatingTimes10 = averageRatingTiems10;
	}

	/**
	 * Gibt die durchschnittliche Bewertung welche dieses {@link AverageReview}
	 * darstellt * 10 als int.
	 * 
	 * @return Die durchschnittliche Bewertung welche dieses
	 *         {@link AverageReview} darstellt * 10 als int.
	 */
	public int getValueTimes10() {
		return _averageRatingTimes10;
	}

	/**
	 * Gibt die durchschnittliche Bewertung welche dieses {@link AverageReview}
	 * darstellt als double zurck.
	 * 
	 * 
	 * @return Die durchschnittliche Bewertung welche dieses
	 *         {@link AverageReview} darstellt als double.
	 */
	public double getValue() {
		return _averageRatingTimes10 / 10.0;
	}

	/**
	 * Die Factory um ein {@link AverageReview} zu erhalten. Sie wird mit der
	 * gewnschten durchschnittlichen Bewertung *10 als int aufgerufen.
	 * 
	 * @param averageRatingTimes10
	 *            Die durchschnittliche Bewertung * 10 als int.
	 * @return Das entsprechende {@link AverageReview}.
	 */
	public static AverageReview getAverageReviewByIntTimes10(
			Integer averageRatingTimes10) {
		AverageReview result = ALL_AVERAGE_REVIEWS.get(averageRatingTimes10);
		if (result == null) {
			throw new IllegalArgumentException(
					averageRatingTimes10
							+ " is not an allowed confidence level or it cannot be found.");
		}
		return result;
	}

	/**
	 * Die Factory um ein {@link AverageReview} zu erhalten. Sie wird mit der
	 * gewnschten durchschnittlichen Bewertung als double aufgerufen.
	 * 
	 * @param averageRatingTimes10
	 *            Die durchschnittliche Bewertung als double.
	 * @return Das entsprechende {@link AverageReview}.
	 */
	public static AverageReview getAverageReviewByDouble(double averageRating) {
		Integer averageRatingTimes10 = (int) (averageRating * 10);
		return getAverageReviewByIntTimes10(averageRatingTimes10);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "AverageReview [" + getValue() + "]";
	}

	/**
	 * Gibt die durchschnittliche Bewertung dieses {@link AverageRating}s als
	 * double normalisiert auf das Intervall [0;1] wieder.
	 * 
	 * 
	 * @return Die durchschnittliche Bewertung dieses {@link AverageRating}s als
	 *         double normalisiert auf das Intervall [0;1] .
	 */
	public double getNormalizedRating() {
		return ((_averageRatingTimes10 / 10.0) - 1) / 4.0;
	}

}
