/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import jens.bothur.occt.domainobjects.RateableObject;

/**
 * Eine dummy Implementation des {@link IRateableObjectService} Interface.
 * 
 * @author Jens Bothur
 */
public class DummyRateableObjectService implements IRateableObjectService {

	/**
	 * Eine {@link Map} welche alle bewertbaren Objecte ( {@link RateableObject}
	 * ) zur ihren IDs speichert.
	 */
	private Map<Long, RateableObject> _registeredObjects;

	/**
	 * Konstruktor fr den {@link DummyRateableObjectService}.
	 */
	public DummyRateableObjectService() {
		_registeredObjects = new HashMap<Long, RateableObject>();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public RateableObject getRateableObject(long id) {
		return _registeredObjects.get(id);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Collection<RateableObject> getAllRateableObjects() {
		return _registeredObjects.values();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void registerRateableObject(RateableObject rateableObject) {
		_registeredObjects.put(rateableObject.getID(), rateableObject);
	}

}
