/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import jens.bothur.occt.domainobjects.User;

/**
 * Eine dummy Implementation des {@link IUserService} Interface.
 * 
 * @author Jens Bothur
 */
public class DummyUserService implements IUserService {

	/**
	 * Eine {@link Map} welche alle Benutzer ( {@link User} ) zur ihren IDs
	 * speichert.
	 */
	private Map<Long, User> _registeredUser;

	/**
	 * Konstruktor fr den {@link DummyUserService}.
	 */
	public DummyUserService() {
		_registeredUser = new HashMap<Long, User>();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public User getUser(long id) {
		return _registeredUser.get(id);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Collection<User> getAllUsers() {
		return _registeredUser.values();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void registerUser(User newUser) {
		_registeredUser.put(newUser.getID(), newUser);
	}

}
