/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import java.util.Collection;
import java.util.List;

import jens.bothur.occt.domainobjects.User;

/**
 * Interface fr Services welche sich um Benutzer kmmern.
 * 
 * @author Jens Bothur
 */
public interface IUserService {

	/**
	 * Gibt einen Benutzer fr eine bergebene ID zurck.
	 * 
	 * @param id
	 *            Die ID des gesuchten Benutzers als long.
	 * @return Der zur id entsprechende {@link User}, <code>null</code> wenn
	 *         kein Benutzer mit dieser ID existert.
	 */
	public User getUser(long id);

	/**
	 * Gibt eine Sammlung mit allen Benutzern zurck.
	 * 
	 * @return Eine {@link List} von {@link User}n.
	 */
	public Collection<User> getAllUsers();

	/**
	 * Legt einen neuen Benutzer im System an.
	 * 
	 * @param newUser
	 *            Ein {@link User} der dem System hinzugefgt werden soll.
	 */
	public void registerUser(User newUser);

}
