/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.ReviewerGroup;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link GroupSupportCountSpamScoreCalculatorTest}
 * 
 * @author Jens Bothur
 */
public class GroupSupportCountSpamScoreCalculatorTest {

	private Set<ReviewerGroup> _reviewerGroups;

	private ReviewerGroup _group1;
	private ReviewerGroup _group2;
	private ReviewerGroup _group3;
	private ReviewerGroup _group4;

	private final User USER1 = new User("1");
	private final User USER2 = new User("2");

	private final RateableObject OBJECT1 = new RateableObject();
	private final RateableObject OBJECT2 = new RateableObject();
	private final RateableObject OBJECT3 = new RateableObject();
	private final RateableObject OBJECT4 = new RateableObject();
	private final RateableObject OBJECT5 = new RateableObject();
	private final RateableObject OBJECT6 = new RateableObject();
	private final RateableObject OBJECT7 = new RateableObject();
	private final RateableObject OBJECT8 = new RateableObject();

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial" })
	@Before
	public void setUp() throws Exception {

		OBJECT1.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT4.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT5.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT6.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT7.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT8.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT4.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT5.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT6.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT7.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT8.rate(USER2, Review.ONE_STAR_REVIEW, new Date());

		_group1 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		_group2 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
				add(OBJECT4);
			}
		});

		_group3 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
				add(OBJECT4);
				add(OBJECT5);
				add(OBJECT6);
				add(OBJECT7);
			}
		});

		_group4 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
				add(OBJECT4);
				add(OBJECT5);
				add(OBJECT6);
				add(OBJECT7);
				add(OBJECT8);
			}
		});

		_reviewerGroups = new LinkedHashSet<ReviewerGroup>() {
			{
				add(_group1);
				add(_group2);
				add(_group3);
				add(_group4);
			}
		};
	}

	@Test
	public void testCalculate() {
		Map<ReviewerGroup, Double> calculateGroupSupportCountSpamScore = GroupSupportCountSpamScoreCalculator
				.calculateGroupSupportCountSpamScore(_reviewerGroups);
		// Gruppe 1 sollte einen SCore von 3/8 = 0.25 erhalten.
		assertTrue(0.375 == calculateGroupSupportCountSpamScore.get(_group1));
		// Gruppe 2 sollte einen SCore von 4/8 = 0.375 erhalten.
		assertTrue(0.5 == calculateGroupSupportCountSpamScore.get(_group2));
		// Gruppe 3 sollte einen SCore von 7/8 = 0.875 erhalten.
		assertTrue(0.875 == calculateGroupSupportCountSpamScore.get(_group3));
		// Gruppe 4 sollte einen SCore von 8/8 = 1.0 erhalten.
		assertTrue(1.0 == calculateGroupSupportCountSpamScore.get(_group4));

	}

}
