/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.group_calculators;

import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.ReviewerGroup;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr Klasse: {@link TimeWindowSpamScoreCalculator}.
 * 
 * @author Jens Bothur
 */
public class TimeWindowSpamScoreCalculatorTest {

	private Set<ReviewerGroup> _reviewerGroups;

	private ReviewerGroup _group1;
	private ReviewerGroup _group2;
	private ReviewerGroup _group3;

	private final User USER1 = new User("1");
	private final User USER2 = new User("2");
	private final User USER3 = new User("3");

	private final RateableObject OBJECT1 = new RateableObject();
	private final RateableObject OBJECT2 = new RateableObject();
	private final RateableObject OBJECT3 = new RateableObject();
	private final RateableObject OBJECT3a = new RateableObject();
	private final RateableObject OBJECT4 = new RateableObject();
	private final RateableObject OBJECT5 = new RateableObject();
	private final RateableObject OBJECT6 = new RateableObject();
	private final RateableObject OBJECT7 = new RateableObject();
	private final RateableObject OBJECT8 = new RateableObject();

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial", "deprecation" })
	@Before
	public void setUp() throws Exception {

		OBJECT1.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER1, Review.ONE_STAR_REVIEW, new Date());
		OBJECT1.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT2.rate(USER2, Review.ONE_STAR_REVIEW, new Date());
		OBJECT3.rate(USER2, Review.ONE_STAR_REVIEW, new Date());

		_group1 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT1);
				add(OBJECT2);
				add(OBJECT3);
			}
		});

		OBJECT3a.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3,
				30, 17, 22, 22));
		OBJECT4.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				18, 22, 22));
		OBJECT5.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				19, 22, 22));
		OBJECT3a.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3,
				30, 20, 22, 22));
		OBJECT4.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				22, 22, 22));
		OBJECT5.rate(USER3, Review.ONE_STAR_REVIEW, new Date(84, 3, 31,
				0, 22, 22));

		_group2 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER3);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT3a);
				add(OBJECT4);
				add(OBJECT5);
			}
		});

		OBJECT6.rate(USER1, Review.ONE_STAR_REVIEW, new Date(84, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER1, Review.ONE_STAR_REVIEW, new Date(85, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER1, Review.ONE_STAR_REVIEW, new Date(86, 3, 30,
				17, 22, 22));
		OBJECT6.rate(USER2, Review.ONE_STAR_REVIEW, new Date(87, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER2, Review.ONE_STAR_REVIEW, new Date(88, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER2, Review.ONE_STAR_REVIEW, new Date(89, 3, 30,
				17, 22, 22));
		OBJECT6.rate(USER3, Review.ONE_STAR_REVIEW, new Date(90, 3, 30,
				17, 22, 22));
		OBJECT7.rate(USER3, Review.ONE_STAR_REVIEW, new Date(91, 3, 30,
				17, 22, 22));
		OBJECT8.rate(USER3, Review.ONE_STAR_REVIEW, new Date(92, 3, 30,
				17, 22, 22));

		_group3 = new ReviewerGroup(new LinkedHashSet<User>() {
			{
				add(USER1);
				add(USER2);
				add(USER3);
			}
		}, new LinkedHashSet<RateableObject>() {
			{
				add(OBJECT6);
				add(OBJECT7);
				add(OBJECT8);
			}
		});

		_reviewerGroups = new LinkedHashSet<ReviewerGroup>() {
			{
				add(_group1);
				add(_group2);
				add(_group3);
			}
		};
	}

	@Test
	public void test() {
		Map<ReviewerGroup, Double> calculatedTimeWindowSpamScore = TimeWindowSpamScoreCalculator
				.calculateTimeWindowSpamScore(_reviewerGroups);
		// Gruppe 1 msste einen SpamScore von 1.0 erhalten haben, da alle
		// Bewertungen ind er gleichen Millisekunde stattfinden.
		assertTrue(1.0 == calculatedTimeWindowSpamScore.get(_group1));
		// Gruppe 2 msste einen SpamScore von 0.75 erhalten haben, da im
		// schlechtesten Fall die Bewertungen 3 Stunden auseinander liegen.
		assertTrue(0.75 == calculatedTimeWindowSpamScore.get(_group2));
		// Gruppe 1 msste einen SpamScore von 0.0 erhalten haben, da alle
		// Bewertungen jeweils 1 Jahr auseinander liegen.
		assertTrue(0.0 == calculatedTimeWindowSpamScore.get(_group3));
	}

}
