/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.single_calculators;

import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.automatons.security_framework.single_calculators.EarlyDeviationCalculator;
import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.AverageReview;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr Klasse: {@link EarlyDeviationCalculatorTest}.
 * 
 * @author Jens Bothur
 */
public class EarlyDeviationCalculatorTest {

	private final User _user1 = new User("a");
	private final User _user2 = new User("b");
	private final User _user3 = new User("c");

	private final RateableObject _object1 = new RateableObject();
	private final RateableObject _object2 = new RateableObject();
	private final RateableObject _object3 = new RateableObject();

	private Set<RateableObject> _user1sSet;
	private Set<RateableObject> _user2sSet;
	private Set<RateableObject> _user3sSet;

	private Map<User, Set<RateableObject>> _usersToRatedObjects;

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial", "deprecation" })
	@Before
	public void setUp() throws Exception {
		// durchschnittsbewertungen der Objekte setzen
		_object1.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(20));
		_object2.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(30));
		_object3.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(40));
		// user1 raten lassen und sein set bauen
		_object1.rate(_user1, Review.ONE_STAR_REVIEW, new Date(1, 1, 1));
		_object2.rate(_user1, Review.ONE_STAR_REVIEW, new Date(1, 1, 2));
		_object3.rate(_user1, Review.ONE_STAR_REVIEW, new Date(1, 1, 3));
		_user1sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
				add(_object3);
			}
		};
		// user2 raten lassen und sein set bauen
		_object1.rate(_user2, Review.FIVE_STAR_REVIEW,
				new Date(2, 1, 1));
		_object2.rate(_user2, Review.FIVE_STAR_REVIEW,
				new Date(2, 1, 2));
		_user2sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
			}
		};
		// user3 raten lassen und sein set bauen
		_object1.rate(_user3, Review.TWO_STAR_REVIEW, new Date(3, 1, 1));
		_object2.rate(_user3, Review.THREE_STAR_REVIEW, new Date(3, 1,
				2));
		_object3.rate(_user3, Review.FOUR_STAR_REVIEW,
				new Date(3, 1, 3));
		_user3sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
				add(_object3);
			}
		};
		// und zuletzt die map bauen
		_usersToRatedObjects = new LinkedHashMap<User, Set<RateableObject>>() {
			{
				put(_user1, _user1sSet);
				put(_user2, _user2sSet);
				put(_user3, _user3sSet);
			}
		};
	}

	@Test
	public void testCalculateEarlyDeviation() {
		Map<User, Double> result = EarlyDeviationCalculator
				.calculateEarlyDeviation(_usersToRatedObjects);
		assertTrue(result.get(_user1) == 0.5);
		assertTrue(result.get(_user2) < 0.5);
		assertTrue(result.get(_user2) > 0);
		assertTrue(result.get(_user3) == 0);
	}
}
