/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.single_calculators;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.automatons.security_framework.single_calculators.GeneralDeviationCalculator;
import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.AverageReview;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link GeneralDeviationCalculator}.
 * 
 * @author Jens Bothur
 */
public class GeneralDeviationCalculatorTest {

	private final User _user1 = new User("a");
	private final User _user2 = new User("b");
	private final User _user3 = new User("c");

	private final RateableObject _object1 = new RateableObject();
	private final RateableObject _object2 = new RateableObject();
	private final RateableObject _object3 = new RateableObject();

	private Set<RateableObject> _user1sSet;
	private Set<RateableObject> _user2sSet;
	private Set<RateableObject> _user3sSet;

	private Map<User, Set<RateableObject>> _usersToRatedObjects;

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings("serial")
	@Before
	public void setUp() throws Exception {
		// durchschnittsbewertungen der Objekte setzen
		_object1.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(20));
		_object2.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(30));
		_object3.setAverageReview(AverageReview
				.getAverageReviewByIntTimes10(40));
		// user1 raten lassen und sein set bauen
		_object1.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object2.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_object3.rate(_user1, Review.ONE_STAR_REVIEW, new Date());
		_user1sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
				add(_object3);
			}
		};
		// user2 raten lassen und sein set bauen
		_object1.rate(_user2, Review.FIVE_STAR_REVIEW, new Date());
		_object2.rate(_user2, Review.FIVE_STAR_REVIEW, new Date());
		_user2sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
			}
		};
		// user3 raten lassen und sein set bauen
		_object1.rate(_user3, Review.TWO_STAR_REVIEW, new Date());
		_object2.rate(_user3, Review.THREE_STAR_REVIEW, new Date());
		_object3.rate(_user3, Review.FOUR_STAR_REVIEW, new Date());
		_user3sSet = new LinkedHashSet<RateableObject>() {
			{
				add(_object1);
				add(_object2);
				add(_object3);
			}
		};
		// und zuletzt die map bauen
		_usersToRatedObjects = new LinkedHashMap<User, Set<RateableObject>>() {
			{
				put(_user1, _user1sSet);
				put(_user2, _user2sSet);
				put(_user3, _user3sSet);
			}
		};
	}

	@Test
	public void testCalculateGeneralDeviationForUser() {
		// diese private Methode wird per Reflection getestet
		try {
			Method calculateGeneralDeviationForUser = GeneralDeviationCalculator.class
					.getDeclaredMethod("calculateGeneralDeviationForUser",
							User.class, Set.class);
			calculateGeneralDeviationForUser.setAccessible(true);
			try {
				double user1sResult = (Double) calculateGeneralDeviationForUser
						.invoke(null, _user1, _user1sSet);
				double user2sResult = (Double) calculateGeneralDeviationForUser
						.invoke(null, _user2, _user2sSet);
				double user3sResult = (Double) calculateGeneralDeviationForUser
						.invoke(null, _user3, _user3sSet);
				// user 1 msste ein ergebnis von 0,5 bekommen (0,25+0,5+0,75)/3
				assertTrue(0.5 == user1sResult);
				// user 2 msste ein ergebnis von 0,625 bekommen (0,75 + 0,5)/2
				assertTrue(0.625 == user2sResult);
				// user 3 msste ein erbegnis von 0,0 bekommen (0+0+0)/3
				assertTrue(0.0 == user3sResult);

			} catch (IllegalArgumentException e) {
				e.printStackTrace();
				assertTrue(false);
			} catch (IllegalAccessException e) {
				assertTrue(false);
			} catch (InvocationTargetException e) {
				e.printStackTrace();
				assertTrue(false);
			}
		} catch (SecurityException e) {
			assertTrue(false);
		} catch (NoSuchMethodException e) {
			assertTrue(false);
		}
	}

	@Test
	public void testCalculateGeneralDeviation() {
		Map<User, Double> expectedResult = new LinkedHashMap<User, Double>();
		expectedResult.put(_user1, 0.5);
		expectedResult.put(_user2, 0.625);
		expectedResult.put(_user3, 0.0);
		assertEquals(expectedResult,
				GeneralDeviationCalculator
						.calculateGeneralDeviation(_usersToRatedObjects));
	}
}
